/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.rename;

import org.rubypeople.rdt.refactoring.core.IRefactoringConfig;
import org.rubypeople.rdt.refactoring.core.RefactoringConditionChecker;
import org.rubypeople.rdt.refactoring.core.rename.Messages;
import org.rubypeople.rdt.refactoring.core.rename.RenameConfig;
import org.rubypeople.rdt.refactoring.core.renameclass.RenameClassConditionChecker;
import org.rubypeople.rdt.refactoring.core.renameclass.RenameClassConfig;
import org.rubypeople.rdt.refactoring.core.renamefield.RenameFieldConditionChecker;
import org.rubypeople.rdt.refactoring.core.renamefield.RenameFieldConfig;
import org.rubypeople.rdt.refactoring.core.renamelocal.RenameLocalConditionChecker;
import org.rubypeople.rdt.refactoring.core.renamelocal.RenameLocalConfig;
import org.rubypeople.rdt.refactoring.core.renamemethod.RenameMethodConditionChecker;
import org.rubypeople.rdt.refactoring.core.renamemethod.RenameMethodConfig;
import org.rubypeople.rdt.refactoring.core.renamemodule.RenameModuleConditionChecker;
import org.rubypeople.rdt.refactoring.core.renamemodule.RenameModuleConfig;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;

public class RenameConditionChecker
extends RefactoringConditionChecker {
    private RenameType selectedType;
    private RenameLocalConditionChecker localConditionChecker;
    private RefactoringConditionChecker fieldConditionChecker;
    private RefactoringConditionChecker methodConditionChecker;
    private RefactoringConditionChecker classConditionChecker;
    private RefactoringConditionChecker moduleConditionChecker;

    public RenameConditionChecker(RenameConfig config) {
        super(config);
    }

    protected void checkInitialConditions() {
        if (this.selectedType == RenameType.INVALID) {
            this.addErrorMessage();
        }
    }

    private void addErrorMessage() {
        this.addErrorIfNotDefaultError(this.localConditionChecker, RenameLocalConditionChecker.DEFAULT_ERROR);
        this.addErrorIfNotDefaultError(this.fieldConditionChecker, RenameFieldConditionChecker.DEFAULT_ERROR);
        this.addErrorIfNotDefaultError(this.methodConditionChecker, RenameMethodConditionChecker.DEFAULT_ERROR);
        this.addErrorIfNotDefaultError(this.classConditionChecker, RenameClassConditionChecker.DEFAULT_ERROR);
        this.addErrorIfNotDefaultError(this.moduleConditionChecker, RenameClassConditionChecker.DEFAULT_ERROR);
        if (!this.hasErrors()) {
            this.addError(Messages.RenameConditionChecker_NothingSelected);
        }
    }

    private void addErrorIfNotDefaultError(RefactoringConditionChecker checker, String defaultError) {
        String firstError = checker.getInitialMessages().get("errors").toArray(new String[0])[0];
        if (!firstError.equals(defaultError)) {
            this.addError(firstError);
        }
    }

    public void init(IRefactoringConfig configObj) {
        RenameConfig config = (RenameConfig)configObj;
        int offset = config.getOffset();
        IDocumentProvider doc = config.getDocumentProvider();
        this.localConditionChecker = new RenameLocalConditionChecker(new RenameLocalConfig(doc, offset));
        this.fieldConditionChecker = new RenameFieldConditionChecker(new RenameFieldConfig(doc, offset));
        this.methodConditionChecker = new RenameMethodConditionChecker(new RenameMethodConfig(doc, offset));
        this.classConditionChecker = new RenameClassConditionChecker(new RenameClassConfig(doc, offset));
        this.moduleConditionChecker = new RenameModuleConditionChecker(new RenameModuleConfig(doc, offset));
        this.selectedType = this.localConditionChecker.shouldPerform() ? RenameType.LOCAL : (this.fieldConditionChecker.shouldPerform() ? RenameType.FIELD : (this.methodConditionChecker.shouldPerform() ? RenameType.METHOD : (this.classConditionChecker.shouldPerform() ? RenameType.CLASS : (this.moduleConditionChecker.shouldPerform() ? RenameType.MODULE : RenameType.INVALID))));
    }

    public boolean shouldRenameLocal() {
        return this.selectedType == RenameType.LOCAL;
    }

    public boolean shouldRenameField() {
        return this.selectedType == RenameType.FIELD;
    }

    public boolean shouldRenameMethod() {
        return this.selectedType == RenameType.METHOD;
    }

    public boolean shouldRenameClass() {
        return this.selectedType == RenameType.CLASS;
    }

    public boolean shouldRenameModule() {
        return this.selectedType == RenameType.MODULE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RenameType {
        INVALID,
        LOCAL,
        FIELD,
        METHOD,
        CLASS,
        MODULE;

    }
}

