/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.overridemethod;

import java.util.Collection;
import org.jruby.ast.BlockNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.core.NodeFactory;
import org.rubypeople.rdt.refactoring.editprovider.InsertEditProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.offsetprovider.ConstructorOffsetProvider;
import org.rubypeople.rdt.refactoring.offsetprovider.MethodOffsetProvider;
import org.rubypeople.rdt.refactoring.offsetprovider.OffsetProvider;
import org.rubypeople.rdt.refactoring.signatureprovider.MethodSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverriddenMethod
extends InsertEditProvider {
    private MethodSignature signature;
    private ClassNodeWrapper classNode;

    public OverriddenMethod(ClassNodeWrapper classNode, MethodSignature signature) {
        super(true);
        this.signature = signature;
        this.classNode = classNode;
        this.lastEditInGroup = false;
    }

    @Override
    protected int getOffset(String document) {
        OffsetProvider offsetProvider = this.signature.isConstructor() ? new ConstructorOffsetProvider(this.classNode, document) : new MethodOffsetProvider(this.classNode, document);
        return offsetProvider.getOffset();
    }

    protected BlockNode getInsertNode(int offset, String document) {
        boolean needsNewLineAtEndOfBlock = this.lastEditInGroup && !this.isNextLineEmpty(offset, document);
        BlockNode blockNode = NodeFactory.createBlockNode(needsNewLineAtEndOfBlock, this.getMethodNode());
        return blockNode;
    }

    private Node getMethodNode() {
        String methodName = this.signature.getMethodName();
        Collection<String> args = this.signature.getArguments();
        Node methodNode = this.getMethodNode(methodName, args);
        return methodNode;
    }

    private Node getMethodNode(String methodName, Collection<String> args) {
        DefnNode methodNode = NodeFactory.createMethodNode(methodName, args.toArray(new String[args.size()]), NodeFactory.createSuperNode(args));
        return NodeFactory.createNewLineNode((Node)methodNode);
    }
}

