/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.overridemethod;

import java.util.ArrayList;
import java.util.Collection;
import org.rubypeople.rdt.refactoring.classnodeprovider.ClassNodeProvider;
import org.rubypeople.rdt.refactoring.classnodeprovider.IncludedClassesProvider;
import org.rubypeople.rdt.refactoring.core.overridemethod.OverriddenMethod;
import org.rubypeople.rdt.refactoring.documentprovider.DocumentProvider;
import org.rubypeople.rdt.refactoring.editprovider.EditAndTreeContentProvider;
import org.rubypeople.rdt.refactoring.editprovider.EditProvider;
import org.rubypeople.rdt.refactoring.editprovider.EditProviderGroups;
import org.rubypeople.rdt.refactoring.editprovider.ITreeClass;
import org.rubypeople.rdt.refactoring.exception.UnknownClassNameException;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.signatureprovider.ClassSignatureProvider;
import org.rubypeople.rdt.refactoring.signatureprovider.IClassSignatureProvider;
import org.rubypeople.rdt.refactoring.signatureprovider.MethodSignature;
import org.rubypeople.rdt.refactoring.ui.IChildrenProvider;
import org.rubypeople.rdt.refactoring.ui.IItemSelectionReceiver;
import org.rubypeople.rdt.refactoring.ui.IParentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodsOverrider
extends EditAndTreeContentProvider
implements IItemSelectionReceiver {
    private ClassNodeProvider superClassNodeProvider;
    private Object[] selectedTreeItems;

    public MethodsOverrider(DocumentProvider docProvider) {
        this.superClassNodeProvider = docProvider.getClassNodeProvider();
        IncludedClassesProvider includedClassesProvider = new IncludedClassesProvider(docProvider);
        if (includedClassesProvider != null) {
            this.superClassNodeProvider.addClassNodeProvider(includedClassesProvider);
        }
        this.initTreeClasses(docProvider.getClassNodeProvider());
    }

    @Override
    public Collection<EditProvider> getEditProviders() {
        EditProviderGroups editProviderGroups = new EditProviderGroups();
        if (this.selectedTreeItems != null) {
            Object[] objectArray = this.selectedTreeItems;
            int n = this.selectedTreeItems.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof TreeClass.TreeMethod) {
                    TreeClass.TreeMethod treeMethod = (TreeClass.TreeMethod)o;
                    editProviderGroups.add(treeMethod.getSignatureGroup(), treeMethod.getOverriddenMethod());
                }
                ++n2;
            }
        }
        return editProviderGroups.getAllEditProviders();
    }

    private IClassSignatureProvider getSuperSignatureProvider(ClassNodeWrapper classNode) throws UnknownClassNameException {
        String superClassName = "";
        superClassName = classNode.getSuperClassName();
        return ClassSignatureProvider.getClassSignatureProvider(superClassName, this.superClassNodeProvider);
    }

    @Override
    public void setSelectedItems(Object[] checkedElements) {
        this.selectedTreeItems = (Object[])checkedElements.clone();
    }

    @Override
    protected ITreeClass createTreeClass(ClassNodeWrapper classNode) {
        return new TreeClass(classNode);
    }

    public class TreeClass
    implements IChildrenProvider,
    ITreeClass {
        private ClassNodeWrapper classNode;
        private Collection<TreeMethod> treeMethods;

        public TreeClass(ClassNodeWrapper classNode) {
            this.classNode = classNode;
            this.treeMethods = new ArrayList<TreeMethod>();
            try {
                IClassSignatureProvider superClassSignatureProvider = MethodsOverrider.this.getSuperSignatureProvider(classNode);
                for (MethodSignature sign : superClassSignatureProvider.getMethodSignatures()) {
                    this.treeMethods.add(new TreeMethod(sign));
                }
            }
            catch (UnknownClassNameException unknownClassNameException) {}
        }

        public String toString() {
            return this.classNode.getName();
        }

        public Object[] getChildren() {
            return this.treeMethods.toArray();
        }

        public boolean hasChildren() {
            return !this.treeMethods.isEmpty();
        }

        public class TreeMethod
        implements IParentProvider {
            private MethodSignature methodSignature;
            private String name;

            public TreeMethod(MethodSignature methodSignature) {
                this.methodSignature = methodSignature;
                this.name = this.getName();
            }

            public String getSignatureGroup() {
                if (this.methodSignature.isConstructor()) {
                    return "c_" + TreeClass.this.toString();
                }
                return TreeClass.this.toString();
            }

            public OverriddenMethod getOverriddenMethod() {
                return new OverriddenMethod(TreeClass.this.classNode, this.methodSignature);
            }

            private String getName() {
                return this.methodSignature.getNameWithArgs();
            }

            public String toString() {
                return this.name;
            }

            public Object getParent() {
                return TreeClass.this;
            }
        }
    }
}

