/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.movemethod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Observable;
import org.rubypeople.rdt.refactoring.classnodeprovider.ClassNodeProvider;
import org.rubypeople.rdt.refactoring.core.IRefactoringConfig;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.ArgsNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.VisibilityNodeWrapper;
import org.rubypeople.rdt.refactoring.util.NameHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveMethodConfig
extends Observable
implements IRefactoringConfig {
    private IDocumentProvider docProvider;
    private int caretPosition;
    private MethodNodeWrapper methodNode;
    private ClassNodeWrapper sourceClassNode;
    private ClassNodeProvider allClassesNodeProvider;
    private ClassNodeWrapper destinationClassNode;
    private String fieldInSourceClassOfTypeDestinationClass;
    private String fieldInDestinationClassOfTypeSourceClass;
    private VisibilityNodeWrapper.METHOD_VISIBILITY movedMethodVisibility;
    private VisibilityNodeWrapper.METHOD_VISIBILITY methodVisibility;
    private Collection<String> targetClassNames;
    private Collection<String> fieldInSourceClassOfTypeDestinationClassNames;
    private boolean leaveDelegateMethodInSoruce;
    private boolean newMethodHasReferenceToSourceClass;
    private boolean sourceClassHasCallsToMovingMethod;
    private ArgsNodeWrapper movedMethodArgs;
    private String movedMethodName;
    private Collection<String> warnings;

    public MoveMethodConfig(IDocumentProvider docProvider, int caretPosition) {
        this.docProvider = docProvider;
        this.caretPosition = caretPosition;
        this.warnings = new ArrayList<String>();
    }

    public boolean doesNewMethodNeedsReferenceToSourceClass() {
        return this.newMethodHasReferenceToSourceClass;
    }

    public void setNewMethodNeedsReferenceToSourceClass(boolean newMethodNeedsReferenceToSourceClass) {
        this.newMethodHasReferenceToSourceClass = newMethodNeedsReferenceToSourceClass;
    }

    public String getFieldInSourceClassOfTypeDestinationClass() {
        return this.fieldInSourceClassOfTypeDestinationClass;
    }

    public void setFieldInSourceClassOfTypeDestinationClass(String fieldOfDestinationClassType) {
        this.fieldInSourceClassOfTypeDestinationClass = fieldOfDestinationClassType;
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public IDocumentProvider getDocumentProvider() {
        return this.docProvider;
    }

    public boolean isClassMethod() {
        return this.methodNode.isClassMethod();
    }

    public ClassNodeProvider getAllClassesNodeProvider() {
        return this.allClassesNodeProvider;
    }

    public void setAllClassesNodeProvider(ClassNodeProvider allClassesNodeProvider) {
        this.allClassesNodeProvider = allClassesNodeProvider;
    }

    public ClassNodeWrapper getDestinationClassNode() {
        return this.destinationClassNode;
    }

    public void setDestinationClassNode(String aktClassName) {
        this.destinationClassNode = this.allClassesNodeProvider.getClassNode(aktClassName);
        this.movedMethodName = this.initMovedMethodName();
        this.setChanged();
        this.notifyObservers();
    }

    private String initMovedMethodName() {
        String name = this.getMethodNode().getName();
        while (NameHelper.methodnameExistsInClass(name, this.destinationClassNode)) {
            name = NameHelper.createName(name);
        }
        return name;
    }

    public MethodNodeWrapper getMethodNode() {
        return this.methodNode;
    }

    public void setMethodNode(MethodNodeWrapper methodNode) {
        this.methodNode = methodNode;
        if (methodNode != null) {
            this.movedMethodArgs = methodNode.getArgsNode();
            this.movedMethodName = methodNode.getName();
        }
    }

    public ClassNodeWrapper getSourceClassNode() {
        return this.sourceClassNode;
    }

    public void setSourceClassNode(String sourceClassName) {
        this.sourceClassNode = this.allClassesNodeProvider.getClassNode(sourceClassName);
    }

    public int getCaretPosition() {
        return this.caretPosition;
    }

    public String getFieldInDestinationClassOfTypeSourceClass() {
        return this.fieldInDestinationClassOfTypeSourceClass;
    }

    public void setFieldInDestinationClassOfTypeSourceClass(String fieldInDestinationClassOfTypeSourceClass) {
        this.fieldInDestinationClassOfTypeSourceClass = fieldInDestinationClassOfTypeSourceClass;
    }

    public boolean leaveDelegateMethodInSource() {
        return this.leaveDelegateMethodInSoruce;
    }

    public void setLeaveDelegateMethodInSource(boolean leaveDelegateMethodInSoruce) {
        this.leaveDelegateMethodInSoruce = leaveDelegateMethodInSoruce;
        this.setChanged();
        this.notifyObservers();
    }

    public VisibilityNodeWrapper.METHOD_VISIBILITY getMovedMethodVisibility() {
        return this.movedMethodVisibility;
    }

    public void setMovedMethodVisibility(VisibilityNodeWrapper.METHOD_VISIBILITY neededMethodVisibility) {
        this.movedMethodVisibility = neededMethodVisibility;
    }

    public VisibilityNodeWrapper.METHOD_VISIBILITY getMethodVisibility() {
        return this.methodVisibility;
    }

    public void setMethodVisibility(VisibilityNodeWrapper.METHOD_VISIBILITY methodVisibility) {
        this.methodVisibility = methodVisibility;
    }

    public Collection<String> getTargetClassNames() {
        return this.targetClassNames;
    }

    public void setTargetClassNames(Collection<String> targetClassNames) {
        this.targetClassNames = targetClassNames;
    }

    public Collection<String> getFieldInSourceClassOfTypeDestinationClassNames() {
        return this.fieldInSourceClassOfTypeDestinationClassNames;
    }

    public void setFieldInSourceClassOfTypeDestinationClassNames(Collection<String> fieldInSourceClassOfTypeDestinationClassNames) {
        this.fieldInSourceClassOfTypeDestinationClassNames = fieldInSourceClassOfTypeDestinationClassNames;
    }

    public boolean doesSourceClassHasCallsToMovingMethod() {
        return this.sourceClassHasCallsToMovingMethod;
    }

    public void setSourceClassHasCallsToMovingMethod(boolean value) {
        this.sourceClassHasCallsToMovingMethod = value;
    }

    public ArgsNodeWrapper getMovedMethodArgs() {
        return this.movedMethodArgs;
    }

    public String getMovedMethodName() {
        return this.movedMethodName;
    }

    public void setMovedMethodName(String name) {
        this.movedMethodName = name;
    }

    public void setMovedMethodArgs(ArgsNodeWrapper movedMethodArgs) {
        this.movedMethodArgs = movedMethodArgs;
    }

    public boolean needsSecondPage() {
        boolean isPrivate = this.sourceClassNode.getMethodVisibility(this.methodNode).equals((Object)VisibilityNodeWrapper.METHOD_VISIBILITY.PRIVATE);
        boolean isClassMethod = this.methodNode.isClassMethod();
        return !isClassMethod && (!isPrivate || this.sourceClassHasCallsToMovingMethod);
    }

    public boolean canCreateDelegateMethod() {
        return this.needsSecondPage() || this.methodNode.isClassMethod();
    }

    public Collection<String> getWarnings() {
        return this.warnings;
    }

    public void addWarning(String warning) {
        this.warnings.add(warning);
    }

    public void resetWarnings() {
        this.warnings.clear();
    }

    @Override
    public void setDocumentProvider(IDocumentProvider doc) {
        this.docProvider = doc;
    }
}

