/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.movemethod;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.rubypeople.rdt.refactoring.core.IRefactoringConfig;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.RefactoringConditionChecker;
import org.rubypeople.rdt.refactoring.core.SelectionNodeProvider;
import org.rubypeople.rdt.refactoring.core.movemethod.Messages;
import org.rubypeople.rdt.refactoring.core.movemethod.MoveMethodConfig;
import org.rubypeople.rdt.refactoring.exception.NoClassNodeException;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.FieldNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.VisibilityNodeWrapper;

public class MoveMethodConditionChecker
extends RefactoringConditionChecker {
    private MoveMethodConfig config;

    public MoveMethodConditionChecker(MoveMethodConfig config) {
        super(config);
    }

    public void init(IRefactoringConfig configObj) {
        this.config = (MoveMethodConfig)configObj;
        RootNode rootNode = this.config.getDocumentProvider().getActiveFileRootNode();
        int caretPos = this.config.getCaretPosition();
        this.config.setAllClassesNodeProvider(this.config.getDocumentProvider().getProjectClassNodeProvider());
        try {
            ClassNodeWrapper selectedClassPart = SelectionNodeProvider.getSelectedClassNode((Node)rootNode, caretPos);
            this.config.setSourceClassNode(selectedClassPart.getName());
        }
        catch (NoClassNodeException noClassNodeException) {}
        MethodDefNode methodDefNode = (MethodDefNode)SelectionNodeProvider.getSelectedNodeOfType((Node)rootNode, caretPos, MethodDefNode.class);
        MethodNodeWrapper methodNode = methodDefNode == null ? null : new MethodNodeWrapper(methodDefNode, this.config.getSourceClassNode());
        this.config.setMethodNode(methodNode);
        this.initTargetClassNames();
        if (this.config.getSourceClassNode() != null) {
            this.initFieldInSourceClassOfTypeDestinationClassNames();
        }
    }

    private void initTargetClassNames() {
        ArrayList<ClassNodeWrapper> forbiddenClassNodes = new ArrayList<ClassNodeWrapper>();
        forbiddenClassNodes.addAll(this.config.getAllClassesNodeProvider().getClassAndAllSubClasses(this.config.getSourceClassNode()));
        forbiddenClassNodes.addAll(this.config.getAllClassesNodeProvider().getClassAndAllSuperClasses(this.config.getSourceClassNode()));
        TreeSet<String> classNames = new TreeSet<String>();
        for (ClassNodeWrapper aktClassNode : this.config.getAllClassesNodeProvider().getAllClassNodes()) {
            if (forbiddenClassNodes.contains(aktClassNode)) continue;
            classNames.add(aktClassNode.getName());
        }
        this.config.setTargetClassNames(classNames);
    }

    private void initFieldInSourceClassOfTypeDestinationClassNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (FieldNodeWrapper aktField : this.config.getSourceClassNode().getFields()) {
            if (aktField.getNodeType() == 5) {
                names.add(String.valueOf('@') + aktField.getName());
                continue;
            }
            if (!aktField.isInstVar()) continue;
            names.add(aktField.getName());
        }
        this.config.setFieldInSourceClassOfTypeDestinationClassNames(names);
    }

    protected void checkInitialConditions() {
        if (this.config.getSourceClassNode() == null) {
            this.addError(Messages.MoveMethodConditionChecker_NeedsToBeInsideClass);
        } else if (this.config.getMethodNode() == null) {
            this.addError(Messages.MoveMethodConditionChecker_NeedsToBeInsideMethod);
        } else if (this.isConstructor()) {
            this.addError(Messages.MoveMethodConditionChecker_CannotMoveConstructor);
        } else if (!this.hasTargetClass()) {
            this.addError(Messages.MoveMethodConditionChecker_NoTarget);
        } else if (!this.hasFieldToSelect()) {
            this.addError(Messages.MoveMethodConditionChecker_NoFieldOfTargetType);
        }
    }

    private boolean hasFieldToSelect() {
        return !this.config.needsSecondPage() || !this.config.getFieldInSourceClassOfTypeDestinationClassNames().isEmpty();
    }

    private boolean hasTargetClass() {
        return !this.config.getTargetClassNames().isEmpty();
    }

    private boolean isConstructor() {
        MethodNodeWrapper selectedMethod = this.config.getMethodNode();
        return selectedMethod != null && selectedMethod.isConstructor();
    }

    protected void checkFinalConditions() {
        this.checkMethodContainsClassFields();
        this.checkIsMethodPublicAndNoDelegateMethod();
        this.addConfigWarnings();
    }

    private void checkIsMethodPublicAndNoDelegateMethod() {
        boolean isPrivate = this.config.getSourceClassNode().getMethodVisibility(this.config.getMethodNode()).equals((Object)VisibilityNodeWrapper.METHOD_VISIBILITY.PRIVATE);
        if (!isPrivate && !this.config.leaveDelegateMethodInSource()) {
            this.addWarning(String.valueOf(Messages.MoveMethodConditionChecker_TheMethod) + this.config.getMethodNode().getName() + Messages.MoveMethodConditionChecker_CanBeCalledFromOutside + this.config.getSourceClassNode() + Messages.MoveMethodConditionChecker_MightNotGetReplaced + this.config.getDestinationClassNode().getName() + ".");
        }
    }

    private void addConfigWarnings() {
        for (String aktWarning : this.config.getWarnings()) {
            this.addWarning(aktWarning);
        }
    }

    private void checkMethodContainsClassFields() {
        for (FieldNodeWrapper aktField : NodeProvider.getFieldNodes((Node)this.config.getMethodNode().getWrappedNode())) {
            if (!aktField.isClassVar()) continue;
            this.addWarning(String.valueOf(Messages.MoveMethodConditionChecker_TheMethod) + this.config.getMethodNode().getName() + Messages.MoveMethodConditionChecker_ContainsClassField + aktField.getName() + Messages.MoveMethodConditionChecker_MovingMightAffectTheFunctionality + this.config.getSourceClassNode().getName() + "\".");
        }
    }
}

