/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.movemethod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.jruby.ast.FCallNode;
import org.jruby.ast.Node;
import org.jruby.ast.SelfNode;
import org.rubypeople.rdt.refactoring.core.NodeFactory;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.SelectionNodeProvider;
import org.rubypeople.rdt.refactoring.core.movemethod.DelegateMethodEditProvider;
import org.rubypeople.rdt.refactoring.core.movemethod.InsertAccessorEditProvider;
import org.rubypeople.rdt.refactoring.core.movemethod.InsertMethodEditProvider;
import org.rubypeople.rdt.refactoring.core.movemethod.InsertVisibilityEditProvider;
import org.rubypeople.rdt.refactoring.core.movemethod.Messages;
import org.rubypeople.rdt.refactoring.core.movemethod.MoveMethodConfig;
import org.rubypeople.rdt.refactoring.core.movemethod.RemovePartOfVisibilityNodeProvider;
import org.rubypeople.rdt.refactoring.core.movemethod.ReplaceMethodCallEditProvider;
import org.rubypeople.rdt.refactoring.core.movemethod.ReplaceVisibilityEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.DeleteEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.FileEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.FileMultiEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.IMultiFileEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.MultiFileEditProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.ArgsNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.AttrAccessorNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.FieldNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodCallNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.PartialClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.VisibilityNodeWrapper;
import org.rubypeople.rdt.refactoring.util.NameHelper;
import org.rubypeople.rdt.refactoring.util.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodMover
implements IMultiFileEditProvider,
Observer {
    private MoveMethodConfig config;
    private Collection<String> visibilitiesToDelete;

    public MethodMover(MoveMethodConfig config) {
        this.config = config;
        this.visibilitiesToDelete = new ArrayList<String>();
        config.addObserver(this);
        this.initConfig();
    }

    private void initConfig() {
        boolean methodHasCallsToSourceClass = this.methodContainsReferencesToSourceClass();
        this.config.setNewMethodNeedsReferenceToSourceClass(methodHasCallsToSourceClass);
        if (methodHasCallsToSourceClass) {
            this.initMovedMethodArgs();
        }
        this.config.setSourceClassHasCallsToMovingMethod(this.sourceClassContainsCallsToMovingMethod());
        VisibilityNodeWrapper.METHOD_VISIBILITY aktVisibility = this.config.getSourceClassNode().getMethodVisibility(this.config.getMethodNode());
        this.config.setMethodVisibility(aktVisibility);
        this.setMovedMethodVisibility();
        this.config.setLeaveDelegateMethodInSource(this.config.needsSecondPage());
    }

    private void setMovedMethodVisibility() {
        if (this.config.doesSourceClassHasCallsToMovingMethod() || this.config.leaveDelegateMethodInSource()) {
            this.config.setMovedMethodVisibility(VisibilityNodeWrapper.METHOD_VISIBILITY.PUBLIC);
        } else {
            this.config.setMovedMethodVisibility(this.config.getMethodVisibility());
        }
    }

    private void initMovedMethodArgs() {
        String className = this.config.getSourceClassNode().getName();
        String newArgName = String.valueOf(className.substring(0, 1).toLowerCase(Locale.ENGLISH)) + className.substring(1);
        while (NameHelper.namesContainName(this.config.getMethodNode().getLocalNames(), newArgName)) {
            newArgName = NameHelper.createName(newArgName);
        }
        this.config.setFieldInDestinationClassOfTypeSourceClass(newArgName);
        ArgsNodeWrapper argsNode = this.config.getMethodNode().getArgsNode();
        this.config.setMovedMethodArgs(argsNode.cloneWithNewArgName(newArgName));
    }

    private boolean methodContainsReferencesToSourceClass() {
        for (MethodCallNodeWrapper aktCall : this.config.getMethodNode().getMethodCallNodes()) {
            if (!this.isCallToSourceClass(aktCall)) continue;
            return true;
        }
        for (FieldNodeWrapper aktFieldNode : NodeProvider.getFieldNodes((Node)this.config.getMethodNode().getWrappedNode())) {
            if (!aktFieldNode.isInstVar()) continue;
            return true;
        }
        return false;
    }

    private boolean isCallToSourceClass(MethodCallNodeWrapper callNode) {
        if (callNode.isCallToClassMethod()) {
            return false;
        }
        boolean isReceiverSelf = callNode.isCallNode() && NodeUtil.nodeAssignableFrom(callNode.getReceiverNode(), SelfNode.class);
        boolean isNotCallNode = !callNode.isCallNode();
        boolean hasExistingMethodName = this.config.getSourceClassNode().containsMethod(callNode.getName());
        return (isReceiverSelf || isNotCallNode) && hasExistingMethodName;
    }

    @Override
    public Collection<FileMultiEditProvider> getFileEditProviders() {
        MultiFileEditProvider multiFileEditProvider = new MultiFileEditProvider();
        multiFileEditProvider.addEditProvider(this.getInsertMethodInTargetClassProvider());
        if (this.config.leaveDelegateMethodInSource()) {
            multiFileEditProvider.addEditProvider(this.getDelegateMethodEditProvider());
        } else {
            multiFileEditProvider.addEditProvider(this.getDeleteSelectedMethodEditProvider());
            this.addDeleteVisibilityNodesOfMovingMethod(multiFileEditProvider);
            this.addUpdateReferencesInSourceClassEditProviders(multiFileEditProvider);
        }
        if (this.config.doesNewMethodNeedsReferenceToSourceClass()) {
            this.addMethodVisibilityModifierEditProviders(multiFileEditProvider);
            this.addGenerateAccessorsEditProviders(multiFileEditProvider);
        }
        this.addDeleteMethodVisibilitiesEditProvider(multiFileEditProvider);
        return multiFileEditProvider.getFileEditProviders();
    }

    private void addDeleteMethodVisibilitiesEditProvider(MultiFileEditProvider multiFileEditProvider) {
        for (VisibilityNodeWrapper aktVisibilityNode : this.config.getSourceClassNode().getMethodVisibilityNodes()) {
            String fileName = aktVisibilityNode.getPosition().getFile();
            RemovePartOfVisibilityNodeProvider editProvider = new RemovePartOfVisibilityNodeProvider(aktVisibilityNode, this.visibilitiesToDelete);
            if (editProvider.shouldRemoveAll()) {
                multiFileEditProvider.addEditProvider(new FileEditProvider(fileName, new DeleteEditProvider((Node)aktVisibilityNode.getWrappedNode())));
                continue;
            }
            if (!editProvider.hasChange()) continue;
            multiFileEditProvider.addEditProvider(new FileEditProvider(fileName, editProvider));
        }
    }

    private void addDeleteVisibilityNodesOfMovingMethod(MultiFileEditProvider multiFileEditProvider) {
        VisibilityNodeWrapper visibilityNode = this.config.getSourceClassNode().getMethodVisibilityNode(this.config.getMethodNode());
        String fileName = this.config.getMethodNode().getPosition().getFile();
        if (visibilityNode == null) {
            return;
        }
        if (visibilityNode.getMethodNames().size() == 1) {
            multiFileEditProvider.addEditProvider(new FileEditProvider(fileName, new DeleteEditProvider((Node)visibilityNode.getWrappedNode())));
        } else {
            this.visibilitiesToDelete.add(this.config.getMethodNode().getName());
        }
    }

    private void addGenerateAccessorsEditProviders(MultiFileEditProvider multiFileEditProvider) {
        Collection<AttrAccessorNodeWrapper> accessorsToCreate = this.getMissingAccessors();
        String fileName = this.config.getDocumentProvider().getActiveFileName();
        for (AttrAccessorNodeWrapper aktAccessorNode : accessorsToCreate) {
            InsertAccessorEditProvider editProvider = new InsertAccessorEditProvider(aktAccessorNode, this.config.getSourceClassNode());
            multiFileEditProvider.addEditProvider(new FileEditProvider(fileName, editProvider));
        }
    }

    private Collection<AttrAccessorNodeWrapper> getMissingAccessors() {
        Collection<FieldNodeWrapper> fieldNodes = NodeProvider.getFieldNodes((Node)this.config.getMethodNode().getWrappedNode());
        Collection<AttrAccessorNodeWrapper> existingAccessors = this.config.getSourceClassNode().getAccessorNodes();
        LinkedHashMap<String, AttrAccessorNodeWrapper> accessorsToCreate = new LinkedHashMap<String, AttrAccessorNodeWrapper>();
        String destClassField = this.config.getFieldInSourceClassOfTypeDestinationClass();
        for (FieldNodeWrapper aktFieldNode : fieldNodes) {
            if (aktFieldNode.getName().equals(destClassField)) continue;
            this.addAccessorForField(existingAccessors, accessorsToCreate, aktFieldNode);
        }
        return accessorsToCreate.values();
    }

    private void addAccessorForField(Collection<AttrAccessorNodeWrapper> existingAccessors, Map<String, AttrAccessorNodeWrapper> accessorsToCreate, FieldNodeWrapper fieldNode) {
        AttrAccessorNodeWrapper accessorToInsert = this.getAccessor(fieldNode);
        if (fieldNode.isInstVar() && !this.existsAccessor(accessorToInsert, existingAccessors)) {
            if (accessorsToCreate.containsKey(fieldNode.getName())) {
                AttrAccessorNodeWrapper accessor = accessorsToCreate.get(fieldNode.getName());
                accessor.addAccessorType(this.getAccessor(fieldNode));
            } else {
                accessorsToCreate.put(fieldNode.getName(), this.getAccessor(fieldNode));
            }
        }
    }

    private boolean existsAccessor(AttrAccessorNodeWrapper accessorToInsert, Collection<AttrAccessorNodeWrapper> existingAccessors) {
        for (AttrAccessorNodeWrapper accessorNode : existingAccessors) {
            if (!accessorNode.containsAccessor(accessorToInsert)) continue;
            return true;
        }
        return false;
    }

    private AttrAccessorNodeWrapper getAccessor(FieldNodeWrapper aktFieldNode) {
        String accessorName = aktFieldNode.isAsgnNode() ? "attr_writer" : "attr_reader";
        FCallNode fCallNode = NodeFactory.createFCallNode(accessorName, new ArrayList());
        return new AttrAccessorNodeWrapper(fCallNode, NodeFactory.createSymboleNode(aktFieldNode.getName()));
    }

    private void addUpdateReferencesInSourceClassEditProviders(MultiFileEditProvider multiFileEditProvider) {
        Collection<MethodCallNodeWrapper> methodCallsToMovingMethod = this.getMethodCallsToMovingMethodFromSourceClass();
        for (MethodCallNodeWrapper aktCall : methodCallsToMovingMethod) {
            this.addReplaceMethodCallEditProvider(aktCall, multiFileEditProvider);
        }
    }

    private void addReplaceMethodCallEditProvider(MethodCallNodeWrapper methodCall, MultiFileEditProvider multiFileEditProvider) {
        String fileName = methodCall.getPosition().getFile();
        ReplaceMethodCallEditProvider replaceEdit = new ReplaceMethodCallEditProvider(methodCall, this.config);
        multiFileEditProvider.addEditProvider(new FileEditProvider(fileName, replaceEdit));
    }

    private void addMethodVisibilityModifierEditProviders(MultiFileEditProvider multiFileEditProvider) {
        Collection<MethodNodeWrapper> referencedMethod = this.getSourceClassMethodsReferencedInMovingMethod();
        for (MethodNodeWrapper aktMethod : referencedMethod) {
            if (this.config.getSourceClassNode().getMethodVisibility(aktMethod).equals((Object)VisibilityNodeWrapper.METHOD_VISIBILITY.PUBLIC)) continue;
            this.addMethodVisibilityModifierEditProvider(aktMethod, multiFileEditProvider);
        }
    }

    private void addMethodVisibilityModifierEditProvider(MethodNodeWrapper methodNode, MultiFileEditProvider multiFileEditProvider) {
        VisibilityNodeWrapper visibilityNode = this.config.getSourceClassNode().getMethodVisibilityNode(methodNode);
        String fileName = methodNode.getWrappedNode().getPosition().getFile();
        if (visibilityNode == null) {
            InsertVisibilityEditProvider insertEdit = new InsertVisibilityEditProvider(methodNode, VisibilityNodeWrapper.METHOD_VISIBILITY.PUBLIC);
            multiFileEditProvider.addEditProvider(new FileEditProvider(fileName, insertEdit));
        } else {
            if (visibilityNode.getVisibility().equals((Object)VisibilityNodeWrapper.METHOD_VISIBILITY.PUBLIC)) {
                return;
            }
            if (visibilityNode.getMethodNames().size() == 1) {
                ReplaceVisibilityEditProvider editProvider = new ReplaceVisibilityEditProvider(visibilityNode, VisibilityNodeWrapper.METHOD_VISIBILITY.PUBLIC);
                multiFileEditProvider.addEditProvider(new FileEditProvider(fileName, editProvider));
            } else {
                InsertVisibilityEditProvider insertEdit = new InsertVisibilityEditProvider(methodNode, VisibilityNodeWrapper.METHOD_VISIBILITY.PUBLIC);
                multiFileEditProvider.addEditProvider(new FileEditProvider(fileName, insertEdit));
                this.visibilitiesToDelete.add(methodNode.getName());
            }
        }
    }

    private Collection<MethodNodeWrapper> getSourceClassMethodsReferencedInMovingMethod() {
        Collection<MethodCallNodeWrapper> calledMethods = this.config.getMethodNode().getMethodCallNodes();
        ArrayList<MethodNodeWrapper> methods = new ArrayList<MethodNodeWrapper>();
        for (MethodCallNodeWrapper aktCall : calledMethods) {
            if (aktCall.isCallToClassMethod() || aktCall.isCallNode() || !this.config.getSourceClassNode().containsMethod(aktCall.getName())) continue;
            methods.add(this.config.getSourceClassNode().getMethod(aktCall.getName()));
        }
        return methods;
    }

    private FileEditProvider getDeleteSelectedMethodEditProvider() {
        DeleteEditProvider deleteEditProvider = new DeleteEditProvider((Node)this.config.getMethodNode().getWrappedNode());
        return new FileEditProvider(this.config.getDocumentProvider().getActiveFileName(), deleteEditProvider);
    }

    private FileEditProvider getDelegateMethodEditProvider() {
        DelegateMethodEditProvider editProvider = new DelegateMethodEditProvider(this.config);
        return new FileEditProvider(this.config.getDocumentProvider().getActiveFileName(), editProvider);
    }

    private FileEditProvider getInsertMethodInTargetClassProvider() {
        PartialClassNodeWrapper insertClassPart = this.config.getDestinationClassNode().getPartialClassNodeForFileName(this.config.getMethodNode().getPosition().getFile());
        if (insertClassPart == null) {
            insertClassPart = this.config.getDestinationClassNode().getFirstPartialClassNode();
        }
        InsertMethodEditProvider insertEdit = new InsertMethodEditProvider(this.config, insertClassPart);
        return new FileEditProvider(insertClassPart.getFile(), insertEdit);
    }

    private Collection<MethodCallNodeWrapper> getMethodCallsToMovingMethodFromSourceClass() {
        Collection<MethodCallNodeWrapper> allMethodCalls = this.config.getSourceClassNode().getMethodCallNodes();
        ArrayList<MethodCallNodeWrapper> methodCallsToMovingMethod = new ArrayList<MethodCallNodeWrapper>();
        for (MethodCallNodeWrapper aktCall : allMethodCalls) {
            if (!this.isCallToMovingMethod(aktCall)) continue;
            methodCallsToMovingMethod.add(aktCall);
        }
        return methodCallsToMovingMethod;
    }

    private boolean sourceClassContainsCallsToMovingMethod() {
        Collection<MethodCallNodeWrapper> allMethodCalls = this.config.getSourceClassNode().getMethodCallNodes();
        for (MethodCallNodeWrapper aktCall : allMethodCalls) {
            if (!this.isCallToMovingMethod(aktCall) || aktCall.isCallToClassMethod()) continue;
            return true;
        }
        return false;
    }

    private boolean isCallToMovingMethod(MethodCallNodeWrapper methodCall) {
        boolean sameType;
        String selectedMethodName = this.config.getMethodNode().getName();
        boolean sameName = methodCall.getName().equals(selectedMethodName);
        boolean notInMovingMethod = !SelectionNodeProvider.isNodeContainedInNode(methodCall.getWrappedNode(), (Node)this.config.getMethodNode().getWrappedNode());
        boolean isNotCallNode = !methodCall.isCallNode();
        boolean isSelfNode = methodCall.isCallNode() && NodeUtil.nodeAssignableFrom(methodCall.getReceiverNode(), SelfNode.class);
        boolean bl = sameType = this.config.getMethodNode().isClassMethod() == methodCall.isCallToClassMethod();
        return sameName && sameType && notInMovingMethod && (isNotCallNode || isSelfNode || methodCall.isCallToClassMethod());
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        this.setMovedMethodVisibility();
        this.initWarnings();
    }

    private void initWarnings() {
        VisibilityNodeWrapper.METHOD_VISIBILITY oldVisibility;
        VisibilityNodeWrapper.METHOD_VISIBILITY newVisibility;
        this.config.resetWarnings();
        if (this.config.doesNewMethodNeedsReferenceToSourceClass()) {
            for (AttrAccessorNodeWrapper aktAccessorNode : this.getMissingAccessors()) {
                this.config.addWarning(String.valueOf(Messages.MethodMover_An) + aktAccessorNode.getAccessorTypeName() + Messages.MethodMover_ForField + aktAccessorNode.getAttrName() + Messages.MethodMover_WillBeGenerated);
            }
        }
        if (this.config.doesNewMethodNeedsReferenceToSourceClass()) {
            for (MethodNodeWrapper aktMethod : this.getSourceClassMethodsReferencedInMovingMethod()) {
                if (this.config.getSourceClassNode().getMethodVisibility(aktMethod).equals((Object)VisibilityNodeWrapper.METHOD_VISIBILITY.PUBLIC)) continue;
                this.config.addWarning(String.valueOf(Messages.MethodMover_TheVisibilityOfMethod) + aktMethod.getName() + Messages.MethodMover_WillBeChangedToPublic);
            }
        }
        if (!(newVisibility = this.config.getMethodVisibility()).equals((Object)(oldVisibility = this.config.getMethodVisibility()))) {
            String oldVisibilityName = VisibilityNodeWrapper.getVisibilityName(oldVisibility);
            String newVisibilityName = VisibilityNodeWrapper.getVisibilityName(newVisibility);
            this.config.addWarning(String.valueOf(Messages.MethodMover_TheVisibilityOfTheMovingMethod) + this.config.getMethodNode().getName() + Messages.MethodMover_IsChangedFrom + oldVisibilityName + Messages.MethodMover_To + newVisibilityName + '.');
        }
        if (!this.config.getMethodNode().getName().equals(this.config.getMovedMethodName())) {
            this.config.addWarning(String.valueOf(Messages.MethodMover_NameWillBeChangedTo) + this.config.getMovedMethodName() + Messages.MethodMover_DuToNameConflicts);
        }
    }
}

