/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.movemethod;

import java.util.Collection;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.jruby.ast.DefnNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.visitor.rewriter.FormatHelper;
import org.jruby.ast.visitor.rewriter.ReWriteVisitor;
import org.jruby.parser.LocalStaticScope;
import org.jruby.parser.StaticScope;
import org.rubypeople.rdt.refactoring.core.NodeFactory;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.movemethod.MoveMethodConfig;
import org.rubypeople.rdt.refactoring.editprovider.InsertEditProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.ArgsNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.FieldNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodCallNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.PartialClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.VisibilityNodeWrapper;
import org.rubypeople.rdt.refactoring.offsetprovider.AfterLastMethodInClassOffsetProvider;
import org.rubypeople.rdt.refactoring.offsetprovider.IOffsetProvider;
import org.rubypeople.rdt.refactoring.util.NodeUtil;

public class InsertMethodEditProvider
extends InsertEditProvider {
    private MoveMethodConfig config;
    private IOffsetProvider offsetProvider;
    private PartialClassNodeWrapper classPart;

    public InsertMethodEditProvider(MoveMethodConfig config, PartialClassNodeWrapper classPart) {
        super(true);
        this.config = config;
        this.classPart = classPart;
    }

    protected Node getInsertNode(int offset, String document) {
        VisibilityNodeWrapper.METHOD_VISIBILITY requiredVisibility;
        VisibilityNodeWrapper.METHOD_VISIBILITY aktVisibility;
        boolean needsNewLineAtEndOfBlock = !this.isNextLineEmpty(offset, document);
        NewlineNode insertMethodNode = NodeFactory.createNewLineNode((Node)this.getReferenceReplacedMethodNode(document));
        if (!this.config.getMethodNode().isClassMethod() && !(aktVisibility = this.classPart.getPosVisibility(this.offsetProvider.getOffset())).equals((Object)(requiredVisibility = this.config.getMovedMethodVisibility()))) {
            Node visibilityNode = NodeFactory.createVisibilityNode(requiredVisibility, this.config.getMovedMethodName());
            return NodeFactory.createBlockNode(needsNewLineAtEndOfBlock, new Node[]{insertMethodNode, visibilityNode});
        }
        return NodeFactory.createBlockNode(needsNewLineAtEndOfBlock, new Node[]{insertMethodNode});
    }

    private MethodDefNode getReferenceReplacedMethodNode(String document) {
        NewlineNode documentNode = NodeFactory.createNewLineNode((Node)this.config.getMethodNode().getWrappedNode());
        String docStr = ReWriteVisitor.createCodeFromNode((Node)documentNode, (String)document, (FormatHelper)this.getFormatHelper());
        Document doc = new Document(docStr);
        try {
            this.getFieldInsertionEdit(docStr).apply((IDocument)doc);
        }
        catch (MalformedTreeException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        MethodDefNode methodNode = (MethodDefNode)NodeProvider.unwrap(NodeProvider.getRootNode("tempFile", doc.get()).getBodyNode());
        return this.createMethodNodeWithAdditionalArg(methodNode);
    }

    private MethodDefNode createMethodNodeWithAdditionalArg(MethodDefNode methodNode) {
        DefnNode resultMethod;
        ArgsNodeWrapper args = this.config.getMovedMethodArgs();
        if (this.config.getMethodNode().isClassMethod()) {
            String destClassName = this.config.getDestinationClassNode().getName();
            resultMethod = NodeFactory.createStaticMethodNode(destClassName, this.config.getMovedMethodName(), args.getWrappedNode(), (StaticScope)new LocalStaticScope(null), methodNode.getBodyNode());
        } else {
            resultMethod = NodeFactory.createMethodNodeWithoutNewline(this.config.getMovedMethodName(), args.getWrappedNode(), methodNode.getBodyNode());
        }
        resultMethod.addComments(methodNode.getComments());
        resultMethod.setPosition(methodNode.getPosition());
        return resultMethod;
    }

    private TextEdit getFieldInsertionEdit(String docStr) {
        MultiTextEdit multiEdit = new MultiTextEdit();
        RootNode rootNode = NodeProvider.getRootNode("tmpFile", docStr);
        Collection<MethodCallNodeWrapper> callNodes = NodeProvider.getMethodCallNodes((Node)rootNode);
        for (MethodCallNodeWrapper aktCallNode : callNodes) {
            this.addTextEditIfNeeded(multiEdit, aktCallNode);
        }
        Collection<FieldNodeWrapper> fieldNodes = NodeProvider.getFieldNodes((Node)rootNode);
        for (FieldNodeWrapper aktFieldNode : fieldNodes) {
            this.addTextEditIfNeeded(multiEdit, aktFieldNode);
        }
        return multiEdit;
    }

    private void addTextEditIfNeeded(MultiTextEdit multiEdit, FieldNodeWrapper aktFieldNode) {
        if (aktFieldNode.getNodeType() == 5) {
            return;
        }
        if (aktFieldNode.isInstVar()) {
            int length;
            String insertText;
            int insertPos = aktFieldNode.getPosition().getStartOffset();
            if (aktFieldNode.getName().equals(this.config.getFieldInSourceClassOfTypeDestinationClass())) {
                insertText = "self";
                length = aktFieldNode.getPosition().getEndOffset() - insertPos;
            } else {
                insertText = String.valueOf(this.config.getFieldInDestinationClassOfTypeSourceClass()) + '.';
                length = 1;
            }
            multiEdit.addChild((TextEdit)new ReplaceEdit(insertPos, length, insertText));
        }
    }

    private void addTextEditIfNeeded(MultiTextEdit multiEdit, MethodCallNodeWrapper aktCallNode) {
        int insertPos = aktCallNode.getPosition().getStartOffset();
        String insertText = String.valueOf(this.config.getFieldInDestinationClassOfTypeSourceClass()) + ".";
        if (aktCallNode.isCallNode()) {
            Node receiverNode = aktCallNode.getReceiverNode();
            if (NodeUtil.nodeAssignableFrom(receiverNode, SelfNode.class) && !this.isCallToMovingMethod(aktCallNode.getName())) {
                int length = receiverNode.getPosition().getEndOffset() - insertPos;
                multiEdit.addChild((TextEdit)new ReplaceEdit(insertPos, length, this.config.getFieldInDestinationClassOfTypeSourceClass()));
            }
        } else if (this.isCallToSourceClass(aktCallNode.getName())) {
            multiEdit.addChild((TextEdit)new InsertEdit(insertPos, insertText));
        }
    }

    private boolean isCallToMovingMethod(String callName) {
        return this.config.getMethodNode().getName().equals(callName);
    }

    private boolean isCallToSourceClass(String callName) {
        if (this.isCallToMovingMethod(callName)) {
            return false;
        }
        Collection<MethodNodeWrapper> methodNodes = this.config.getSourceClassNode().getMethods();
        for (MethodNodeWrapper aktMethod : methodNodes) {
            if (!aktMethod.getName().equals(callName)) continue;
            return true;
        }
        return false;
    }

    protected int getOffset(String document) {
        if (this.offsetProvider == null) {
            this.offsetProvider = new AfterLastMethodInClassOffsetProvider(this.config.getDestinationClassNode(), document);
        }
        return this.offsetProvider.getOffset();
    }
}

