/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.movefield;

import java.util.Collection;
import java.util.TreeSet;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.classnodeprovider.AllFilesClassNodeProvider;
import org.rubypeople.rdt.refactoring.core.IRefactoringConfig;
import org.rubypeople.rdt.refactoring.core.RefactoringConditionChecker;
import org.rubypeople.rdt.refactoring.core.SelectionNodeProvider;
import org.rubypeople.rdt.refactoring.core.movefield.Messages;
import org.rubypeople.rdt.refactoring.core.movefield.MoveFieldConfig;
import org.rubypeople.rdt.refactoring.exception.NoClassNodeException;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.FieldNodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveFieldConditionChecker
extends RefactoringConditionChecker {
    private ClassNodeWrapper selectedClassNode;
    private FieldNodeWrapper selectedField;
    private MoveFieldConfig config;

    public MoveFieldConditionChecker(MoveFieldConfig config) {
        super(config);
    }

    @Override
    public void init(IRefactoringConfig configObj) {
        this.config = (MoveFieldConfig)configObj;
        try {
            this.selectedClassNode = SelectionNodeProvider.getSelectedClassNode((Node)this.config.getDocumentProvider().getActiveFileRootNode(), this.config.getPos());
        }
        catch (NoClassNodeException noClassNodeException) {
            this.selectedClassNode = null;
            return;
        }
        this.selectedField = MoveFieldConditionChecker.findSelectedField(this.selectedClassNode.getFields(), this.config.getPos());
        this.config.setSelectedField(this.selectedField);
        if (this.selectedField == null) {
            return;
        }
        this.config.setTargetClassCandidates(this.getPossibleTargetClassNames(this.selectedClassNode.getName()));
        this.config.setReferenceCandidates(MoveFieldConditionChecker.getPossibleFieldNames(this.selectedClassNode.getFields(), this.selectedField.getNameWithoutAts()));
    }

    private static Collection<String> getPossibleFieldNames(Collection<FieldNodeWrapper> fields, String selectedFieldName) {
        TreeSet<String> names = new TreeSet<String>();
        for (FieldNodeWrapper field : fields) {
            if (!field.isInstVar() || field.getNameWithoutAts().equals(selectedFieldName)) continue;
            names.add("@" + field.getNameWithoutAts());
        }
        return names;
    }

    private static FieldNodeWrapper findSelectedField(Collection<FieldNodeWrapper> fields, int pos) {
        FieldNodeWrapper selected = null;
        for (FieldNodeWrapper fieldNode : fields) {
            if (!MoveFieldConditionChecker.isFieldAtCursorPos(fieldNode, pos) || !fieldNode.isInstVar()) continue;
            selected = fieldNode;
        }
        return selected;
    }

    private static boolean isFieldAtCursorPos(FieldNodeWrapper fieldNode, int pos) {
        return fieldNode.getWrappedNode().getPosition().getStartOffset() <= pos && fieldNode.getWrappedNode().getPosition().getEndOffset() >= pos;
    }

    private Collection<String> getPossibleTargetClassNames(String selectedClassName) {
        TreeSet<String> allClasses = new TreeSet<String>();
        for (ClassNodeWrapper classNode : new AllFilesClassNodeProvider(this.config.getDocumentProvider()).getAllClassNodes()) {
            if (classNode.getName().equals(selectedClassName)) continue;
            allClasses.add(classNode.getName());
        }
        return allClasses;
    }

    @Override
    protected void checkInitialConditions() {
        if (this.selectedClassNode == null) {
            this.addError(Messages.MoveFieldConditionChecker_NoInstanceInsideClass);
        } else if (this.selectedField == null) {
            this.addError(Messages.MoveFieldConditionChecker_NoFieldSelected);
        } else if (this.config.getReferenceCandidates().isEmpty()) {
            this.addError(Messages.MoveFieldConditionChecker_NoReference);
        } else if (this.config.getTargetClassCandidates().isEmpty()) {
            this.addError(Messages.MoveFieldConditionChecker_NoDestination);
        }
    }
}

