/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.mergewithexternalclassparts;

import org.rubypeople.rdt.refactoring.classnodeprovider.ClassNodeProvider;
import org.rubypeople.rdt.refactoring.core.IRefactoringConfig;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.PartialClassNodeWrapper;

public class MergeWithExternalClassPartConfig
implements IRefactoringConfig {
    private ClassNodeProvider classNodeProvider;
    private IDocumentProvider documentProvider;
    private boolean selectionEmpty;

    public MergeWithExternalClassPartConfig(IDocumentProvider documentProvider) {
        this.documentProvider = documentProvider;
        this.selectionEmpty = true;
    }

    public IDocumentProvider getDocumentProvider() {
        return this.documentProvider;
    }

    public ClassNodeProvider getClassNodeProvider() {
        return this.classNodeProvider;
    }

    public boolean hasClassParts() {
        return !this.classNodeProvider.getAllClassNodes().isEmpty();
    }

    public boolean isSelectionEmpty() {
        return this.selectionEmpty;
    }

    public void setSelectionEmpty(boolean selectioEmpty) {
        this.selectionEmpty = selectioEmpty;
    }

    public boolean hasClassWithExternalPart() {
        ClassNodeProvider activeFileClassNodeProvider = this.documentProvider.getClassNodeProvider();
        for (ClassNodeWrapper aktClassNode : activeFileClassNodeProvider.getAllClassNodes()) {
            String className = aktClassNode.getName();
            ClassNodeWrapper wholeClass = this.classNodeProvider.getClassNode(className);
            for (PartialClassNodeWrapper aktPart : wholeClass.getPartialClassNodes()) {
                if (aktPart.getFile().equals(this.documentProvider.getActiveFileName())) continue;
                return true;
            }
        }
        return false;
    }

    public void setClassNodeProvider(ClassNodeProvider classNodeProvider) {
        this.classNodeProvider = classNodeProvider;
    }

    public void setDocumentProvider(IDocumentProvider doc) {
        this.documentProvider = doc;
    }
}

