/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.mergeclasspartsinfile;

import java.util.ArrayList;
import java.util.Collection;
import org.rubypeople.rdt.refactoring.classnodeprovider.IncludedClassesProvider;
import org.rubypeople.rdt.refactoring.core.IRefactoringConfig;
import org.rubypeople.rdt.refactoring.core.RefactoringConditionChecker;
import org.rubypeople.rdt.refactoring.core.mergeclasspartsinfile.MergeClassPartInFileConfig;
import org.rubypeople.rdt.refactoring.core.mergeclasspartsinfile.Messages;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.PartialClassNodeWrapper;

public class MergeClassPartsInFileConditionChecker
extends RefactoringConditionChecker {
    private MergeClassPartInFileConfig config;

    public MergeClassPartsInFileConditionChecker(MergeClassPartInFileConfig config) {
        super(config);
    }

    public void init(IRefactoringConfig configObj) {
        this.config = (MergeClassPartInFileConfig)configObj;
        this.config.setClassNodeProvider(new IncludedClassesProvider(this.config.getDocumentProvider()));
        this.initSelectableClasses();
    }

    private void initSelectableClasses() {
        ArrayList<ClassNodeWrapper> selectableClasses = new ArrayList<ClassNodeWrapper>();
        for (ClassNodeWrapper currentClassNode : this.config.getAllClassNodes()) {
            if (currentClassNode.getPartialClassNodesOfFile(this.config.getDocumentProvider().getActiveFileName()).size() < 2) continue;
            selectableClasses.add(currentClassNode);
        }
        this.config.setSelectableClasses(selectableClasses);
    }

    protected void checkFinalConditions() {
        if (!this.isSelectionMergable()) {
            this.addError(Messages.MergeClassPartsInFileConditionChecker_TooFewParts);
        }
    }

    private boolean isSelectionMergable() {
        Collection<PartialClassNodeWrapper> checkedClassParts = this.config.getCheckedClassParts();
        if (checkedClassParts.isEmpty()) {
            return false;
        }
        return checkedClassParts.size() != 1 || !checkedClassParts.toArray()[0].equals(this.config.getSelectedClassPart());
    }

    protected void checkInitialConditions() {
        if (!this.config.hasSelectableClasses()) {
            this.addError(Messages.MergeClassPartsInFileConditionChecker_NotEnoughPartsFound);
        }
    }
}

