/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.inlinemethod;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.search.CollectingSearchRequestor;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.core.search.SearchMatch;
import org.rubypeople.rdt.core.search.SearchParticipant;
import org.rubypeople.rdt.core.search.SearchPattern;
import org.rubypeople.rdt.core.search.SearchRequestor;
import org.rubypeople.rdt.internal.ti.util.OffsetNodeLocator;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.ASTProvider;
import org.rubypeople.rdt.refactoring.classnodeprovider.IncludedClassesProvider;
import org.rubypeople.rdt.refactoring.core.inlinemethod.IMethodFinder;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;

public class MethodFinder
implements IMethodFinder {
    public MethodDefNode find(String className, String methodName, IDocumentProvider doc) {
        SearchEngine engine = new SearchEngine();
        SearchPattern pattern = SearchPattern.createPattern((int)6, (String)(String.valueOf(className) + '.' + methodName), (int)0, (int)0);
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        IRubySearchScope scope = SearchEngine.createWorkspaceScope();
        CollectingSearchRequestor requestor = new CollectingSearchRequestor();
        try {
            engine.search(pattern, participants, scope, (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
            List matches = requestor.getResults();
            for (SearchMatch match : matches) {
                IRubyElement element = (IRubyElement)match.getElement();
                if (!element.isType(6)) continue;
                IMethod method = (IMethod)element;
                RootNode rootNode = ASTProvider.getASTProvider().getAST((IRubyElement)method.getRubyScript(), ASTProvider.WAIT_YES, (IProgressMonitor)new NullProgressMonitor());
                Node node = OffsetNodeLocator.Instance().getNodeAtOffset((Node)rootNode, method.getSourceRange().getOffset());
                if (!(node instanceof MethodDefNode)) continue;
                return (MethodDefNode)node;
            }
        }
        catch (CoreException e) {
            RubyPlugin.log((Throwable)e);
        }
        for (MethodNodeWrapper method : new IncludedClassesProvider(doc).getAllMethodsFor(className)) {
            if (!method.getName().equals(methodName)) continue;
            return method.getWrappedNode();
        }
        return null;
    }
}

