/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.inlinelocal;

import java.util.ArrayList;
import java.util.Collection;
import org.rubypeople.rdt.refactoring.core.RefactoringContext;
import org.rubypeople.rdt.refactoring.core.extractmethod.ExtractMethodConditionChecker;
import org.rubypeople.rdt.refactoring.core.extractmethod.ExtractMethodConfig;
import org.rubypeople.rdt.refactoring.core.extractmethod.MethodExtractor;
import org.rubypeople.rdt.refactoring.core.inlinelocal.InlineLocalConfig;
import org.rubypeople.rdt.refactoring.core.inlinelocal.LocalValueReplaceProvider;
import org.rubypeople.rdt.refactoring.core.inlinelocal.MethodCallReplaceProvider;
import org.rubypeople.rdt.refactoring.editprovider.DeleteEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.EditProvider;
import org.rubypeople.rdt.refactoring.editprovider.MultiEditProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.LocalNodeWrapper;
import org.rubypeople.rdt.refactoring.util.JRubyRefactoringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalVariableInliner
extends MultiEditProvider {
    private InlineLocalConfig config;
    private ExtractMethodConfig extractConfig;

    public LocalVariableInliner(InlineLocalConfig config) {
        this.config = config;
    }

    @Override
    protected Collection<EditProvider> getEditProviders() {
        ArrayList<EditProvider> editProviders = new ArrayList<EditProvider>();
        editProviders.add(this.createDeleteEdit());
        if (this.config.isReplaceTempWithQuery()) {
            editProviders.add(this.extractMethodProvider());
            for (LocalNodeWrapper currentLocalNode : this.config.getLocalOccurrences()) {
                editProviders.add(this.replaceWithMethodCallProvider(currentLocalNode));
            }
        } else {
            for (LocalNodeWrapper currentLocalNode : this.config.getLocalOccurrences()) {
                editProviders.add(this.replaceWithValueProvider(currentLocalNode));
            }
        }
        return editProviders;
    }

    private EditProvider replaceWithMethodCallProvider(LocalNodeWrapper targetNode) {
        return new MethodCallReplaceProvider(targetNode, this.extractConfig.getHelper().getMethodCallNode());
    }

    private EditProvider replaceWithValueProvider(LocalNodeWrapper targetNode) {
        boolean addBrackets = JRubyRefactoringUtils.isMathematicalExpression(this.config.getDefinitionNode().getValueNode());
        return new LocalValueReplaceProvider(targetNode, this.config, addBrackets);
    }

    private EditProvider extractMethodProvider() {
        int startPos = this.config.getDefinitionNode().getValueNode().getPosition().getStartOffset();
        int endPos = this.config.getDefinitionNode().getValueNode().getPosition().getEndOffset();
        this.extractConfig = new ExtractMethodConfig(this.config.getDocumentProvider(), new RefactoringContext(startPos, endPos, startPos, ""));
        new ExtractMethodConditionChecker(this.extractConfig);
        MethodExtractor methodExtractor = new MethodExtractor(this.extractConfig);
        this.extractConfig.getHelper().setMethodName(this.config.getNewMethodName());
        return methodExtractor.getDefEdit();
    }

    private EditProvider createDeleteEdit() {
        return new DeleteEditProvider(this.config.getDefinitionNode().getWrappedNode());
    }

    public int getOccurrencesCount() {
        return this.config.getLocalOccurrences() == null ? 0 : this.config.getLocalOccurrences().size();
    }

    public String getSelectedItemName() {
        return this.config.getSelectedItemName();
    }

    public InlineLocalConfig getConfig() {
        return this.config;
    }
}

