/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.inlinelocal;

import org.jruby.ast.CallNode;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.rewriter.DefaultFormatHelper;
import org.jruby.ast.visitor.rewriter.FormatHelper;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.inlinelocal.InlineLocalConfig;
import org.rubypeople.rdt.refactoring.editprovider.ReplaceEditProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.LocalNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodCallNodeWrapper;
import org.rubypeople.rdt.refactoring.util.JRubyRefactoringUtils;
import org.rubypeople.rdt.refactoring.util.NodeUtil;

public class LocalValueReplaceProvider
extends ReplaceEditProvider {
    private LocalNodeWrapper targetNode;
    private LocalNodeWrapper inlinedNode;
    private boolean addBrackets;
    private InlineLocalConfig config;

    public LocalValueReplaceProvider(LocalNodeWrapper targetNode, InlineLocalConfig config, boolean addBrackets) {
        super(false);
        this.config = config;
        this.inlinedNode = config.getDefinitionNode();
        this.targetNode = targetNode;
        this.addBrackets = addBrackets;
    }

    protected int getOffsetLength() {
        ISourcePosition replacePos = this.targetNode.getWrappedNode().getPosition();
        return replacePos.getEndOffset() - replacePos.getStartOffset();
    }

    protected Node getEditNode(int offset, String document) {
        return this.inlinedNode.getValueNode();
    }

    protected int getOffset(String document) {
        return this.targetNode.getWrappedNode().getPosition().getStartOffset();
    }

    protected String getFormatedNode(String document) {
        if (this.addBrackets) {
            return String.valueOf('(') + super.getFormatedNode(document) + ')';
        }
        return super.getFormatedNode(document);
    }

    protected FormatHelper getFormatHelper() {
        if (this.callNeedsBrackets()) {
            return new DefaultFormatHelper(){

                public String afterCallArguments() {
                    return ")";
                }

                public String beforeCallArguments() {
                    return "(";
                }
            };
        }
        return super.getFormatHelper();
    }

    private boolean callNeedsBrackets() {
        Node targetEnclosingNode = NodeProvider.findParentNode((Node)this.config.getDocumentProvider().getActiveFileRootNode(), this.targetNode.getWrappedNode());
        boolean isTargetEnclosingNodeCallNode = NodeUtil.nodeAssignableFrom(targetEnclosingNode, MethodCallNodeWrapper.METHOD_CALL_NODE_CLASSES());
        if (NodeUtil.nodeAssignableFrom(targetEnclosingNode, CallNode.class)) {
            isTargetEnclosingNodeCallNode &= !JRubyRefactoringUtils.isMathematicalExpression(targetEnclosingNode);
        }
        boolean isInlinedNodeCallNode = NodeUtil.nodeAssignableFrom(this.inlinedNode.getValueNode(), MethodCallNodeWrapper.METHOD_CALL_NODE_CLASSES());
        if (NodeUtil.nodeAssignableFrom(this.inlinedNode.getValueNode(), CallNode.class)) {
            isInlinedNodeCallNode &= !JRubyRefactoringUtils.isMathematicalExpression(this.inlinedNode.getValueNode());
        }
        return isTargetEnclosingNodeCallNode && isInlinedNodeCallNode;
    }
}

