/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.inlineclass;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.refactoring.core.SelectionNodeProvider;
import org.rubypeople.rdt.refactoring.core.inlineclass.InlineClassConfig;
import org.rubypeople.rdt.refactoring.core.inlineclass.TextEditComparator;
import org.rubypeople.rdt.refactoring.core.renamefield.FieldRenamer;
import org.rubypeople.rdt.refactoring.core.renamefield.RenameFieldConditionChecker;
import org.rubypeople.rdt.refactoring.core.renamefield.RenameFieldConfig;
import org.rubypeople.rdt.refactoring.core.renamemethod.MethodRenamer;
import org.rubypeople.rdt.refactoring.core.renamemethod.RenameMethodConditionChecker;
import org.rubypeople.rdt.refactoring.core.renamemethod.RenameMethodConfig;
import org.rubypeople.rdt.refactoring.documentprovider.StringDocumentProvider;
import org.rubypeople.rdt.refactoring.editprovider.DeleteEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.EditProvider;
import org.rubypeople.rdt.refactoring.editprovider.FileMultiEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.IMultiFileEditProvider;
import org.rubypeople.rdt.refactoring.exception.NoClassNodeException;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.FieldNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.PartialClassNodeWrapper;
import org.rubypeople.rdt.refactoring.util.NameHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertClassBuilder {
    private InlineClassConfig config;

    public InsertClassBuilder(InlineClassConfig config) {
        this.config = config;
    }

    public StringDocumentProvider getInlinedClass(PartialClassNodeWrapper inlinedClassPart) {
        MultiTextEdit prechanges = new MultiTextEdit();
        StringDocumentProvider inlinedClassDocumentProvider = this.getDocumentProviderForClassPart(inlinedClassPart);
        ClassNodeWrapper inlinedClass = inlinedClassDocumentProvider.getClassNodeProvider().getAllClassNodes().iterator().next();
        PartialClassNodeWrapper contextfreeClassPart = inlinedClass.getFirstPartialClassNode();
        Map<String, MethodNodeWrapper> conflictingMethods = this.getMethodsWithNameConflict(contextfreeClassPart);
        Map<String, FieldNodeWrapper> conflictingFields = this.getFieldsWithNameConflict(contextfreeClassPart);
        prechanges.addChildren(this.getMethodRenameEdits(conflictingMethods, inlinedClassDocumentProvider));
        prechanges.addChildren(this.getFieldRenameEdits(conflictingFields, inlinedClassDocumentProvider));
        prechanges.addChildren(this.getConstructorDeleteEdits(inlinedClassDocumentProvider));
        return new StringDocumentProvider(String.valueOf(inlinedClassDocumentProvider.getActiveFileName()) + "_with_applied_prechanges", this.applyPrechanges(prechanges, inlinedClassDocumentProvider));
    }

    private TextEdit[] getMethodRenameEdits(Map<String, MethodNodeWrapper> conflictingMethods, StringDocumentProvider inlinedClassDocumentProvider) {
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        for (String currentMethodName : conflictingMethods.keySet()) {
            MethodNodeWrapper currentMethod = conflictingMethods.get(currentMethodName);
            int methodPos = currentMethod.getWrappedNode().getPosition().getStartOffset();
            RenameMethodConfig config = new RenameMethodConfig(inlinedClassDocumentProvider, methodPos);
            new RenameMethodConditionChecker(config);
            config.setNewName(currentMethodName);
            MethodRenamer renamer = new MethodRenamer(config);
            this.fillTextEdits(inlinedClassDocumentProvider, edits, renamer);
        }
        this.filterEditsInConstructor(edits);
        return edits.toArray(new TextEdit[edits.size()]);
    }

    private void filterEditsInConstructor(Collection<TextEdit> edits) {
        ArrayList<TextEdit> removeList = new ArrayList<TextEdit>();
        Collection<MethodNodeWrapper> constructorNodes = this.config.getSourceClass().getExistingConstructors();
        for (TextEdit currentEdit : edits) {
            int editOffset = currentEdit.getOffset();
            for (MethodNodeWrapper currentConstructor : constructorNodes) {
                if (!SelectionNodeProvider.nodeContainsPosition((Node)currentConstructor.getWrappedNode(), editOffset)) continue;
                removeList.add(currentEdit);
            }
        }
        for (TextEdit currentRevomable : removeList) {
            edits.remove(currentRevomable);
        }
    }

    private void fillTextEdits(StringDocumentProvider inlinedClassDocumentProvider, Collection<TextEdit> edits, IMultiFileEditProvider renamer) {
        for (FileMultiEditProvider currentMultiProvider : renamer.getFileEditProviders()) {
            for (EditProvider currentEditProvider : currentMultiProvider.getEditProviders()) {
                edits.add(currentEditProvider.getEdit(inlinedClassDocumentProvider.getActiveFileContent()));
            }
        }
    }

    private TextEdit[] getFieldRenameEdits(Map<String, FieldNodeWrapper> conflictingFields, StringDocumentProvider inlinedClassDocumentProvider) {
        TreeSet<TextEdit> edits = new TreeSet<TextEdit>(new TextEditComparator());
        for (String newFieldName : conflictingFields.keySet()) {
            FieldNodeWrapper currentField = conflictingFields.get(newFieldName);
            int fieldPos = currentField.getWrappedNode().getPosition().getStartOffset();
            RenameFieldConfig config = new RenameFieldConfig(inlinedClassDocumentProvider, fieldPos);
            new RenameFieldConditionChecker(config);
            config.setNewName(newFieldName.replaceAll("@", ""));
            this.setSelectedCalls(config);
            FieldRenamer renamer = new FieldRenamer(config);
            this.fillTextEdits(inlinedClassDocumentProvider, edits, renamer);
        }
        this.filterEditsInConstructor(edits);
        return edits.toArray(new TextEdit[edits.size()]);
    }

    private void setSelectedCalls(RenameFieldConfig config) {
        String fieldName = config.getSelectedName();
        boolean concernsClassField = config.concernsClassField();
        config.setSelectedCalls(config.getFieldProvider().getFieldItems(fieldName, concernsClassField));
    }

    public Map<String, MethodNodeWrapper> getMethodsWithNameConflict(PartialClassNodeWrapper inlinedClassPart) {
        Collection<MethodNodeWrapper> inlinedMethods = inlinedClassPart.getMethods();
        HashMap<String, MethodNodeWrapper> conflictingMethods = new HashMap<String, MethodNodeWrapper>();
        for (MethodNodeWrapper currentInlinedMethod : inlinedMethods) {
            this.addConflictingMethods(conflictingMethods, currentInlinedMethod);
        }
        return conflictingMethods;
    }

    private void addConflictingMethods(Map<String, MethodNodeWrapper> conflictingMethods, MethodNodeWrapper currentInlinedMethod) {
        if (!currentInlinedMethod.isConstructor() && NameHelper.methodnameExistsInClassPart(currentInlinedMethod.getName(), this.config.getTargetClass())) {
            String newName = NameHelper.createMethodName(currentInlinedMethod, this.config.getTargetClass());
            conflictingMethods.put(newName, currentInlinedMethod);
        }
    }

    private Map<String, FieldNodeWrapper> getFieldsWithNameConflict(PartialClassNodeWrapper inlinedClassPart) {
        Collection<FieldNodeWrapper> inlinedFields = inlinedClassPart.getFields();
        HashMap<String, FieldNodeWrapper> conflictingFields = new HashMap<String, FieldNodeWrapper>();
        for (FieldNodeWrapper currentInlinedField : inlinedFields) {
            this.addConflictingFields(conflictingFields, currentInlinedField);
        }
        return conflictingFields;
    }

    private void addConflictingFields(Map<String, FieldNodeWrapper> conflictingFields, FieldNodeWrapper currentInlinedField) {
        if (NameHelper.fieldnameExistsInClass(currentInlinedField.getName(), this.config.getTargetClass())) {
            String newName = NameHelper.createFieldName(currentInlinedField, this.config.getTargetClass());
            conflictingFields.put(newName, currentInlinedField);
        }
    }

    private StringDocumentProvider getDocumentProviderForClassPart(PartialClassNodeWrapper inlinedClassPart) {
        ISourcePosition classPartPosition = inlinedClassPart.getWrappedNode().getPosition();
        String activeFileContent = this.config.getDocumentProvider().getActiveFileContent();
        String inlinedClassDocument = activeFileContent.substring(classPartPosition.getStartOffset(), classPartPosition.getEndOffset());
        String fileName = "part_of_" + this.config.getDocumentProvider().getActiveFileName();
        StringDocumentProvider inlinedClassDocumentProvider = new StringDocumentProvider(fileName, inlinedClassDocument);
        return inlinedClassDocumentProvider;
    }

    private TextEdit[] getConstructorDeleteEdits(StringDocumentProvider inlinedClassDocument) {
        ClassNodeWrapper classNode;
        ArrayList<TextEdit> constructorDeleters = new ArrayList<TextEdit>();
        RootNode rootNode = inlinedClassDocument.getActiveFileRootNode();
        try {
            classNode = SelectionNodeProvider.getSelectedClassNode((Node)rootNode, 1);
        }
        catch (NoClassNodeException e) {
            e.printStackTrace();
            return constructorDeleters.toArray(new TextEdit[constructorDeleters.size()]);
        }
        Collection<MethodNodeWrapper> constructors = classNode.getExistingConstructors();
        for (MethodNodeWrapper currentConstructor : constructors) {
            DeleteEditProvider deleteEditProvider = new DeleteEditProvider((Node)currentConstructor.getWrappedNode());
            constructorDeleters.add(deleteEditProvider.getEdit(inlinedClassDocument.getActiveFileContent()));
        }
        return constructorDeleters.toArray(new TextEdit[constructorDeleters.size()]);
    }

    private String applyPrechanges(MultiTextEdit prechanges, StringDocumentProvider inlinedClassDocumentProvider) {
        Document inlinedPart = new Document(inlinedClassDocumentProvider.getActiveFileContent());
        try {
            prechanges.apply((IDocument)inlinedPart);
        }
        catch (MalformedTreeException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return inlinedPart.get();
    }
}

