/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.inlineclass;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.types.INameNode;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.refactoring.core.NodeFactory;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.SelectionNodeProvider;
import org.rubypeople.rdt.refactoring.core.inlineclass.ConstructorInliner;
import org.rubypeople.rdt.refactoring.core.inlineclass.InlineClassConfig;
import org.rubypeople.rdt.refactoring.core.inlineclass.InsertClassBuilder;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;
import org.rubypeople.rdt.refactoring.documentprovider.StringDocumentProvider;
import org.rubypeople.rdt.refactoring.editprovider.DeleteEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.FileEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.FileMultiEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.IMultiFileEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.InsertEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.MultiFileEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.ReplaceEditProvider;
import org.rubypeople.rdt.refactoring.exception.NoClassNodeException;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodCallNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.PartialClassNodeWrapper;
import org.rubypeople.rdt.refactoring.offsetprovider.AfterLastMethodInClassOffsetProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInliner
implements IMultiFileEditProvider {
    private InlineClassConfig config;
    private PartialClassNodeWrapper inlinedClassPart;

    public ClassInliner(InlineClassConfig config) {
        this.config = config;
        this.inlinedClassPart = this.getInlinedClassPart();
    }

    @Override
    public Collection<FileMultiEditProvider> getFileEditProviders() {
        MultiFileEditProvider editProvider = new MultiFileEditProvider();
        this.addClassDeleteProvider(editProvider);
        this.addConstructorInsertProvider(editProvider);
        Collection<AssignableNode> concerningAssignments = this.addContructorCallReplacer(editProvider);
        InsertClassBuilder inlinedClassProvider = new InsertClassBuilder(this.config);
        this.addCallReplaceProvider(editProvider, inlinedClassProvider, concerningAssignments);
        this.addClassInsertProvider(editProvider, inlinedClassProvider.getInlinedClass(this.inlinedClassPart));
        return editProvider.getFileEditProviders();
    }

    private void addCallReplaceProvider(MultiFileEditProvider editProvider, InsertClassBuilder inlinedClassProvider, Collection<AssignableNode> concerningAssignments) {
        Map<String, MethodNodeWrapper> concerningMethods = inlinedClassProvider.getMethodsWithNameConflict(this.inlinedClassPart);
        for (String currentKey : concerningMethods.keySet()) {
            MethodNodeWrapper currentMethod = concerningMethods.get(currentKey);
            for (AssignableNode currentAssignment : concerningAssignments) {
                String concerningVarName = ((INameNode)currentAssignment).getName();
                if (currentAssignment instanceof InstAsgnNode) {
                    Collection<MethodNodeWrapper> targetClassMethods = this.config.getTargetClass().getMethods();
                    for (MethodNodeWrapper currentTargetMethod : targetClassMethods) {
                        this.addCallReplacerForMethod(editProvider, currentKey, currentMethod, currentTargetMethod, concerningVarName);
                    }
                    continue;
                }
                if (!(currentAssignment instanceof LocalAsgnNode)) continue;
                MethodNodeWrapper targetConstructor = this.config.getTargetClass().getConstructorNode();
                this.addCallReplacerForMethod(editProvider, currentKey, currentMethod, targetConstructor, concerningVarName);
            }
        }
    }

    private void addCallReplacerForMethod(MultiFileEditProvider editProvider, String newMethodName, MethodNodeWrapper renamedMethod, MethodNodeWrapper targetMethod, String concerningVarName) {
        Collection<Node> calls = NodeProvider.getSubNodes((Node)targetMethod.getWrappedNode(), CallNode.class);
        for (Node currentCall : calls) {
            MethodCallNodeWrapper callWrapper = new MethodCallNodeWrapper(currentCall);
            if (!concerningVarName.equals(callWrapper.getReceiverName()) || !callWrapper.getName().equals(renamedMethod.getName())) continue;
            editProvider.addEditProvider(new FileEditProvider(callWrapper.getFileName(), this.createCallReplaceEditProvider(callWrapper, newMethodName)));
        }
    }

    private ReplaceEditProvider createCallReplaceEditProvider(MethodCallNodeWrapper callWrapper, String newName) {
        return new CallReplaceEditProvider(callWrapper, newName);
    }

    private Collection<AssignableNode> addContructorCallReplacer(MultiFileEditProvider editProvider) {
        MethodNodeWrapper constructorNode = this.config.getTargetClass().getConstructorNode();
        ArrayList<AssignableNode> concerningAssignables = new ArrayList<AssignableNode>();
        for (AssignableNode currentAssignment : this.config.findFieldAsgnsOfSource(constructorNode)) {
            String file = currentAssignment.getPosition().getFile();
            concerningAssignables.add(currentAssignment);
            if (this.inlinedClassPart.getExistingConstructors().isEmpty()) {
                editProvider.addEditProvider(new FileEditProvider(file, this.createConstructorlessSelfAsignment(currentAssignment)));
                continue;
            }
            editProvider.addEditProvider(new FileEditProvider(file, this.createConstructorMethodAndSelfAsgnReplacer(currentAssignment)));
        }
        return concerningAssignables;
    }

    private ReplaceEditProvider createConstructorMethodAndSelfAsgnReplacer(AssignableNode assignment) {
        return new ConstructorAndSelfAsgnReplacer(true, true, assignment);
    }

    private ReplaceEditProvider createConstructorlessSelfAsignment(AssignableNode currentAssignment) {
        return new ConstructorlessSelfAssginmentReplacer(currentAssignment);
    }

    private void addConstructorInsertProvider(MultiFileEditProvider editProvider) {
        Collection<MethodNodeWrapper> constructors = this.inlinedClassPart.getExistingConstructors();
        PartialClassNodeWrapper targetClassPart = this.config.getTargetClassPart();
        for (MethodNodeWrapper currentConstructor : constructors) {
            ConstructorInliner constructorInliner = new ConstructorInliner(currentConstructor, targetClassPart, this.createNewConstructorName());
            editProvider.addEditProvider(new FileEditProvider(targetClassPart.getFile(), constructorInliner));
        }
    }

    private String createNewConstructorName() {
        String className = this.inlinedClassPart.getClassName().toLowerCase(Locale.ENGLISH);
        return String.valueOf(className) + "_" + "initialize";
    }

    private void addClassInsertProvider(MultiFileEditProvider editProvider, StringDocumentProvider inlinedClassDocumentProvider) {
        ClassInsertEditProvider classEditProvider = new ClassInsertEditProvider(true, inlinedClassDocumentProvider);
        String file = this.config.getTargetClassPart().getWrappedNode().getPosition().getFile();
        editProvider.addEditProvider(new FileEditProvider(file, classEditProvider));
    }

    private void addClassDeleteProvider(MultiFileEditProvider editProvider) {
        DeleteEditProvider classPartDeleter = new DeleteEditProvider(this.inlinedClassPart.getWrappedNode());
        editProvider.addEditProvider(new FileEditProvider(this.config.getDocumentProvider().getActiveFileName(), classPartDeleter));
    }

    public PartialClassNodeWrapper getInlinedClassPart() {
        IDocumentProvider docProvider = this.config.getDocumentProvider();
        RootNode rootNode = docProvider.getActiveFileRootNode();
        try {
            return SelectionNodeProvider.getSelectedClassNode((Node)rootNode, this.config.getCaretPosition()).getFirstPartialClassNode();
        }
        catch (NoClassNodeException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static final class CallReplaceEditProvider
    extends ReplaceEditProvider {
        private final MethodCallNodeWrapper wrapper;
        private final String name;

        private CallReplaceEditProvider(MethodCallNodeWrapper wrapper, String name) {
            this.wrapper = wrapper;
            this.name = name;
        }

        protected int getOffsetLength() {
            ISourcePosition pos = this.wrapper.getPosition();
            return pos.getEndOffset() - pos.getStartOffset();
        }

        protected Node getEditNode(int offset, String document) {
            return NodeFactory.createCallNode(this.wrapper.getReceiverNode(), this.name, this.wrapper.getArgsNode());
        }

        protected int getOffset(String document) {
            return this.wrapper.getPosition().getStartOffset();
        }
    }

    private final class ClassInsertEditProvider
    extends InsertEditProvider {
        private final StringDocumentProvider provider;

        private ClassInsertEditProvider(boolean format, StringDocumentProvider provider) {
            super(format);
            this.provider = provider;
        }

        protected Node getInsertNode(int offset, String document) {
            try {
                RootNode rootNode = this.provider.getActiveFileRootNode();
                return SelectionNodeProvider.getSelectedClassNode((Node)rootNode, 1).getFirstPartialClassNode().getClassBodyNode();
            }
            catch (NoClassNodeException noClassNodeException) {
                return this.provider.getActiveFileRootNode();
            }
        }

        protected int getOffset(String document) {
            AfterLastMethodInClassOffsetProvider offsetProvider = new AfterLastMethodInClassOffsetProvider(ClassInliner.this.config.getTargetClassPart(), document);
            return offsetProvider.getOffset();
        }
    }

    private final class ConstructorAndSelfAsgnReplacer
    extends ReplaceEditProvider {
        private final AssignableNode assignment;

        private ConstructorAndSelfAsgnReplacer(boolean format, boolean trim, AssignableNode assignment) {
            super(format, trim);
            this.assignment = assignment;
        }

        protected int getOffsetLength() {
            ISourcePosition pos = this.assignment.getPosition();
            return pos.getEndOffset() - pos.getStartOffset();
        }

        protected Node getEditNode(int offset, String document) {
            MethodCallNodeWrapper valueWrapper = new MethodCallNodeWrapper(this.assignment.getValueNode());
            Node constrReplaceNode = NodeFactory.createMethodCallNode(ClassInliner.this.createNewConstructorName(), valueWrapper.getArgsNode());
            InstAsgnNode selfAsgnNode = NodeFactory.createInstAsgnNode(((INameNode)this.assignment).getName(), (Node)NodeFactory.createSelfNode());
            return NodeFactory.createBlockNode(false, false, true, new Node[]{constrReplaceNode, selfAsgnNode});
        }

        protected int getOffset(String document) {
            return this.assignment.getPosition().getStartOffset();
        }
    }

    private static final class ConstructorlessSelfAssginmentReplacer
    extends ReplaceEditProvider {
        private final AssignableNode assignment;

        private ConstructorlessSelfAssginmentReplacer(AssignableNode assignment) {
            this.assignment = assignment;
        }

        protected int getOffsetLength() {
            return this.assignment.getPosition().getEndOffset() - this.assignment.getPosition().getStartOffset();
        }

        protected Node getEditNode(int offset, String document) {
            InstAsgnNode selfAsgnNode = NodeFactory.createInstAsgnNode(((INameNode)this.assignment).getName(), (Node)NodeFactory.createSelfNode());
            return selfAsgnNode;
        }

        protected int getOffset(String document) {
            return this.assignment.getPosition().getStartOffset();
        }
    }
}

