/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.generateaccessors;

import java.util.ArrayList;
import org.jruby.ast.BlockNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.core.NodeFactory;
import org.rubypeople.rdt.refactoring.core.generateaccessors.AccessorOffsetProvider;
import org.rubypeople.rdt.refactoring.editprovider.InsertEditProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.VisibilityNodeWrapper;

public class GeneratedAccessor
extends InsertEditProvider {
    public static final int TYPE_SIMPLE_ACCESSOR = 1;
    public static final int TYPE_METHOD_ACCESSOR = 2;
    public static final int DEFAULT_TYPE = 1;
    public String definitionName;
    private int type;
    private String attrName;
    private ClassNodeWrapper classNode;

    public GeneratedAccessor(String definitionName, String instVarName, int type, ClassNodeWrapper classNode) {
        super(true);
        this.definitionName = definitionName;
        this.attrName = instVarName;
        this.type = type;
        this.classNode = classNode;
    }

    public boolean isWriter() {
        return this.definitionName.equals("attr_writer");
    }

    public boolean isReader() {
        return this.definitionName.equals("attr_reader");
    }

    public boolean isAccessor() {
        return this.definitionName.equals("attr_accessor");
    }

    protected BlockNode getInsertNode(int offset, String document) {
        if (this.lastEditInGroup) {
            this.isNextLineEmpty(offset, document);
        }
        if (this.type == 1) {
            return NodeFactory.createBlockNode(false, this.getSimpleInsertNode());
        }
        return NodeFactory.createBlockNode(false, this.getMethodInsertNode());
    }

    private Node getSimpleInsertNode() {
        FCallNode accessorNode = NodeFactory.createSimpleAccessorNode(this.definitionName, this.attrName);
        return NodeFactory.createNewLineNode((Node)accessorNode);
    }

    private Node[] getMethodInsertNode() {
        ArrayList<BlockNode> methodNodes = new ArrayList<BlockNode>();
        if (this.isReader() || this.isAccessor()) {
            methodNodes.add(NodeFactory.createGetterSetter(this.attrName, false, VisibilityNodeWrapper.METHOD_VISIBILITY.PUBLIC));
        }
        if (this.isWriter() || this.isAccessor()) {
            methodNodes.add(NodeFactory.createGetterSetter(this.attrName, true, VisibilityNodeWrapper.METHOD_VISIBILITY.PUBLIC));
        }
        return methodNodes.toArray(new Node[methodNodes.size()]);
    }

    protected int getOffset(String document) {
        AccessorOffsetProvider offsetProvider = new AccessorOffsetProvider(this.classNode, this.type, document);
        return offsetProvider.getOffset();
    }

    public String getInstVarName() {
        return this.attrName;
    }
}

