/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.generateaccessors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jruby.ast.Node;
import org.jruby.ast.types.INameNode;
import org.rubypeople.rdt.refactoring.classnodeprovider.ClassNodeProvider;
import org.rubypeople.rdt.refactoring.core.generateaccessors.GeneratedAccessor;
import org.rubypeople.rdt.refactoring.core.generateaccessors.Messages;
import org.rubypeople.rdt.refactoring.documentprovider.DocumentProvider;
import org.rubypeople.rdt.refactoring.editprovider.EditAndTreeContentProvider;
import org.rubypeople.rdt.refactoring.editprovider.EditProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.ArgsNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.AttrAccessorNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;
import org.rubypeople.rdt.refactoring.ui.IChildrenProvider;
import org.rubypeople.rdt.refactoring.ui.IItemSelectionReceiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessorsGenerator
extends EditAndTreeContentProvider
implements IItemSelectionReceiver {
    private Collection<TreeClass> classes;
    private int type;
    private Object[] selectedTreeItems;
    public static final String WRITER = Messages.AccessorsGenerator_Writer;
    public static final String READER = Messages.AccessorsGenerator_Reader;

    public AccessorsGenerator(DocumentProvider documentProvider, int type) {
        this.type = type;
        this.selectedTreeItems = new Object[0];
        this.initTreeClasses(documentProvider.getClassNodeProvider());
    }

    @Override
    protected void initTreeClasses(ClassNodeProvider classNodeProvider) {
        this.classes = new ArrayList<TreeClass>();
        if (classNodeProvider != null) {
            for (ClassNodeWrapper node : classNodeProvider.getAllClassNodes()) {
                this.classes.add(new TreeClass(node));
            }
        }
    }

    @Override
    public Object[] getElements(Object inputElement) {
        ArrayList<TreeClass> elements = new ArrayList<TreeClass>();
        for (TreeClass klass : this.classes) {
            if (!klass.hasChildren()) continue;
            elements.add(klass);
        }
        return elements.toArray();
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public void setSelectedItems(Object[] selected) {
        this.selectedTreeItems = (Object[])selected.clone();
    }

    @Override
    public Collection<EditProvider> getEditProviders() {
        Collection<TreeClass.TreeAttribute.TreeAccessor> treeAccessors = this.getTreeAccessors();
        LinkedHashSet<TreeClass.TreeAttribute> attribtes = this.getTreeAttributes(treeAccessors);
        Collection<EditProvider> generatedAccessors = this.getGeneratedAccessors(attribtes);
        return generatedAccessors;
    }

    private Collection<EditProvider> getGeneratedAccessors(LinkedHashSet<TreeClass.TreeAttribute> attribtes) {
        ArrayList<EditProvider> providers = new ArrayList<EditProvider>();
        for (TreeClass.TreeAttribute attr : attribtes) {
            providers.addAll(attr.getGeneratedAccessors());
        }
        return providers;
    }

    private LinkedHashSet<TreeClass.TreeAttribute> getTreeAttributes(Collection<TreeClass.TreeAttribute.TreeAccessor> treeAccessors) {
        LinkedHashSet<TreeClass.TreeAttribute> attribtes = new LinkedHashSet<TreeClass.TreeAttribute>();
        for (TreeClass.TreeAttribute.TreeAccessor accessor : treeAccessors) {
            this.setSelection(accessor);
            attribtes.add(accessor.getAttribute());
        }
        return attribtes;
    }

    private void setSelection(TreeClass.TreeAttribute.TreeAccessor accessor) {
        if (accessor.isReader()) {
            accessor.getAttribute().setReaderSelected();
        } else if (accessor.isWriter()) {
            accessor.getAttribute().setWriterSelected();
        }
    }

    private Collection<TreeClass.TreeAttribute.TreeAccessor> getTreeAccessors() {
        ArrayList<TreeClass.TreeAttribute.TreeAccessor> treeAccessors = new ArrayList<TreeClass.TreeAttribute.TreeAccessor>();
        Object[] objectArray = this.selectedTreeItems;
        int n = this.selectedTreeItems.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof TreeClass.TreeAttribute.TreeAccessor) {
                TreeClass.TreeAttribute.TreeAccessor accessor = (TreeClass.TreeAttribute.TreeAccessor)o;
                accessor.getAttribute().clearSelection();
                treeAccessors.add(accessor);
            }
            ++n2;
        }
        return treeAccessors;
    }

    public class TreeClass
    implements IChildrenProvider {
        private ClassNodeWrapper classNode;
        private Collection<TreeAttribute> attrs;
        private final Collection<AttrAccessorNodeWrapper> existingSimpleAccessorNodes;
        private final Collection<MethodNodeWrapper> existingMethodAccessorNodes;

        public TreeClass(ClassNodeWrapper classNode) {
            this.classNode = classNode;
            this.existingSimpleAccessorNodes = classNode.getAccessorNodes();
            this.existingMethodAccessorNodes = classNode.getMethods();
            this.attrs = new ArrayList<TreeAttribute>();
            for (Node attrNode : classNode.getAttrNodes()) {
                this.attrs.add(new TreeAttribute((INameNode)attrNode, classNode));
            }
        }

        public String toString() {
            return this.classNode.getName();
        }

        public Object[] getChildren() {
            ArrayList<TreeAttribute> children = new ArrayList<TreeAttribute>();
            for (TreeAttribute attr : this.attrs) {
                if (!attr.hasChildren()) continue;
                children.add(attr);
            }
            return children.toArray();
        }

        public boolean hasChildren() {
            for (TreeAttribute attr : this.attrs) {
                if (!attr.hasChildren()) continue;
                return true;
            }
            return false;
        }

        public ClassNodeWrapper getClassNode() {
            return this.classNode;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class TreeAttribute
        implements Comparable,
        IChildrenProvider {
            private ClassNodeWrapper classNode;
            private TreeAccessor reader;
            private TreeAccessor writer;
            private boolean readerSelected;
            private boolean writerSelected;
            private String name;

            public TreeAttribute(INameNode node, ClassNodeWrapper classNode) {
                this.classNode = classNode;
                this.name = node.getName();
                if (this.name.indexOf(64) == 0) {
                    this.name = this.name.substring(1);
                }
                this.reader = new TreeAccessor(this.name, true);
                this.writer = new TreeAccessor(this.name, false);
                this.readerSelected = false;
                this.writerSelected = false;
            }

            public String toString() {
                return this.name;
            }

            public String getName() {
                return this.name;
            }

            @Override
            public Object[] getChildren() {
                return this.getChlidren().toArray();
            }

            private Collection<TreeAccessor> getChlidren() {
                ArrayList<TreeAccessor> accessors = new ArrayList<TreeAccessor>();
                if (!this.existsSameAccessor(this.reader, AccessorsGenerator.this.type)) {
                    accessors.add(this.reader);
                }
                if (!this.existsSameAccessor(this.writer, AccessorsGenerator.this.type)) {
                    accessors.add(this.writer);
                }
                return accessors;
            }

            private boolean existsSameAccessor(TreeAccessor accessor, int type) {
                if (type == 1) {
                    return this.existsSimpleAccessor(accessor);
                }
                return this.existsMethodAccessor(accessor);
            }

            private boolean existsSimpleAccessor(TreeAccessor treeAccessor) {
                for (AttrAccessorNodeWrapper aktAccessorNode : TreeClass.this.existingSimpleAccessorNodes) {
                    if (!this.isSameSimpleAccessorType(treeAccessor, aktAccessorNode) || !aktAccessorNode.getAttrName().equals(treeAccessor.getAttributeName())) continue;
                    return true;
                }
                return false;
            }

            private boolean isSameSimpleAccessorType(TreeAccessor accessor, AttrAccessorNodeWrapper node) {
                return node.getAccessorTypeName().equals("attr_accessor") || node.getAccessorTypeName().equals("attr_reader") && accessor.isReader() || node.getAccessorTypeName().equals("attr_writer") && accessor.isWriter();
            }

            private boolean existsMethodAccessor(TreeAccessor accessor) {
                for (MethodNodeWrapper node : TreeClass.this.existingMethodAccessorNodes) {
                    if (this.isSameReader(accessor, node)) {
                        return true;
                    }
                    if (!this.isSameWriter(accessor, node)) continue;
                    return true;
                }
                return false;
            }

            private boolean isSameWriter(TreeAccessor accessor, MethodNodeWrapper methodNode) {
                String argName;
                ArgsNodeWrapper argsNode;
                return methodNode.getName().equals(String.valueOf(accessor.getAttributeName()) + '=') && accessor.isWriter() && (argsNode = methodNode.getArgsNode()).getArgsList().size() == 1 && argsNode.getOptArgs() == null && argsNode.getBlockArgNode() == null && (argName = argsNode.getArgsList().iterator().next()).equals(accessor.getAttributeName());
            }

            private boolean isSameReader(TreeAccessor accessor, MethodNodeWrapper node) {
                return node.getName().equals(accessor.getAttributeName()) && accessor.isReader() && !node.getArgsNode().hasArgs();
            }

            @Override
            public boolean hasChildren() {
                return !this.getChlidren().isEmpty();
            }

            public int compareTo(Object arg0) {
                String otherStr;
                String thisStr = String.valueOf(this.classNode.getName()) + this.name;
                if (arg0 instanceof String) {
                    otherStr = (String)arg0;
                } else {
                    TreeAttribute otherAttr = (TreeAttribute)arg0;
                    ClassNodeWrapper otherClassNode = otherAttr.getTreeClass().getClassNode();
                    otherStr = String.valueOf(otherClassNode.getName()) + otherAttr.toString();
                }
                return thisStr.compareTo(otherStr);
            }

            public boolean equals(Object o) {
                return o != null && o instanceof TreeAttribute && this.compareTo(o) == 0;
            }

            public int hashCode() {
                return 0;
            }

            public void clearSelection() {
                this.readerSelected = false;
                this.writerSelected = false;
            }

            public void setReaderSelected() {
                this.readerSelected = true;
            }

            public void setWriterSelected() {
                this.writerSelected = true;
            }

            public TreeClass getTreeClass() {
                return TreeClass.this;
            }

            public Collection<EditProvider> getGeneratedAccessors() {
                ArrayList<EditProvider> accessors = new ArrayList<EditProvider>();
                if (this.readerSelected && this.writerSelected) {
                    accessors.add(new GeneratedAccessor("attr_accessor", this.toString(), AccessorsGenerator.this.type, this.classNode));
                } else if (this.readerSelected) {
                    accessors.add(new GeneratedAccessor("attr_reader", this.toString(), AccessorsGenerator.this.type, this.classNode));
                } else if (this.writerSelected) {
                    accessors.add(new GeneratedAccessor("attr_writer", this.toString(), AccessorsGenerator.this.type, this.classNode));
                }
                return accessors;
            }

            public class TreeAccessor {
                private boolean isReader;
                private String name;

                public TreeAccessor(String name, boolean isReader) {
                    this.name = name;
                    this.isReader = isReader;
                }

                public String toString() {
                    return this.isReader() ? READER : WRITER;
                }

                public boolean isWriter() {
                    return !this.isReader;
                }

                public boolean isReader() {
                    return this.isReader;
                }

                public String getAttributeName() {
                    return this.name;
                }

                public TreeAttribute getAttribute() {
                    return TreeAttribute.this;
                }
            }
        }
    }
}

