/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.extractmethod;

import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.core.IRefactoringConfig;
import org.rubypeople.rdt.refactoring.core.IRefactoringContext;
import org.rubypeople.rdt.refactoring.core.RefactoringContext;
import org.rubypeople.rdt.refactoring.core.extractmethod.ExtractedMethodHelper;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.PartialClassNodeWrapper;

public class ExtractMethodConfig
implements IRefactoringConfig {
    private IDocumentProvider docProvider;
    private IRefactoringContext selectionInfo;
    private ExtractedMethodHelper extractMethodHelper;
    private Node selectedNodes;
    private Node enclosingNode;
    private MethodDefNode enclosingMethodNode;
    private PartialClassNodeWrapper enclosingClassNode;
    private Node rootNode;

    public ExtractMethodConfig(IDocumentProvider docProvider, IRefactoringContext selectionInfo) {
        this.docProvider = docProvider;
        this.selectionInfo = this.optimizeSelection(selectionInfo);
    }

    private IRefactoringContext optimizeSelection(IRefactoringContext selectionInfo) {
        String content;
        int start = selectionInfo.getStartOffset();
        int end = selectionInfo.getEndOffset() + 1;
        if (end > (content = this.docProvider.getActiveFileContent()).length()) {
            end = content.length();
        }
        if (end == start) {
            return selectionInfo;
        }
        String selectedText = content.substring(start, end);
        String trimedSelectionInformation = selectedText.trim();
        end = (start += selectedText.indexOf(trimedSelectionInformation)) + trimedSelectionInformation.length() - 1;
        return new RefactoringContext(start, end, start, selectionInfo.getSource());
    }

    public IDocumentProvider getDocumentProvider() {
        return this.docProvider;
    }

    public ExtractedMethodHelper getHelper() {
        return this.extractMethodHelper;
    }

    public IRefactoringContext getSelection() {
        return this.selectionInfo;
    }

    public void setEnclosingScopeNode(Node enclosingScopeNode) {
        this.enclosingNode = enclosingScopeNode;
    }

    public void setEnclosingMethodNode(MethodDefNode enclosingMethodNode) {
        this.enclosingMethodNode = enclosingMethodNode;
    }

    public void setSelectedNodes(Node selectedNodes) {
        this.selectedNodes = selectedNodes;
    }

    public void setEnclosingClassNode(PartialClassNodeWrapper classNode) {
        this.enclosingClassNode = classNode;
    }

    public Node getSelectedNodes() {
        return this.selectedNodes;
    }

    public void setExtractedMethodHelper(ExtractedMethodHelper extractedMethodHelper) {
        this.extractMethodHelper = extractedMethodHelper;
    }

    public boolean hasEnclosingClassNode() {
        return this.enclosingClassNode != null;
    }

    public PartialClassNodeWrapper getEnclosingClassNode() {
        return this.enclosingClassNode;
    }

    public Node getEnclosingScopeNode() {
        return this.enclosingNode;
    }

    public MethodDefNode getEnclosingMethodNode() {
        return this.enclosingMethodNode;
    }

    public boolean hasEnclosingMethodNode() {
        return this.enclosingMethodNode != null;
    }

    public void setRootNode(Node rootNode) {
        this.rootNode = rootNode;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public void setDocumentProvider(IDocumentProvider doc) {
        this.docProvider = doc;
    }

    public ExtractedMethodHelper getExtractMethodHelper() {
        return this.extractMethodHelper;
    }
}

