/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.extractmethod;

import java.util.Collection;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.Node;
import org.jruby.ast.RedoNode;
import org.jruby.ast.RetryNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.ZSuperNode;
import org.rubypeople.rdt.refactoring.core.IRefactoringConfig;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.RefactoringConditionChecker;
import org.rubypeople.rdt.refactoring.core.SelectionNodeProvider;
import org.rubypeople.rdt.refactoring.core.extractmethod.ExtractMethodConfig;
import org.rubypeople.rdt.refactoring.core.extractmethod.ExtractedMethodHelper;
import org.rubypeople.rdt.refactoring.core.extractmethod.Messages;
import org.rubypeople.rdt.refactoring.exception.NoClassNodeException;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodCallNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.PartialClassNodeWrapper;
import org.rubypeople.rdt.refactoring.util.NodeUtil;

public class ExtractMethodConditionChecker
extends RefactoringConditionChecker {
    private ExtractMethodConfig config;

    public ExtractMethodConditionChecker(ExtractMethodConfig config) {
        super(config);
    }

    public void init(IRefactoringConfig configObj) {
        this.config = (ExtractMethodConfig)configObj;
        this.initEnclosingNodes();
        if (!NodeProvider.isEmptyNode(this.config.getSelectedNodes()) && this.config.getExtractMethodHelper() == null) {
            this.config.setExtractedMethodHelper(new ExtractedMethodHelper(this.config));
        }
    }

    private void initEnclosingNodes() {
        RootNode rootNode = this.config.getDocumentProvider().getActiveFileRootNode();
        this.config.setRootNode((Node)rootNode);
        this.config.setEnclosingScopeNode(SelectionNodeProvider.getEnclosingScope((Node)rootNode, this.config.getSelection().getStartOffset()));
        this.config.setEnclosingMethodNode((MethodDefNode)SelectionNodeProvider.getEnclosingNode((Node)rootNode, this.config.getSelection(), MethodDefNode.class));
        this.config.setSelectedNodes(this.getSelectedNodes(rootNode));
        Node classNode = SelectionNodeProvider.getEnclosingNode((Node)rootNode, this.config.getSelection(), ClassNode.class, SClassNode.class);
        try {
            this.config.setEnclosingClassNode(PartialClassNodeWrapper.getPartialClassNodeWrapper(classNode, (Node)rootNode));
        }
        catch (NoClassNodeException noClassNodeException) {}
    }

    private Node getSelectedNodes(RootNode rootNode) {
        ArrayNode enclosingMethodCallArgs;
        ArrayNode enclosingArrayNode;
        WhenNode enclosingWhen;
        Node selectedNode = SelectionNodeProvider.getSelectedNodes((Node)rootNode, this.config.getSelection());
        if (NodeUtil.nodeAssignableFrom(selectedNode, WhenNode.class)) {
            selectedNode = SelectionNodeProvider.getEnclosingNode((Node)rootNode, this.config.getSelection(), CaseNode.class);
        }
        if (NodeUtil.nodeAssignableFrom(selectedNode, ArrayNode.class) && (enclosingWhen = (WhenNode)SelectionNodeProvider.getEnclosingNode((Node)rootNode, this.config.getSelection(), WhenNode.class)) != null && SelectionNodeProvider.nodeEnclosesNode(enclosingWhen.getExpressionNodes(), selectedNode)) {
            selectedNode = SelectionNodeProvider.getEnclosingNode((Node)rootNode, this.config.getSelection(), CaseNode.class);
        }
        if (this.containsLoopControlNode(selectedNode)) {
            selectedNode = this.getLoopOrItsParent(rootNode, selectedNode);
        }
        if (SelectionNodeProvider.getEnclosingNode((Node)rootNode, this.config.getSelection(), ArgsNode.class) != null) {
            return SelectionNodeProvider.getEnclosingNode((Node)rootNode, this.config.getSelection(), MethodDefNode.class);
        }
        if (NodeUtil.nodeAssignableFrom(selectedNode, ArgumentNode.class)) {
            selectedNode = this.config.getEnclosingMethodNode();
        }
        if (!this.sectedNodesInArrayNode(enclosingArrayNode = (ArrayNode)SelectionNodeProvider.getEnclosingNode((Node)rootNode, this.config.getSelection(), ArrayNode.class), selectedNode) || !NodeUtil.nodeAssignableFrom(selectedNode, ArrayNode.class)) {
            return selectedNode;
        }
        Node enclosingMethodCallNode = SelectionNodeProvider.getEnclosingNode((Node)rootNode, this.config.getSelection(), MethodCallNodeWrapper.METHOD_CALL_NODE_CLASSES());
        MethodCallNodeWrapper enclosingMethodCall = new MethodCallNodeWrapper(enclosingMethodCallNode);
        if (NodeUtil.nodeAssignableFrom(enclosingMethodCall.getArgsNode(), ArrayNode.class) && enclosingArrayNode == (enclosingMethodCallArgs = (ArrayNode)enclosingMethodCall.getArgsNode())) {
            return enclosingMethodCallNode;
        }
        MultipleAsgnNode asgnNode = (MultipleAsgnNode)SelectionNodeProvider.getEnclosingNode((Node)rootNode, this.config.getSelection(), MultipleAsgnNode.class);
        if (asgnNode != null) {
            NodeUtil.nodeAssignableFrom((Node)asgnNode.getHeadNode(), ArrayNode.class);
        }
        return selectedNode;
    }

    private Node getLoopOrItsParent(RootNode rootNode, Node selectedNode) {
        Node loopNode = NodeProvider.getEnclosingNodeOfType((Node)rootNode, selectedNode, WhileNode.class, ForNode.class, IterNode.class);
        if (loopNode != null) {
            selectedNode = loopNode;
        }
        if (NodeUtil.nodeAssignableFrom(loopNode, IterNode.class)) {
            selectedNode = NodeProvider.findParentNode((Node)rootNode, loopNode);
        }
        return selectedNode;
    }

    private boolean containsLoopControlNode(Node selectedNode) {
        return !NodeProvider.getSubNodes(selectedNode, BreakNode.class, RedoNode.class, NextNode.class, RetryNode.class).isEmpty();
    }

    private boolean sectedNodesInArrayNode(ArrayNode arrayNode, Node selectedNode) {
        if (arrayNode == null) {
            return false;
        }
        Collection<Node> arrayChilds = NodeProvider.getAllNodes((Node)arrayNode);
        for (Object actSelectedNode : selectedNode.childNodes()) {
            if (arrayChilds.contains(actSelectedNode)) continue;
            return false;
        }
        return true;
    }

    protected void checkFinalConditions() {
        this.checkNewMethodName();
    }

    private void checkNewMethodName() {
        String newMethodName = this.config.getHelper().getMethodName();
        PartialClassNodeWrapper enclosingClassNode = this.config.getEnclosingClassNode();
        if (enclosingClassNode != null) {
            Collection<Node> methodNodes = NodeProvider.getSubNodes(enclosingClassNode.getWrappedNode(), DefnNode.class);
            for (Node aktNode : methodNodes) {
                if (!((DefnNode)aktNode).getName().equals(newMethodName)) continue;
                this.addError(Messages.ExtractMethodConditionChecker_MethodAlreadyExists);
            }
        }
    }

    protected void checkInitialConditions() {
        if (!this.existSelectedNodes()) {
            this.addError(Messages.ExtractMethodConditionChecker_NothingToDo);
        } else if (this.containsYieldStatements()) {
            this.addError(Messages.ExtractMethodConditionChecker_NotPossibleContainsYield);
        } else if (this.containsSuperStatement()) {
            this.addError(Messages.ExtractMethodConditionChecker_NotPossibleContainsSuper);
        } else if (this.isModuleInSelection()) {
            this.addError(Messages.ExtractMethodConditionChecker_NotPossibleModule);
        } else if (this.isClassInSelection()) {
            this.addError(Messages.ExtractMethodConditionChecker_MustNotContainAClass);
        } else if (this.isMethodInSelction()) {
            this.addError(Messages.ExtractMethodConditionChecker_MustNotContainAMethod);
        } else {
            this.checkInternalMethods();
        }
    }

    private boolean existSelectedNodes() {
        return !NodeProvider.isEmptyNode(this.config.getSelectedNodes());
    }

    private boolean containsYieldStatements() {
        return NodeProvider.hasSubNodes(this.config.getSelectedNodes(), YieldNode.class);
    }

    private boolean containsSuperStatement() {
        return NodeProvider.hasSubNodes(this.config.getSelectedNodes(), SuperNode.class, ZSuperNode.class);
    }

    private boolean isModuleInSelection() {
        Node selctedNodes = this.config.getSelectedNodes();
        Collection<Node> moduleNodes = NodeProvider.getSubNodes(selctedNodes, ModuleNode.class);
        return !moduleNodes.isEmpty();
    }

    private boolean isClassInSelection() {
        Node selctedNodes = this.config.getSelectedNodes();
        Collection<Node> classNodes = NodeProvider.getSubNodes(selctedNodes, ClassNode.class);
        return !classNodes.isEmpty();
    }

    private boolean isMethodInSelction() {
        Node selctedNodes = this.config.getSelectedNodes();
        Collection<Node> methodNodes = NodeProvider.getSubNodes(selctedNodes, MethodDefNode.class);
        return !methodNodes.isEmpty();
    }

    private void checkInternalMethods() {
        if (this.config.hasEnclosingClassNode() && !this.config.hasEnclosingMethodNode()) {
            this.addError(Messages.ExtractMethodConditionChecker_NotInsideAMethod);
        }
        if (this.config.hasEnclosingClassNode() && NodeProvider.hasSubNodes(NodeUtil.getBody(this.config.getEnclosingScopeNode()), DefnNode.class)) {
            this.addError(Messages.ExtractMethodConditionChecker_MustNotContainSubmethods);
        }
    }
}

