/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.extractconstant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.rubypeople.rdt.refactoring.core.extractconstant.ExtractConstantConfig;
import org.rubypeople.rdt.refactoring.core.extractconstant.ExtractedConstantCall;
import org.rubypeople.rdt.refactoring.core.extractconstant.ExtractedConstantDef;
import org.rubypeople.rdt.refactoring.core.extractconstant.MatchingNodesVisitor;
import org.rubypeople.rdt.refactoring.editprovider.EditProvider;
import org.rubypeople.rdt.refactoring.editprovider.MultiEditProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantExtractor
extends MultiEditProvider {
    private ExtractConstantConfig config;
    private boolean replaceAll;

    public ConstantExtractor(ExtractConstantConfig config) {
        this.config = config;
    }

    @Override
    protected Collection<EditProvider> getEditProviders() {
        ArrayList<EditProvider> providers = new ArrayList<EditProvider>();
        if (this.replaceAll) {
            Node selection = this.config.getSelectedNodes();
            Node rootNode = this.config.getRootNode();
            MatchingNodesVisitor visitor = new MatchingNodesVisitor(selection, this.config.getDocumentProvider().getActiveFileContent());
            rootNode.accept((NodeVisitor)visitor);
            List<Node> matches = visitor.getMatches();
            for (Node node : matches) {
                providers.add(new ExtractedConstantCall(node, this.config.getConstantCallNode()));
            }
        } else {
            providers.add(new ExtractedConstantCall(this.config));
        }
        providers.add(new ExtractedConstantDef(this.config));
        return providers;
    }

    public EditProvider getDefEdit() {
        return new ExtractedConstantDef(this.config);
    }

    public void setConstantName(String name) {
        this.config.setConstantName(name);
    }

    public String getConstantName() {
        return this.config.getConstantName();
    }

    public void setReplaceAllInstances(boolean selection) {
        this.replaceAll = selection;
    }
}

