/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.convertlocaltofield;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.StrNode;
import org.jruby.ast.VCallNode;
import org.rubypeople.rdt.refactoring.core.SelectionNodeProvider;
import org.rubypeople.rdt.refactoring.core.convertlocaltofield.InitInConstructorEditProvider;
import org.rubypeople.rdt.refactoring.core.convertlocaltofield.LocalToFieldConfig;
import org.rubypeople.rdt.refactoring.core.convertlocaltofield.LocalToFieldEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.DeleteEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.EditProvider;
import org.rubypeople.rdt.refactoring.editprovider.MultiEditProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.LocalNodeWrapper;
import org.rubypeople.rdt.refactoring.util.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalToFieldConverter
extends MultiEditProvider {
    public static final int INIT_IN_METHOD = 1;
    public static final int INIT_IN_CONSTRUCTOR = 2;
    private int initPlace;
    private Collection<LocalNodeWrapper> localNodes;
    private LocalToFieldConfig config;

    public LocalToFieldConverter(LocalToFieldConfig config) {
        this.config = config;
        config.setNewName(this.getLocalVarName());
        this.localNodes = this.gatherLocalNodes();
    }

    private Collection<LocalNodeWrapper> gatherLocalNodes() {
        Collection<Node> allNodes = this.gatherLocalNodes(NodeUtil.getBody((Node)this.config.getEnclosingMethod()));
        Collection<LocalNodeWrapper> allLocalNodes = LocalNodeWrapper.createLocalNodes(allNodes);
        ArrayList<LocalNodeWrapper> affectedLocalNodes = new ArrayList<LocalNodeWrapper>();
        String selectedNodeName = LocalNodeWrapper.getLocalNodeName(this.config.getSelectedNode());
        for (LocalNodeWrapper aktLokalNode : allLocalNodes) {
            String aktLokalNodeName = LocalNodeWrapper.getLocalNodeName(aktLokalNode);
            if (!selectedNodeName.equals(aktLokalNodeName)) continue;
            affectedLocalNodes.add(aktLokalNode);
        }
        return affectedLocalNodes;
    }

    private Collection<Node> gatherLocalNodes(Node baseNode) {
        ArrayList<Node> candidates = new ArrayList<Node>();
        if (baseNode == null || baseNode instanceof MethodDefNode) {
            return candidates;
        }
        for (Object o : baseNode.childNodes()) {
            Node n = (Node)o;
            if (NodeUtil.nodeAssignableFrom(n, LocalNodeWrapper.LOCAL_NODES_CLASSES)) {
                candidates.add(n);
            }
            if (NodeUtil.nodeAssignableFrom(n, DAsgnNode.class, LocalAsgnNode.class)) continue;
            candidates.addAll(this.gatherLocalNodes(n));
        }
        return candidates;
    }

    @Override
    protected Collection<EditProvider> getEditProviders() {
        return this.getConversions(this.localNodes);
    }

    private Collection<EditProvider> getConversions(Collection<LocalNodeWrapper> localNodes) {
        LinkedHashMap<LocalNodeWrapper, LocalToFieldEditProvider> editProviderMap = new LinkedHashMap<LocalNodeWrapper, LocalToFieldEditProvider>();
        LocalNodeWrapper firstLocalNode = localNodes.toArray(new LocalNodeWrapper[localNodes.size()])[0];
        for (LocalNodeWrapper aktLocalNode : localNodes) {
            boolean initInConstructor = this.initPlace == 2;
            LocalToFieldEditProvider conversion = new LocalToFieldEditProvider(aktLocalNode, this.config.getNewName(), this.config.isClassField(), initInConstructor);
            editProviderMap.put(aktLocalNode, conversion);
        }
        if (this.initPlace == 2) {
            editProviderMap.remove(firstLocalNode);
        }
        ArrayList<EditProvider> editProviders = new ArrayList<EditProvider>(editProviderMap.values());
        if (this.initPlace == 2) {
            editProviders.add(new InitInConstructorEditProvider(firstLocalNode, this.config));
            editProviders.add(new DeleteEditProvider(firstLocalNode.getWrappedNode()));
        }
        return editProviders;
    }

    public void setNewName(String newName) {
        this.config.setNewName(newName);
    }

    public void setInitPlace(int initPlace) {
        this.initPlace = initPlace;
    }

    public void setIsClassField(boolean isClassField) {
        this.config.setClassField(isClassField);
    }

    public String getLocalVarName() {
        return LocalNodeWrapper.getLocalNodeName(this.config.getSelectedNode());
    }

    private Node findSelectedNode(Class<?> ... filterNodes) {
        return SelectionNodeProvider.getSelectedNodeOfType((Node)this.config.getDocumentProvider().getActiveFileRootNode(), this.config.getCaretPosition(), (Class[])filterNodes);
    }

    boolean isInitializationExternalizable() {
        if (this.config.getEnclosingMethod() == null) {
            return false;
        }
        LocalNodeWrapper firstNodeInAST = this.getFirstLocalNodeWrapper();
        if (firstNodeInAST == null) {
            return false;
        }
        if (this.findSelectedNode(MultipleAsgnNode.class) != null) {
            return false;
        }
        if (firstNodeInAST.getWrappedNode() instanceof LocalAsgnNode) {
            LocalAsgnNode firstAssignment = (LocalAsgnNode)firstNodeInAST.getWrappedNode();
            Node assignmentValue = firstAssignment.getValueNode();
            return this.hasSameClass(assignmentValue, FixnumNode.class, StrNode.class, VCallNode.class, InstVarNode.class, ClassVarNode.class);
        }
        return false;
    }

    private boolean hasSameClass(Node assignmentValue, Class<?> ... klasses) {
        Class<?>[] classArray = klasses;
        int n = klasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> klass = classArray[n2];
            if (assignmentValue.getClass().equals(klass)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private LocalNodeWrapper getFirstLocalNodeWrapper() {
        if (this.localNodes == null || this.localNodes.isEmpty()) {
            return null;
        }
        return this.localNodes.toArray(new LocalNodeWrapper[this.localNodes.size()])[0];
    }

    boolean isVariableInConstructor() {
        if (this.config.getEnclosingMethod() == null) {
            return false;
        }
        return this.config.getEnclosingMethod().getName().equals("initialize");
    }
}

