/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.types.INameNode;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.refactoring.core.IRefactoringContext;
import org.rubypeople.rdt.refactoring.core.NodeFactory;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.exception.NoClassNodeException;
import org.rubypeople.rdt.refactoring.nodewrapper.AttrAccessorNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.INodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.PartialClassNodeWrapper;
import org.rubypeople.rdt.refactoring.util.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionNodeProvider {
    public static final int CURSOR_TOLERANCE = 1;

    public static Node getEnclosingScope(Node rootNode, Node from) {
        return SelectionNodeProvider.getEnclosingScope(rootNode, from.getPosition().getStartOffset());
    }

    public static Node getEnclosingScope(Node rootNode, int where) {
        return SelectionNodeProvider.getSelectedNodeOfType(rootNode, where, MethodDefNode.class, ClassNode.class, RootNode.class, IterNode.class);
    }

    public static Node getSelectedNodes(Node rootNode, IRefactoringContext selection) {
        Node enclosingNode = SelectionNodeProvider.getEnclosingNode(rootNode, selection, Node.class);
        if (enclosingNode == null) {
            return null;
        }
        BlockNode enclosingBlockNode = (BlockNode)SelectionNodeProvider.getEnclosingNode(rootNode, selection, BlockNode.class);
        if (enclosingBlockNode == null) {
            return enclosingNode;
        }
        Collection<Node> blockChildren = NodeProvider.getChildren((Node)enclosingBlockNode);
        Node beginNode = SelectionNodeProvider.getSelectedNodeOfType((Node)enclosingBlockNode, selection.getStartOffset(), Node.class);
        Node beginBlockChildNode = SelectionNodeProvider.getEnclosingNode(beginNode, blockChildren);
        Node endNode = SelectionNodeProvider.getSelectedNodeOfType((Node)enclosingBlockNode, selection.getEndOffset(), Node.class);
        Node endBlockChildNode = SelectionNodeProvider.getEnclosingNode(endNode, blockChildren);
        Collection<Node> selectedNodes = SelectionNodeProvider.getNodesFromTo(beginBlockChildNode, endBlockChildNode, blockChildren);
        if (SelectionNodeProvider.isNodeContainedInNode(selectedNodes.toArray(new Node[selectedNodes.size()])[0], enclosingNode)) {
            BlockNode blockAroundSelected = NodeFactory.createBlockNode(selectedNodes.toArray(new Node[0]));
            blockAroundSelected.setPosition(NodeFactory.unionPositions(NodeProvider.unwrap(beginBlockChildNode).getPosition(), NodeProvider.unwrap(endBlockChildNode).getPosition()));
            return blockAroundSelected;
        }
        if (beginNode.equals(endNode)) {
            return beginNode;
        }
        return enclosingNode;
    }

    public static boolean isNodeContainedInNode(Node containedNode, Node containingNode) {
        return SelectionNodeProvider.nodeContainsPosition(containingNode, containedNode.getPosition().getStartOffset()) && SelectionNodeProvider.nodeContainsPosition(containingNode, containedNode.getPosition().getEndOffset());
    }

    private static Collection<Node> getNodesFromTo(Node beginNode, Node endNode, Collection<Node> allNodes) {
        ArrayList<Node> affectedNodes = new ArrayList<Node>();
        boolean between = false;
        for (Node aktNode : allNodes) {
            if (aktNode.equals(beginNode)) {
                between = true;
            }
            if (between) {
                affectedNodes.add(aktNode);
            }
            if (!aktNode.equals(endNode)) continue;
            between = false;
        }
        return affectedNodes;
    }

    private static Node getEnclosingNode(Node enclosedNode, Collection<Node> possibleEnclosingNodes) {
        for (Node aktNode : possibleEnclosingNodes) {
            if (!SelectionNodeProvider.nodeEnclosesNode(aktNode, enclosedNode)) continue;
            return aktNode;
        }
        return null;
    }

    public static boolean nodeEnclosesNode(Node enclosingNode, Node enclosedNode) {
        ISourcePosition enclosingPos = enclosingNode.getPosition();
        ISourcePosition enclosedPos = enclosedNode.getPosition();
        return enclosingPos.getStartOffset() <= enclosedPos.getStartOffset() && enclosingPos.getEndOffset() >= enclosedPos.getEndOffset();
    }

    public static Node getEnclosingNode(Node rootNode, IRefactoringContext selection, Class ... classes) {
        Collection<Node> enclosingNodes = SelectionNodeProvider.getEnclosingNodes(rootNode, selection, classes);
        Node lastNode = null;
        Node secondLastNode = null;
        Node thirdLastNode = null;
        for (Node aktNode : enclosingNodes) {
            thirdLastNode = secondLastNode;
            secondLastNode = lastNode;
            lastNode = aktNode;
        }
        if (thirdLastNode != null && SelectionNodeProvider.sameStartPosAndIsVariableNode(thirdLastNode, lastNode) && SelectionNodeProvider.hasSamePosAndIsSelfAsignment(secondLastNode, thirdLastNode)) {
            return thirdLastNode;
        }
        if (secondLastNode != null && SelectionNodeProvider.hasSamePosAndIsSelfAsignment(lastNode, secondLastNode)) {
            return secondLastNode;
        }
        return lastNode;
    }

    private static boolean sameStartPosAndIsVariableNode(Node firstNode, Node secondNode) {
        Class[] classes = new Class[]{LocalAsgnNode.class, LocalVarNode.class, DAsgnNode.class, DVarNode.class, InstAsgnNode.class, InstVarNode.class, ClassVarAsgnNode.class, ClassVarNode.class, GlobalAsgnNode.class, GlobalVarNode.class};
        boolean sameStart = firstNode.getPosition().getStartOffset() == secondNode.getPosition().getStartOffset();
        boolean isFirstNodeVarNode = NodeUtil.nodeAssignableFrom(firstNode, classes);
        boolean isSecondNodeVarNode = NodeUtil.nodeAssignableFrom(secondNode, classes);
        return sameStart && isFirstNodeVarNode && isSecondNodeVarNode;
    }

    private static boolean hasSamePosAndIsSelfAsignment(Node probablyCallNode, Node probablyAsgnNode) {
        boolean sameStart = probablyCallNode.getPosition().getStartOffset() == probablyAsgnNode.getPosition().getStartOffset();
        boolean sameEnd = probablyCallNode.getPosition().getEndOffset() == probablyAsgnNode.getPosition().getEndOffset();
        boolean isAsgnNode = NodeUtil.nodeAssignableFrom(probablyAsgnNode, LocalAsgnNode.class, DAsgnNode.class, InstAsgnNode.class, ClassVarAsgnNode.class);
        boolean isCallNode = NodeUtil.nodeAssignableFrom(probablyCallNode, CallNode.class, AttrAssignNode.class);
        return sameStart && sameEnd && isCallNode && isAsgnNode;
    }

    public static Collection<Node> getEnclosingNodes(Node rootNode, IRefactoringContext selection, Class ... classes) {
        Collection<Node> allNodes = NodeProvider.getAllNodes(rootNode);
        Collection<Node> enclosingStartNodes = SelectionNodeProvider.getSelectedNodesOfType(allNodes, selection.getStartOffset(), classes);
        ArrayList<Node> enclosingNodes = new ArrayList<Node>();
        for (Node aktNode : enclosingStartNodes) {
            if (!SelectionNodeProvider.nodeContainsPosition(aktNode, selection.getEndOffset())) break;
            enclosingNodes.add(aktNode);
        }
        return enclosingNodes;
    }

    public static Node getSelectedNodeOfType(Node baseNode, int position, Class ... klasses) {
        return SelectionNodeProvider.getSelectedNodeOfType(NodeProvider.getAllNodes(baseNode), position, klasses);
    }

    public static Node getSelectedNodeOfType(Collection<? extends Node> nodes, int position, Class ... klasses) {
        return SelectionNodeProvider.returnLast(SelectionNodeProvider.getSelectedNodesOfType(nodes, position, klasses));
    }

    private static Node returnLast(Collection<Node> candidates) {
        if (candidates.size() <= 0) {
            return null;
        }
        Node candidate = candidates.toArray(new Node[candidates.size()])[0];
        for (Node node : candidates) {
            if (node.getPosition().getEndOffset() > candidate.getPosition().getEndOffset()) continue;
            candidate = node;
        }
        return candidate;
    }

    public static Collection<Node> getSelectedNodesOfType(Collection<? extends Node> nodes, int position, Class ... klasses) {
        ArrayList<Node> candidates = new ArrayList<Node>();
        for (Node node : nodes) {
            if (!SelectionNodeProvider.nodeContainsPosition(node, position) || node instanceof NewlineNode || !NodeUtil.nodeAssignableFrom(node, klasses)) continue;
            candidates.add(node);
        }
        return candidates;
    }

    public static Collection<Node> getSelectedNodesOfType(Node baseNode, int position, Class ... klasses) {
        return SelectionNodeProvider.getSelectedNodesOfType(NodeProvider.getAllNodes(baseNode), position, klasses);
    }

    public static boolean nodeContainsPosition(Node n, int position) {
        return position + 1 >= NodeUtil.subPositionUnion(n).getStartOffset() && position - 1 < NodeUtil.subPositionUnion(n).getEndOffset();
    }

    public static String[] localNamesFromLocalAsgnNodes(Collection<LocalAsgnNode> nodes) {
        Vector<String> names = new Vector<String>();
        names.setSize(nodes.size() + 2);
        names.set(0, "_");
        names.set(1, "~");
        for (LocalAsgnNode n : nodes) {
            if (n.getIndex() >= names.size()) {
                names.setSize(n.getIndex() + 1);
            }
            names.set(n.getIndex(), n.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    public static ClassNodeWrapper getSelectedClassNode(Node rootNode, int position) throws NoClassNodeException {
        Node enclosingClassNode = SelectionNodeProvider.getSelectedNodeOfType(rootNode, position, ClassNode.class);
        PartialClassNodeWrapper partialClassNode = PartialClassNodeWrapper.getPartialClassNodeWrapper(enclosingClassNode, rootNode);
        ArrayList<ModuleNode> moduleNodes = new ArrayList<ModuleNode>();
        Collection<Node> subNodes = NodeProvider.getSubNodes(rootNode, ModuleNode.class);
        for (Node node : subNodes) {
            if (!SelectionNodeProvider.nodeContainsPosition(node, position)) continue;
            moduleNodes.add((ModuleNode)node);
        }
        partialClassNode.setEnclosingModules(moduleNodes);
        return new ClassNodeWrapper(partialClassNode);
    }

    public static AttrAccessorNodeWrapper getSelectedAccessorNode(Node baseNode, INameNode selectedAccessorNameNode) {
        Collection<AttrAccessorNodeWrapper> accessorNodes = NodeProvider.getAccessorNodes(baseNode);
        String selectedName = selectedAccessorNameNode.getName();
        if (selectedName.charAt(0) == '@') {
            selectedName = selectedName.substring(1);
        }
        AttrAccessorNodeWrapper selectedAccessor = null;
        for (AttrAccessorNodeWrapper aktAccessorNode : accessorNodes) {
            if (!aktAccessorNode.getAttrName().equals(selectedName)) continue;
            if (selectedAccessor == null) {
                selectedAccessor = aktAccessorNode;
                continue;
            }
            selectedAccessor.addAccessorType(aktAccessorNode);
        }
        return selectedAccessor;
    }

    public static <T extends INodeWrapper> T getSelectedWrappedNode(Collection<T> candidates, int caretPosition) {
        INodeWrapper selected = null;
        for (INodeWrapper aktNode : candidates) {
            if (!SelectionNodeProvider.nodeContainsPosition(aktNode.getWrappedNode(), caretPosition)) continue;
            selected = SelectionNodeProvider.getBestCandidate(selected, aktNode);
        }
        return (T)selected;
    }

    private static <T extends INodeWrapper> T getBestCandidate(T oldNode, T newNode) {
        if (oldNode == null) {
            return newNode;
        }
        if (SelectionNodeProvider.nodeEnclosesNode(newNode.getWrappedNode(), oldNode.getWrappedNode())) {
            return oldNode;
        }
        return newNode;
    }
}

