/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.corext.refactoring.changes.RenameResourceChange;
import org.rubypeople.rdt.internal.corext.refactoring.changes.RubyScriptChange;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.refactoring.core.DynamicValidationStateChange;
import org.rubypeople.rdt.refactoring.core.IRefactoringConditionChecker;
import org.rubypeople.rdt.refactoring.core.IRefactoringContext;
import org.rubypeople.rdt.refactoring.documentprovider.DocumentProvider;
import org.rubypeople.rdt.refactoring.documentprovider.WorkspaceDocumentProvider;
import org.rubypeople.rdt.refactoring.editprovider.FileMultiEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.FileNameChangeProvider;
import org.rubypeople.rdt.refactoring.editprovider.IEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.IMultiFileEditProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RubyRefactoring
extends Refactoring {
    protected RefactoringStatus initialStatus;
    protected RefactoringStatus finalStatus;
    private String name;
    protected Collection<IWizardPage> pages;
    private IEditProvider editProvider;
    private IMultiFileEditProvider multiFileEditProvider;
    private IRefactoringConditionChecker conditionChecker;
    private IFile file;
    private FileNameChangeProvider fileNameChangeProvider;

    public RubyRefactoring(String name) {
        this(name, null);
    }

    public RubyRefactoring(String name, IRefactoringContext selectionProvider) {
        this.name = name;
        this.initialStatus = new RefactoringStatus();
        this.finalStatus = new RefactoringStatus();
        this.pages = new ArrayList<IWizardPage>();
        if (selectionProvider != null) {
            this.file = selectionProvider.getActiveFile();
        } else {
            RubyEditor editor = (RubyEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            this.file = ((IFileEditorInput)editor.getEditorInput()).getFile();
        }
    }

    protected IFile getActiveFile() {
        return this.file;
    }

    protected void setEditProvider(IEditProvider editProvider) {
        this.editProvider = editProvider;
    }

    protected void setEditProvider(IMultiFileEditProvider multiFileEditProvider) {
        this.multiFileEditProvider = multiFileEditProvider;
    }

    protected void setFileNameChangeProvider(FileNameChangeProvider fileNameChangeProvider) {
        this.fileNameChangeProvider = fileNameChangeProvider;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) {
        if (this.conditionChecker != null) {
            Map<String, Collection<String>> messages = this.conditionChecker.getInitialMessages();
            Collection<String> errors = messages.get("errors");
            for (String errMessage : errors) {
                this.initialStatus.addFatalError(errMessage);
            }
            Collection<String> warnings = messages.get("errors");
            for (String warningMessage : warnings) {
                this.initialStatus.addWarning(warningMessage);
            }
        }
        return this.initialStatus;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.finalStatus = new RefactoringStatus();
        if (this.conditionChecker != null) {
            Map<String, Collection<String>> messages = this.conditionChecker.getFinalMessages();
            Collection<String> errors = messages.get("errors");
            for (String errMessage : errors) {
                this.finalStatus.addFatalError(errMessage);
            }
            Collection<String> warnings = messages.get("warnings");
            for (String warningMessage : warnings) {
                this.finalStatus.addWarning(warningMessage);
            }
        }
        return this.finalStatus;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        Change change = this.createEditChanges();
        Map<String, String> filesToRename = this.getFileNameChangeProvider().getFilesToRename(this.getAllAffectedFiles(change));
        if (filesToRename.isEmpty()) {
            return change;
        }
        CompositeChange compositeChange = new CompositeChange(this.getName(), new Change[]{change});
        compositeChange.markAsSynthetic();
        for (Map.Entry<String, String> entry : filesToRename.entrySet()) {
            RenameResourceChange renameResourceChange = new RenameResourceChange(null, RubyPlugin.getWorkspace().getRoot().findMember(entry.getKey()), entry.getValue(), "comment");
            compositeChange.add((Change)new DynamicValidationStateChange(renameResourceChange));
        }
        return compositeChange;
    }

    private Collection<IFile> getAllAffectedFiles(Change change) {
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        Object[] objectArray = change.getAffectedObjects();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IFile) {
                affectedFiles.add((IFile)object);
            }
            ++n2;
        }
        return affectedFiles;
    }

    private Change createEditChanges() {
        WorkspaceDocumentProvider docProvider = new WorkspaceDocumentProvider(this.getActiveFile());
        if (this.multiFileEditProvider != null) {
            return this.createMultiFileChange(docProvider);
        }
        return this.createActiveFileChange(docProvider);
    }

    private Change createActiveFileChange(DocumentProvider docProvider) {
        return this.getChange(this.getActiveFile(), this.editProvider, docProvider);
    }

    private Change createMultiFileChange(DocumentProvider docProvider) {
        CompositeChange change = new CompositeChange(this.name);
        for (FileMultiEditProvider currentProvider : this.multiFileEditProvider.getFileEditProviders()) {
            IFile currentIFile = this.getDocumentProvider().getIFile(currentProvider.getFileName());
            change.add(this.getChange(currentIFile, currentProvider, docProvider));
        }
        return change;
    }

    private Change getChange(IFile file, IEditProvider editProvider, DocumentProvider docProvider) {
        String fileName = file.getFullPath().toOSString();
        IRubyScript script = RubyCore.create((IFile)file);
        RubyScriptChange change = new RubyScriptChange(fileName, script);
        String document = docProvider.getFileContent(fileName);
        change.setEdit(editProvider.getEdit(document));
        return change;
    }

    public Collection<IWizardPage> getPages() {
        return this.pages;
    }

    public WorkspaceDocumentProvider getDocumentProvider() {
        return new WorkspaceDocumentProvider(this.getActiveFile());
    }

    protected void setRefactoringConditionChecker(IRefactoringConditionChecker conditionChecker) {
        this.conditionChecker = conditionChecker;
    }

    public IRefactoringConditionChecker getConditionChecker() {
        return this.conditionChecker;
    }

    public IEditProvider getEditProvider() {
        return this.editProvider;
    }

    public IMultiFileEditProvider getMultiFileEditProvider() {
        return this.multiFileEditProvider;
    }

    public FileNameChangeProvider getFileNameChangeProvider() {
        return this.fileNameChangeProvider != null ? this.fileNameChangeProvider : new FileNameChangeProvider();
    }
}

