/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core;

import java.util.ArrayList;
import java.util.Collection;
import org.jruby.ast.ConstNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.SelectionNodeProvider;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.ModuleNodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModuleNodeProvider {
    public static ModuleNodeWrapper getSelectedModuleNode(Node root, int pos) {
        ModuleNode module = (ModuleNode)SelectionNodeProvider.getSelectedNodeOfType(root, pos, ModuleNode.class);
        if (module == null) {
            return null;
        }
        return ModuleNodeProvider.createModuleNodeWrapper(root, module);
    }

    private static Collection<ModuleNodeWrapper> findModules(IDocumentProvider doc, IModuleAcceptor acceptor) {
        ArrayList<ModuleNodeWrapper> modules = new ArrayList<ModuleNodeWrapper>();
        for (String file : doc.getFileNames()) {
            for (Node node : NodeProvider.getSubNodes((Node)doc.getRootNode(file), ModuleNode.class)) {
                ModuleNode moduleNode = (ModuleNode)node;
                ModuleNodeWrapper wrapper = ModuleNodeProvider.createModuleNodeWrapper((Node)doc.getRootNode(file), moduleNode);
                if (!acceptor.accept(wrapper)) continue;
                modules.add(wrapper);
            }
        }
        return modules;
    }

    public static Collection<ModuleNodeWrapper> findOtherParts(IDocumentProvider doc, final ModuleNodeWrapper module) {
        return ModuleNodeProvider.findModules(doc, new IModuleAcceptor(){

            public boolean accept(ModuleNodeWrapper wrapper) {
                return wrapper.getFullName().equals(module.getFullName());
            }
        });
    }

    public static Collection<ModuleNodeWrapper> findAllModules(IDocumentProvider doc) {
        return ModuleNodeProvider.findModules(doc, new IModuleAcceptor(){

            public boolean accept(ModuleNodeWrapper wrapper) {
                return true;
            }
        });
    }

    public static Collection<ConstNode> getAllModuleMethodDefinitions(Collection<ModuleNodeWrapper> modules) {
        ArrayList<ConstNode> methods = new ArrayList<ConstNode>();
        for (ModuleNodeWrapper wrapper : modules) {
            methods.addAll(wrapper.getModuleMethodConstNodes());
        }
        return methods;
    }

    private static ModuleNodeWrapper createModuleNodeWrapper(Node root, ModuleNode module) {
        ArrayList<ModuleNode> modules = new ArrayList<ModuleNode>();
        modules.add(module);
        ModuleNode parent = null;
        while ((parent = (ModuleNode)NodeProvider.findParentNode(root, (Node)module, ModuleNode.class)) != null) {
            modules.add(0, parent);
            module = parent;
        }
        ModuleNodeWrapper previousWrapper = null;
        for (ModuleNode node : modules) {
            ModuleNodeWrapper nodeWrapper;
            previousWrapper = nodeWrapper = new ModuleNodeWrapper(node, previousWrapper);
        }
        return previousWrapper;
    }

    private static interface IModuleAcceptor {
        public boolean accept(ModuleNodeWrapper var1);
    }
}

