/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.classnodeprovider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.SClassNode;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;
import org.rubypeople.rdt.refactoring.exception.NoClassNodeException;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.PartialClassNodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassNodeProvider {
    private Map<String, ClassNodeWrapper> classNodeWrappers = new LinkedHashMap<String, ClassNodeWrapper>();
    protected IDocumentProvider documentProvider;

    public ClassNodeProvider(IDocumentProvider docProvider) {
        this(docProvider, true);
    }

    public ClassNodeProvider(IDocumentProvider docProvider, boolean addActiveFile) {
        this.documentProvider = docProvider;
        if (addActiveFile) {
            this.addSource(docProvider.getActiveFileName());
        }
    }

    public void addSource(String sourceName) {
        RootNode rootNode = this.documentProvider.getRootNode(sourceName);
        this.createClassNodes((Node)rootNode);
    }

    private void createClassNodes(Node rootNode) {
        if (rootNode == null) {
            return;
        }
        Collection<Node> classNodes = NodeProvider.getSubNodes(rootNode, ClassNode.class);
        Collection<Node> moduleNodes = NodeProvider.getSubNodes(rootNode, ModuleNode.class);
        classNodes.addAll(NodeProvider.getSubNodes(rootNode, SClassNode.class));
        for (Node node : classNodes) {
            try {
                PartialClassNodeWrapper partialClassNode = PartialClassNodeWrapper.getPartialClassNodeWrapper(node, rootNode);
                this.addEnclosingModules(partialClassNode, moduleNodes);
                this.addPartialClassNode(partialClassNode, this.classNodeWrappers);
            }
            catch (NoClassNodeException e) {
                e.printStackTrace();
            }
        }
    }

    private void addEnclosingModules(PartialClassNodeWrapper partialClassNode, Collection<Node> moduleNodes) {
        ISourcePosition nodePosition = partialClassNode.getWrappedNode().getPosition();
        ArrayList<ModuleNode> enclosingModules = new ArrayList<ModuleNode>();
        for (Node currentModule : moduleNodes) {
            ISourcePosition modulePosition = currentModule.getPosition();
            if (modulePosition.getStartOffset() >= nodePosition.getStartOffset() || modulePosition.getEndOffset() <= nodePosition.getEndOffset()) continue;
            enclosingModules.add((ModuleNode)currentModule);
        }
        partialClassNode.setEnclosingModules(enclosingModules);
    }

    private void addPartialClassNode(PartialClassNodeWrapper partialClassNode, Map<String, ClassNodeWrapper> classes) {
        String className = partialClassNode.getClassName();
        if (classes.containsKey(className)) {
            ClassNodeWrapper classNode = classes.get(className);
            classNode.addPartialClassNode(partialClassNode);
        } else {
            ClassNodeWrapper classNode = new ClassNodeWrapper(partialClassNode);
            classes.put(className, classNode);
        }
    }

    public void addClassNodeProvider(ClassNodeProvider provider) {
        if (provider != null) {
            for (ClassNodeWrapper classNode : provider.getAllClassNodes()) {
                if (this.hasClassNode(classNode.getName())) continue;
                this.classNodeWrappers.put(classNode.getName(), classNode);
            }
        }
    }

    public Collection<ClassNodeWrapper> getAllClassNodes() {
        return this.classNodeWrappers.values();
    }

    public ClassNodeWrapper getClassNode(String className) {
        return this.classNodeWrappers.containsKey(className) ? this.classNodeWrappers.get(className) : null;
    }

    public boolean hasClassNode(String className) {
        return this.classNodeWrappers.containsKey(className);
    }

    public Collection<ClassNodeWrapper> getSubClassesOf(String className) {
        ArrayList<ClassNodeWrapper> childs = new ArrayList<ClassNodeWrapper>();
        for (ClassNodeWrapper classNode : this.getAllClassNodes()) {
            if (classNode.getSuperClassName() == null || !classNode.getSuperClassName().equals(className)) continue;
            childs.add(classNode);
        }
        return childs;
    }

    public Collection<MethodNodeWrapper> getAllMethodsFor(String className) {
        ArrayList<MethodNodeWrapper> methodNodes = new ArrayList<MethodNodeWrapper>();
        for (ClassNodeWrapper classNode : this.getClassAndAllSuperClassesFor(className)) {
            methodNodes.addAll(classNode.getMethods());
        }
        return methodNodes;
    }

    public Collection<ClassNodeWrapper> getClassAndAllSuperClassesFor(String className) {
        return this.getClassAndAllSuperClasses(this.getClassNode(className));
    }

    public Collection<ClassNodeWrapper> getClassAndAllSuperClasses(ClassNodeWrapper classNode) {
        ArrayList<ClassNodeWrapper> classNodes = new ArrayList<ClassNodeWrapper>();
        do {
            if (classNode == null) continue;
            classNodes.add(classNode);
        } while (classNode != null && (classNode = this.getClassNode(classNode.getSuperClassName())) != null);
        return classNodes;
    }

    public Collection<ClassNodeWrapper> getClassAndAllSubClasses(ClassNodeWrapper classNode) {
        ArrayList<ClassNodeWrapper> classes = new ArrayList<ClassNodeWrapper>();
        if (classNode == null) {
            return classes;
        }
        classes.add(classNode);
        for (ClassNodeWrapper aktClassNode : this.getAllClassNodes()) {
            if (!classNode.getName().equals(aktClassNode.getSuperClassName())) continue;
            classes.addAll(this.getClassAndAllSubClasses(aktClassNode));
        }
        return classes;
    }

    public ClassNodeWrapper getSuperClassOf(String className) {
        for (ClassNodeWrapper classNode : this.getAllClassNodes()) {
            if (classNode.getName() == null || !classNode.getName().equals(className)) continue;
            return classNode;
        }
        return null;
    }
}

