/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.refactoring.nls.changes;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.refactoring.base.RDTChange;
import org.rubypeople.rdt.internal.corext.refactoring.nls.changes.CreateFileChange;
import org.rubypeople.rdt.internal.corext.util.IOCloser;
import org.rubypeople.rdt.refactoring.core.Messages;

public class DeleteFileChange
extends RDTChange {
    private IPath fPath;
    private String fSource;

    public DeleteFileChange(IFile file) {
        Assert.isNotNull((Object)file, (String)"file");
        this.fPath = file.getFullPath().removeFirstSegments(ResourcesPlugin.getWorkspace().getRoot().getFullPath().segmentCount());
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return this.isValid(pm, 3);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(Messages.deleteFile_deleting_resource, 1);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
            Assert.isNotNull((Object)file);
            Assert.isTrue((boolean)file.exists());
            Assert.isTrue((!file.isReadOnly() ? 1 : 0) != 0);
            this.fSource = this.getSource(file);
            CreateFileChange undo = DeleteFileChange.createUndoChange(file, this.fPath, file.getModificationStamp(), this.fSource);
            file.delete(true, true, pm);
            CreateFileChange createFileChange = undo;
            return createFileChange;
        }
        finally {
            pm.done();
        }
    }

    private String getSource(IFile file) throws CoreException {
        String encoding = null;
        try {
            encoding = file.getCharset();
        }
        catch (CoreException coreException) {}
        StringBuffer sb = new StringBuffer();
        BufferedReader br = null;
        InputStream in = null;
        try {
            try {
                in = file.getContents();
                br = encoding != null ? new BufferedReader(new InputStreamReader(in, encoding)) : new BufferedReader(new InputStreamReader(in));
                int read = 0;
                while ((read = br.read()) != -1) {
                    sb.append((char)read);
                }
            }
            catch (IOException e) {
                throw new RubyModelException((Throwable)e, 985);
            }
        }
        catch (Throwable throwable) {
            try {
                IOCloser.rethrows(br, in);
            }
            catch (IOException e) {
                throw new RubyModelException((Throwable)e, 985);
            }
            throw throwable;
        }
        try {
            IOCloser.rethrows(br, in);
        }
        catch (IOException e) {
            throw new RubyModelException((Throwable)e, 985);
        }
        return sb.toString();
    }

    private static CreateFileChange createUndoChange(IFile file, IPath path, long stampToRestore, String source) {
        String encoding;
        try {
            encoding = file.getCharset(false);
        }
        catch (CoreException coreException) {
            encoding = null;
        }
        return new CreateFileChange(path, source, encoding, stampToRestore);
    }

    public String getName() {
        return Messages.deleteFile_Delete_File;
    }

    public Object getModifiedElement() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
    }
}

