/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.parser.warnings;

import com.aptana.rdt.AptanaRDTPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Node;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.IDESourcePosition;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;
import org.rubypeople.rdt.internal.core.util.ASTUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnusedParameterVisitor
extends RubyLintVisitor {
    private Map<String, Node> declared = new HashMap<String, Node>();
    private boolean inArgsNode = false;

    public UnusedParameterVisitor(String contents) {
        super(AptanaRDTPlugin.getDefault().getOptions(), contents);
    }

    protected String getOptionKey() {
        return "com.aptana.rdt.compiler.problem.unusedParameter";
    }

    public Instruction visitDefnNode(DefnNode iVisited) {
        List<Node> args = this.getArgs(iVisited.getArgsNode());
        for (Node arg : args) {
            this.declared.put(ASTUtil.getNameReflectively((Node)arg), arg);
        }
        return null;
    }

    public Instruction visitArgsNode(ArgsNode visited) {
        this.inArgsNode = true;
        return super.visitArgsNode(visited);
    }

    public void exitArgsNode(ArgsNode visited) {
        this.inArgsNode = false;
        super.exitArgsNode(visited);
    }

    public Instruction visitLocalAsgnNode(LocalAsgnNode iVisited) {
        if (this.inArgsNode) {
            this.declared.put(iVisited.getName(), (Node)iVisited);
        }
        return super.visitLocalAsgnNode(iVisited);
    }

    public void exitDefnNode(DefnNode iVisited) {
        for (Node unused : this.declared.values()) {
            String name = ASTUtil.getNameReflectively((Node)unused);
            ISourcePosition original = unused.getPosition();
            IDESourcePosition pos = new IDESourcePosition(original.getFile(), original.getStartLine(), original.getEndLine(), original.getStartOffset(), original.getStartOffset() + name.length());
            this.createProblem((ISourcePosition)pos, "Unused Method parameter " + name);
        }
        this.declared.clear();
    }

    private void usedParameter(String name) {
        this.declared.remove(name);
    }

    private List<Node> getArgs(ArgsNode argsNode) {
        ArrayList<Node> arguments = new ArrayList<Node>();
        if (argsNode == null) {
            return arguments;
        }
        ArgsNode args = argsNode;
        ListNode argList = args.getArgs();
        if (argList == null) {
            return arguments;
        }
        for (Object node : argList.childNodes()) {
            if (!(node instanceof Node)) continue;
            arguments.add((Node)node);
        }
        return arguments;
    }

    public Instruction visitLocalVarNode(LocalVarNode iVisited) {
        this.usedParameter(iVisited.getName());
        return super.visitLocalVarNode(iVisited);
    }

    protected int getProblemID() {
        return 536870974;
    }
}

