/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.parser.warnings;

import com.aptana.rdt.AptanaRDTPlugin;
import java.util.HashSet;
import java.util.Set;
import org.jruby.ast.CaseNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.Node;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;
import org.rubypeople.rdt.internal.core.parser.InOrderVisitor;

public class UnecessaryElseVisitor
extends RubyLintVisitor {
    public UnecessaryElseVisitor(String contents) {
        super(AptanaRDTPlugin.getDefault().getOptions(), contents);
    }

    protected String getOptionKey() {
        return "com.aptana.rdt.compiler.problem.unnecessaryElse";
    }

    public Instruction visitIfNode(IfNode iVisited) {
        boolean isUnlessModifier;
        Node thenBody;
        Node elseBody;
        String src = this.getSource((Node)iVisited);
        if (src.startsWith("unless")) {
            elseBody = iVisited.getThenBody();
            thenBody = iVisited.getElseBody();
        } else {
            elseBody = iVisited.getElseBody();
            thenBody = iVisited.getThenBody();
        }
        boolean bl = isUnlessModifier = iVisited.getThenBody() == null;
        if (elseBody != null && !isUnlessModifier && this.alwaysExplicitReturn(thenBody)) {
            this.createProblem(elseBody.getPosition(), "Unnecessary else");
        }
        return super.visitIfNode(iVisited);
    }

    private boolean alwaysExplicitReturn(Node body) {
        if (body == null) {
            return false;
        }
        ReturnVisitor visitor = new ReturnVisitor();
        body.accept((NodeVisitor)visitor);
        return visitor.alwaysExplicit();
    }

    private class ReturnVisitor
    extends InOrderVisitor {
        private boolean implicit = false;
        private Set<ReturnVisitor> branches = new HashSet<ReturnVisitor>();

        private ReturnVisitor() {
        }

        protected Instruction visitNode(Node iVisited) {
            if (!(iVisited == null || this.structuralNode(iVisited) || this.branchingNode(iVisited) || iVisited instanceof ReturnNode)) {
                this.implicit = true;
            }
            return super.visitNode(iVisited);
        }

        private boolean structuralNode(Node visited) {
            return visited instanceof RootNode || visited instanceof NewlineNode;
        }

        private boolean branchingNode(Node visited) {
            return visited instanceof IfNode || visited instanceof CaseNode;
        }

        public Instruction visitReturnNode(ReturnNode iVisited) {
            this.implicit = false;
            return null;
        }

        public Instruction visitCaseNode(CaseNode iVisited) {
            Node node = iVisited.getFirstWhenNode();
            WhenNode whenNode = (WhenNode)node;
            while (whenNode != null) {
                ReturnVisitor visitor = new ReturnVisitor();
                whenNode.getBodyNode().accept((NodeVisitor)visitor);
                this.branches.add(visitor);
                whenNode = (WhenNode)whenNode.getNextCase();
            }
            return null;
        }

        public Instruction visitIfNode(IfNode iVisited) {
            ReturnVisitor visitor;
            if (iVisited.getThenBody() != null) {
                visitor = new ReturnVisitor();
                iVisited.getThenBody().accept((NodeVisitor)visitor);
                this.branches.add(visitor);
            }
            if (iVisited.getElseBody() != null) {
                visitor = new ReturnVisitor();
                iVisited.getElseBody().accept((NodeVisitor)visitor);
                this.branches.add(visitor);
            } else {
                this.implicit = true;
            }
            return null;
        }

        public boolean alwaysExplicit() {
            for (ReturnVisitor visitor : this.branches) {
                if (visitor.alwaysExplicit()) continue;
                return false;
            }
            return !this.implicit;
        }
    }
}

