/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.parser.warnings;

import com.aptana.rdt.AptanaRDTPlugin;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.RootNode;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TooManyLocalsVisitor
extends RubyLintVisitor {
    public static final int DEFAULT_MAX_LOCALS = 4;
    private int maxLocals = this.getInt("com.aptana.rdt.compiler.problem.maxLocals", 4);
    private Set<String> locals;

    public TooManyLocalsVisitor(String contents) {
        this(AptanaRDTPlugin.getDefault().getOptions(), contents);
    }

    public TooManyLocalsVisitor(Map<String, String> options, String contents) {
        super(options, contents);
    }

    private int getInt(String key, int defaultValue) {
        try {
            return Integer.parseInt((String)this.fOptions.get(key));
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    protected String getOptionKey() {
        return "com.aptana.rdt.compiler.problem.codeComplexityLocals";
    }

    public Instruction visitRootNode(RootNode iVisited) {
        this.locals = new HashSet<String>();
        Instruction ins = super.visitRootNode(iVisited);
        this.locals.clear();
        return ins;
    }

    public Instruction visitDefsNode(DefsNode iVisited) {
        this.locals = new HashSet<String>();
        return super.visitDefsNode(iVisited);
    }

    public Instruction visitDefnNode(DefnNode iVisited) {
        this.locals = new HashSet<String>();
        return super.visitDefnNode(iVisited);
    }

    public Instruction visitLocalAsgnNode(LocalAsgnNode iVisited) {
        this.locals.add(iVisited.getName());
        return super.visitLocalAsgnNode(iVisited);
    }

    public void exitDefnNode(DefnNode iVisited) {
        if (this.locals.size() > this.maxLocals) {
            this.createProblem(iVisited.getNameNode().getPosition(), "Too many local variables: " + this.locals.size());
        }
        this.locals.clear();
    }

    public void exitDefsNode(DefsNode iVisited) {
        if (this.locals.size() > this.maxLocals) {
            this.createProblem(iVisited.getNameNode().getPosition(), "Too many local variables: " + this.locals.size());
        }
        this.locals.clear();
        super.exitDefsNode(iVisited);
    }
}

