/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.parser.warnings;

import com.aptana.rdt.AptanaRDTPlugin;
import java.util.ArrayList;
import java.util.List;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;
import org.rubypeople.rdt.internal.core.util.ASTUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalVariablePossibleAttributeAccess
extends RubyLintVisitor {
    private List<LocalAsgnNode> locals = new ArrayList<LocalAsgnNode>();
    private List<String> attributes = new ArrayList<String>();
    private boolean insideMethodSignature;

    public LocalVariablePossibleAttributeAccess(String contents) {
        super(AptanaRDTPlugin.getDefault().getOptions(), contents);
    }

    protected String getOptionKey() {
        return "com.aptana.rdt.compiler.problem.localVariablePossibleAttributeAccess";
    }

    public Instruction visitClassNode(ClassNode iVisited) {
        this.locals.clear();
        this.attributes.clear();
        return super.visitClassNode(iVisited);
    }

    public Instruction visitLocalAsgnNode(LocalAsgnNode iVisited) {
        if (!this.insideMethodSignature) {
            this.locals.add(iVisited);
        }
        return super.visitLocalAsgnNode(iVisited);
    }

    public Instruction visitArgsNode(ArgsNode iVisited) {
        this.insideMethodSignature = true;
        return super.visitArgsNode(iVisited);
    }

    public void exitArgsNode(ArgsNode iVisited) {
        super.exitArgsNode(iVisited);
        this.insideMethodSignature = false;
    }

    public Instruction visitFCallNode(FCallNode iVisited) {
        String name = iVisited.getName();
        if (name.equals("attr_accessor") || name.equals("attr_writer") || name.equals("attr")) {
            List<String> args = this.filterColonsFromSymbols(ASTUtil.getArgumentsFromFunctionCall((IArgumentNode)iVisited));
            if (name.equals("attr")) {
                if (args.size() < 2) {
                    return super.visitFCallNode(iVisited);
                }
                if (!args.get(1).equals("true")) {
                    return super.visitFCallNode(iVisited);
                }
                this.attributes.add(args.get(0));
                return super.visitFCallNode(iVisited);
            }
            this.attributes.addAll(args);
        }
        return super.visitFCallNode(iVisited);
    }

    private List<String> filterColonsFromSymbols(List<String> args) {
        if (args == null) {
            return null;
        }
        ArrayList<String> newArgs = new ArrayList<String>();
        for (String string : args) {
            if (string.startsWith(":")) {
                string = string.substring(1);
            }
            newArgs.add(string);
        }
        return newArgs;
    }

    public void exitClassNode(ClassNode iVisited) {
        for (LocalAsgnNode local : this.locals) {
            if (!this.attributes.contains(local.getName())) continue;
            this.createProblem(local.getPosition(), "Local variable assignment might be possible attribute access attempt?");
        }
        super.exitClassNode(iVisited);
    }

    protected int getProblemID() {
        return 134;
    }
}

