/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.core.gems;

import com.aptana.rdt.AptanaRDTPlugin;
import com.aptana.rdt.core.gems.Gem;
import com.aptana.rdt.internal.core.gems.GemParseException;
import com.aptana.rdt.internal.core.gems.IGemParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GemParser
implements IGemParser {
    private String lineDelimeter;
    protected boolean strict;

    GemParser() {
        this(System.getProperty("line.separator"), false);
    }

    GemParser(String lineDelimeter) {
        this(lineDelimeter, false);
    }

    GemParser(boolean strict) {
        this(System.getProperty("line.separator"), strict);
    }

    GemParser(String lineDelimeter, boolean strict) {
        this.lineDelimeter = lineDelimeter;
        this.strict = strict;
    }

    @Override
    public Set<Gem> parse(String string) throws GemParseException {
        ArrayList<String> lines;
        if (string == null || string.trim().length() == 0) {
            return new HashSet<Gem>();
        }
        String[] raw = string.split(this.lineDelimeter);
        if (raw.length == 1) {
            raw = string.split("\n");
        }
        if (raw.length == 1) {
            raw = string.split("\r");
        }
        if ((lines = new ArrayList<String>((Collection)Arrays.asList(raw))).size() < 2) {
            return new HashSet<Gem>();
        }
        if (((String)lines.get(0)).startsWith("Updating metadata")) {
            lines.remove(0);
            int i = 0;
            while (i < lines.size()) {
                String line = (String)lines.remove(0);
                if (!line.trim().equals("complete")) {
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            String line = null;
            while (!lines.isEmpty() && ((line = (String)lines.get(0)).trim().length() == 0 || line.trim().equals("*** LOCAL GEMS ***"))) {
                lines.remove(0);
            }
        }
        return this.parseOutGems(lines);
    }

    protected Set<Gem> parseOutGems(List<String> lines) throws GemParseException {
        HashSet<Gem> gems = new HashSet<Gem>();
        if (lines == null || lines.isEmpty()) {
            return gems;
        }
        String line = lines.get(0);
        if (line.startsWith("ERROR:")) {
            return gems;
        }
        int i = 0;
        while (i < lines.size()) {
            String nextLine;
            String nameAndVersion = lines.get(i);
            String description = "";
            if (i + 1 < lines.size()) {
                description = lines.get(i + 1);
            }
            int j = 2;
            while (i + j < lines.size() && (nextLine = lines.get(i + j)).trim().length() != 0) {
                description = String.valueOf(description) + " " + nextLine.trim();
                ++j;
            }
            int openParen = nameAndVersion.indexOf(40);
            if (openParen == -1) {
                if (this.strict) {
                    throw new GemParseException("Parsing using legacy Gem Parser (< 1.2.0). Bad gems output format, no opening parenthesis for version: " + lines);
                }
                AptanaRDTPlugin.log("Parsing using legacy Gem Parser (< 1.2.0). Bad gems output format, no opening parenthesis for version: " + lines);
                return gems;
            }
            int closeParen = nameAndVersion.indexOf(41);
            String name = nameAndVersion.substring(0, openParen);
            String version = nameAndVersion.substring(openParen + 1, closeParen);
            if (version.indexOf(",") != -1) {
                String[] versions = version.split(", ");
                int y = 0;
                while (y < versions.length) {
                    gems.add(new Gem(name.trim(), versions[y], description.trim()));
                    ++y;
                }
            } else {
                gems.add(new Gem(name.trim(), version, description.trim()));
            }
            i += j + 1;
        }
        return gems;
    }
}

