/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.core;

import com.aptana.rdt.IAptanaProxyService;
import java.util.StringTokenizer;

public class SystemPropertyProxyService
implements IAptanaProxyService {
    private static final String SOCKS_PROXY_HOST = "socksProxyHost";
    private static final String SOCKS_PROXY_PORT = "socksProxyPort";
    private static final String HTTP_PROXY_SET = "http.proxySet";
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    private static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    private static final String HTTP_PROXY_USERNAME = "http.proxyUserName";
    private static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";

    public boolean enabled() {
        return this.getHostName() != null && this.getHostName().trim().length() > 0;
    }

    public String getHostName() {
        if (this.useSOCKS()) {
            return System.getProperty(SOCKS_PROXY_HOST);
        }
        return System.getProperty(HTTP_PROXY_HOST);
    }

    public String[] getNonProxyHosts() {
        String nonProxy = System.getProperty(HTTP_NON_PROXY_HOSTS);
        if (nonProxy == null || nonProxy.trim().length() == 0) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(nonProxy, "|");
        String[] nonProxies = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String hostname = tokenizer.nextToken();
            nonProxies[i++] = hostname;
        }
        return nonProxies;
    }

    public String getPassword() {
        return System.getProperty(HTTP_PROXY_PASSWORD);
    }

    public int getPort() {
        String port = "80";
        port = this.useSOCKS() ? System.getProperty(SOCKS_PROXY_PORT) : System.getProperty(HTTP_PROXY_PORT);
        if (port != null && port.trim().length() > 0) {
            return Integer.parseInt(port);
        }
        return 80;
    }

    public String getUsername() {
        return System.getProperty(HTTP_PROXY_USERNAME);
    }

    public boolean isAuthenticating() {
        return this.getUsername() != null && this.getUsername().trim().length() > 0;
    }

    public boolean useSOCKS() {
        String socksHost = System.getProperty(SOCKS_PROXY_HOST);
        return socksHost != null && socksHost.trim().length() > 0;
    }
}

