/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.core.gems;

import com.aptana.rdt.core.gems.Version;

public class GemRequirement {
    private String name;
    private String versionDependency;

    public GemRequirement(String name, String versionDependency) {
        this.name = name;
        this.versionDependency = versionDependency;
    }

    private String getRule() {
        return this.versionDependency.split(" ")[0];
    }

    private Version getVersion() {
        String raw = this.versionDependency.split(" ")[1];
        if (raw.endsWith(",")) {
            raw = raw.substring(0, raw.length() - 1);
        }
        return new Version(raw);
    }

    public String toString() {
        return String.valueOf(this.name) + " (" + this.versionDependency + ")";
    }

    public String getName() {
        return this.name;
    }

    public boolean meetsRequirements(String version) {
        Version gemVersion = new Version(version);
        if (this.getRule().equals("=")) {
            return gemVersion.equals(this.getVersion());
        }
        if (this.getRule().equals(">=")) {
            return gemVersion.isGreaterThanOrEqualTo(this.getVersion());
        }
        if (this.getRule().equals("<=")) {
            return gemVersion.isLessThanOrEqualTo(this.getVersion());
        }
        if (this.getRule().equals(">")) {
            return gemVersion.isGreaterThan(this.getVersion());
        }
        if (this.getRule().equals("<")) {
            return gemVersion.isLessThan(this.getVersion());
        }
        return false;
    }
}

