/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.launching;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.rubypeople.rdt.core.ILoadpathContainer;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyModel;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.util.Util;
import org.rubypeople.rdt.internal.launching.CompositeId;
import org.rubypeople.rdt.internal.launching.DefaultEntryResolver;
import org.rubypeople.rdt.internal.launching.DefaultProjectLoadpathEntry;
import org.rubypeople.rdt.internal.launching.LaunchingMessages;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;
import org.rubypeople.rdt.internal.launching.ListenerList;
import org.rubypeople.rdt.internal.launching.RuntimeLoadpathEntry;
import org.rubypeople.rdt.internal.launching.RuntimeLoadpathEntryResolver;
import org.rubypeople.rdt.internal.launching.RuntimeLoadpathProvider;
import org.rubypeople.rdt.internal.launching.SocketAttachConnector;
import org.rubypeople.rdt.internal.launching.VMDefinitionsContainer;
import org.rubypeople.rdt.internal.launching.VMListener;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.launching.IRuntimeLoadpathEntry;
import org.rubypeople.rdt.launching.IRuntimeLoadpathEntry2;
import org.rubypeople.rdt.launching.IRuntimeLoadpathEntryResolver;
import org.rubypeople.rdt.launching.IRuntimeLoadpathEntryResolver2;
import org.rubypeople.rdt.launching.IRuntimeLoadpathProvider;
import org.rubypeople.rdt.launching.IVMConnector;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.IVMInstallChangedListener;
import org.rubypeople.rdt.launching.IVMInstallType;
import org.rubypeople.rdt.launching.PropertyChangeEvent;
import org.rubypeople.rdt.launching.StandardLoadpathProvider;
import org.rubypeople.rdt.launching.VMStandin;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RubyRuntime {
    private static final String STD_RUBY_VMTYPE = "org.rubypeople.rdt.launching.StandardVMType";
    private static final String JRUBY_VMTYPE = "org.rubypeople.rdt.launching.JRubyVMType";
    public static final String RUBY_CONTAINER = String.valueOf(LaunchingPlugin.getUniqueIdentifier()) + ".RUBY_CONTAINER";
    public static final String PREF_VM_XML = String.valueOf(LaunchingPlugin.getUniqueIdentifier()) + ".PREF_VM_XML";
    public static final String EXTENSION_POINT_VM_INSTALLS = "vmInstalls";
    public static final String RUBYLIB_VARIABLE = "RUBY_LIB";
    public static final String EXTENSION_POINT_RUNTIME_CLASSPATH_ENTRY_RESOLVERS = "runtimeLoadpathEntryResolvers";
    public static final String EXTENSION_POINT_RUNTIME_CLASSPATH_PROVIDERS = "loadpathProviders";
    private static IVMInstallType[] fgVMTypes = null;
    private static RubyRuntime runtime;
    private static Object fgVMLock;
    private static boolean fgInitializingVMs;
    private static String fgDefaultVMId;
    private static ListenerList fgVMListeners;
    private static ThreadLocal<List<IRubyProject>> fgProjects;
    private static ThreadLocal<Integer> fgEntryCount;
    private static IRuntimeLoadpathProvider fgDefaultLoadpathProvider;
    private static Map<String, RuntimeLoadpathProvider> fgPathProviders;
    private static Set<String> fgContributedVMs;
    private static Map<String, RuntimeLoadpathEntryResolver> fgVariableResolvers;
    private static Map<String, RuntimeLoadpathEntryResolver> fgContainerResolvers;
    private static Map<String, RuntimeLoadpathEntryResolver> fgRuntimeLoadpathEntryResolvers;
    private static String fgDefaultVMConnectorId;

    static {
        fgVMLock = new Object();
        fgVMListeners = new ListenerList(5);
        fgProjects = new ThreadLocal();
        fgEntryCount = new ThreadLocal();
        fgDefaultLoadpathProvider = new StandardLoadpathProvider();
        fgPathProviders = null;
        fgContributedVMs = new HashSet<String>();
        fgVariableResolvers = null;
        fgContainerResolvers = null;
        fgRuntimeLoadpathEntryResolvers = null;
    }

    protected RubyRuntime() {
    }

    public static RubyRuntime getDefault() {
        if (runtime == null) {
            runtime = new RubyRuntime();
        }
        return runtime;
    }

    public static void removeVMInstallChangedListener(IVMInstallChangedListener listener) {
        fgVMListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IVMInstall getDefaultVMInstall() {
        IVMInstall install = RubyRuntime.getVMFromCompositeId(RubyRuntime.getDefaultVMId());
        if (install != null && install.getInstallLocation().exists()) {
            return install;
        }
        if (install != null) {
            install.getVMInstallType().disposeVMInstall(install.getId());
        }
        Object object = fgVMLock;
        synchronized (object) {
            fgDefaultVMId = null;
            fgVMTypes = null;
            RubyRuntime.initializeVMs();
        }
        return RubyRuntime.getVMFromCompositeId(RubyRuntime.getDefaultVMId());
    }

    public static IVMInstall getVMFromCompositeId(String idString) {
        IVMInstallType vmType;
        if (idString == null || idString.length() == 0) {
            return null;
        }
        CompositeId id = CompositeId.fromString(idString);
        if (id.getPartCount() == 2 && (vmType = RubyRuntime.getVMInstallType(id.get(0))) != null) {
            return vmType.findVMInstall(id.get(1));
        }
        return null;
    }

    private static String getDefaultVMId() {
        RubyRuntime.initializeVMs();
        return fgDefaultVMId;
    }

    public static void saveVMConfiguration() throws CoreException {
        if (fgVMTypes == null) {
            return;
        }
        try {
            String xml = RubyRuntime.getVMsAsXML();
            RubyRuntime.getPreferences().setValue(PREF_VM_XML, xml);
            RubyRuntime.savePreferences();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), 4, LaunchingMessages.RubyRuntime_exceptionsOccurred, (Throwable)e));
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), 4, LaunchingMessages.RubyRuntime_exceptionsOccurred, (Throwable)e));
        }
        catch (TransformerException e) {
            throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), 4, LaunchingMessages.RubyRuntime_exceptionsOccurred, (Throwable)e));
        }
    }

    private static String getVMsAsXML() throws IOException, ParserConfigurationException, TransformerException {
        VMDefinitionsContainer container = new VMDefinitionsContainer();
        container.setDefaultVMInstallCompositeID(RubyRuntime.getDefaultVMId());
        IVMInstallType[] vmTypes = RubyRuntime.getVMInstallTypes();
        int i = 0;
        while (i < vmTypes.length) {
            IVMInstall[] vms = vmTypes[i].getVMInstalls();
            int j = 0;
            while (j < vms.length) {
                IVMInstall install = vms[j];
                container.addVM(install);
                ++j;
            }
            ++i;
        }
        return container.getAsXML();
    }

    public static void savePreferences() {
        LaunchingPlugin.getDefault().savePluginPreferences();
    }

    public static void addVMInstallChangedListener(IVMInstallChangedListener listener) {
        fgVMListeners.add(listener);
    }

    private static void notifyDefaultVMChanged(IVMInstall previous, IVMInstall current) {
        Object[] listeners = fgVMListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IVMInstallChangedListener listener = (IVMInstallChangedListener)listeners[i];
            listener.defaultVMInstallChanged(previous, current);
            ++i;
        }
    }

    public static IVMInstallType getVMInstallType(String id) {
        IVMInstallType[] vmTypes = RubyRuntime.getVMInstallTypes();
        int i = 0;
        while (i < vmTypes.length) {
            if (vmTypes[i].getId().equals(id)) {
                return vmTypes[i];
            }
            ++i;
        }
        return null;
    }

    public static IVMInstallType[] getVMInstallTypes() {
        RubyRuntime.initializeVMs();
        return fgVMTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeVMs() {
        VMDefinitionsContainer vmDefs = null;
        boolean setPref = false;
        Object object = fgVMLock;
        synchronized (object) {
            if (fgVMTypes == null) {
                try {
                    fgInitializingVMs = true;
                    RubyRuntime.initializeVMTypeExtensions();
                    try {
                        vmDefs = new VMDefinitionsContainer();
                        setPref = RubyRuntime.addPersistedVMs(vmDefs);
                        if (vmDefs.getValidVMList().isEmpty()) {
                            VMListener listener = new VMListener();
                            RubyRuntime.addVMInstallChangedListener(listener);
                            setPref = true;
                            VMStandin[] runtime = RubyRuntime.detectDefaultVMs();
                            RubyRuntime.removeVMInstallChangedListener(listener);
                            if (!listener.isChanged()) {
                                if (runtime != null && runtime.length > 0) {
                                    int i = 0;
                                    while (i < runtime.length) {
                                        vmDefs.addVM(runtime[i]);
                                        ++i;
                                    }
                                    VMStandin defaultVM = RubyRuntime.chooseDefault(runtime);
                                    vmDefs.setDefaultVMInstallCompositeID(RubyRuntime.getCompositeIdFromVM(defaultVM));
                                }
                            } else {
                                RubyRuntime.addPersistedVMs(vmDefs);
                                vmDefs.setDefaultVMInstallCompositeID(fgDefaultVMId);
                            }
                        } else {
                            IVMInstallType type;
                            VMStandin vm;
                            if (RubyRuntime.noJRubyVM(vmDefs) && (vm = RubyRuntime.detectDefaultVM(type = RubyRuntime.getVMInstallType(JRUBY_VMTYPE))) != null) {
                                vmDefs.addVM(vm);
                            }
                            if (RubyRuntime.noStdRubyVM(vmDefs) && (vm = RubyRuntime.detectDefaultVM(type = RubyRuntime.getVMInstallType(STD_RUBY_VMTYPE))) != null) {
                                vmDefs.addVM(vm);
                            }
                        }
                        RubyRuntime.addVMExtensions(vmDefs);
                        String defId = vmDefs.getDefaultVMInstallCompositeID();
                        boolean validDef = false;
                        if (defId != null) {
                            for (IVMInstall vm : vmDefs.getValidVMList()) {
                                if (!RubyRuntime.getCompositeIdFromVM(vm).equals(defId)) continue;
                                validDef = true;
                                break;
                            }
                        }
                        if (!validDef) {
                            setPref = true;
                            List<IVMInstall> list = vmDefs.getValidVMList();
                            if (!list.isEmpty()) {
                                IVMInstall vm;
                                vm = list.get(0);
                                vmDefs.setDefaultVMInstallCompositeID(RubyRuntime.getCompositeIdFromVM(vm));
                            }
                        }
                        fgDefaultVMId = vmDefs.getDefaultVMInstallCompositeID();
                        List<IVMInstall> vmList = vmDefs.getValidVMList();
                        for (VMStandin vMStandin : vmList) {
                            vMStandin.convertToRealVM();
                        }
                    }
                    catch (IOException e) {
                        LaunchingPlugin.log(e);
                    }
                }
                finally {
                    fgInitializingVMs = false;
                }
            }
        }
        if (vmDefs != null) {
            IVMInstallType[] installTypes = RubyRuntime.getVMInstallTypes();
            int i = 0;
            while (i < installTypes.length) {
                IVMInstallType type = installTypes[i];
                IVMInstall[] installs = type.getVMInstalls();
                int j = 0;
                while (j < installs.length) {
                    RubyRuntime.fireVMAdded(installs[j]);
                    ++j;
                }
                ++i;
            }
            if (setPref) {
                try {
                    String xml = vmDefs.getAsXML();
                    LaunchingPlugin.getDefault().getPluginPreferences().setValue(PREF_VM_XML, xml);
                }
                catch (ParserConfigurationException e) {
                    LaunchingPlugin.log(e);
                }
                catch (IOException e) {
                    LaunchingPlugin.log(e);
                }
                catch (TransformerException e) {
                    LaunchingPlugin.log(e);
                }
            }
        }
    }

    private static boolean noJRubyVM(VMDefinitionsContainer vmDefs) {
        return !RubyRuntime.hasVMOfType(vmDefs, JRUBY_VMTYPE);
    }

    private static boolean noStdRubyVM(VMDefinitionsContainer vmDefs) {
        return !RubyRuntime.hasVMOfType(vmDefs, STD_RUBY_VMTYPE);
    }

    private static boolean hasVMOfType(VMDefinitionsContainer vmDefs, String vmTypeId) {
        List<IVMInstall> vms = vmDefs.getValidVMList();
        for (IVMInstall install : vms) {
            if (install.getVMInstallType() == null || install.getVMInstallType().getId() == null || !install.getVMInstallType().getId().equals(vmTypeId)) continue;
            return true;
        }
        return false;
    }

    private static VMStandin chooseDefault(VMStandin[] runtime) {
        int i = 0;
        while (i < runtime.length) {
            if (runtime[i].getVMInstallType().getId().equals(STD_RUBY_VMTYPE)) {
                return runtime[i];
            }
            ++i;
        }
        return runtime[0];
    }

    private static VMStandin[] detectDefaultVMs() {
        ArrayList<VMStandin> detected = new ArrayList<VMStandin>();
        IVMInstallType[] vmTypes = RubyRuntime.getVMInstallTypes();
        int i = 0;
        while (i < vmTypes.length) {
            VMStandin standin = RubyRuntime.detectDefaultVM(vmTypes[i]);
            if (standin != null) {
                detected.add(standin);
            }
            ++i;
        }
        return detected.toArray(new VMStandin[detected.size()]);
    }

    private static VMStandin detectDefaultVM(IVMInstallType vmType) {
        if (vmType == null) {
            return null;
        }
        File detectedLocation = vmType.detectInstallLocation();
        if (detectedLocation != null) {
            long unique = System.currentTimeMillis();
            while (vmType.findVMInstall(String.valueOf(unique)) != null) {
                ++unique;
            }
            String vmID = String.valueOf(unique);
            VMStandin detectedVMStandin = new VMStandin(vmType, vmID);
            detectedVMStandin.setInstallLocation(detectedLocation);
            detectedVMStandin.setName(RubyRuntime.generateDetectedVMName(detectedVMStandin));
            return detectedVMStandin;
        }
        return null;
    }

    private static String generateDetectedVMName(IVMInstall vm) {
        return vm.getInstallLocation().getName();
    }

    private static void initializeVMTypeExtensions() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.rubypeople.rdt.launching", "vmInstallTypes");
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        MultiStatus status = new MultiStatus(LaunchingPlugin.getUniqueIdentifier(), 0, LaunchingMessages.RubyRuntime_exceptionOccurred, null);
        fgVMTypes = new IVMInstallType[configs.length];
        int i = 0;
        while (i < configs.length) {
            try {
                IVMInstallType vmType;
                RubyRuntime.fgVMTypes[i] = vmType = (IVMInstallType)configs[i].createExecutableExtension("class");
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
            ++i;
        }
        if (!status.isOK()) {
            LaunchingPlugin.log((IStatus)status);
            ArrayList<IVMInstallType> temp = new ArrayList<IVMInstallType>(fgVMTypes.length);
            int i2 = 0;
            while (i2 < fgVMTypes.length) {
                if (fgVMTypes[i2] != null) {
                    temp.add(fgVMTypes[i2]);
                }
                fgVMTypes = new IVMInstallType[temp.size()];
                fgVMTypes = temp.toArray(fgVMTypes);
                ++i2;
            }
        }
    }

    private static boolean addPersistedVMs(VMDefinitionsContainer vmDefs) throws IOException {
        String vmXMLString = RubyRuntime.getPreferences().getString(PREF_VM_XML);
        if (vmXMLString.length() > 0) {
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(vmXMLString.getBytes());
                VMDefinitionsContainer.parseXMLIntoContainer(inputStream, vmDefs);
                return false;
            }
            catch (IOException ioe) {
                LaunchingPlugin.log(ioe);
            }
        } else {
            IPath stateLocation = LaunchingPlugin.getDefault().getStateLocation();
            IPath stateFile = stateLocation.append("runtimeConfiguration.xml");
            File file = new File(stateFile.toOSString());
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                VMDefinitionsContainer.parseXMLIntoContainer(fileInputStream, vmDefs);
            }
        }
        return true;
    }

    public static Preferences getPreferences() {
        return LaunchingPlugin.getDefault().getPluginPreferences();
    }

    public static String getCompositeIdFromVM(IVMInstall vm) {
        if (vm == null) {
            return null;
        }
        IVMInstallType vmType = vm.getVMInstallType();
        String typeID = vmType.getId();
        CompositeId id = new CompositeId(new String[]{typeID, vm.getId()});
        return id.toString();
    }

    private static void addVMExtensions(VMDefinitionsContainer vmDefs) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.rubypeople.rdt.launching", EXTENSION_POINT_VM_INSTALLS);
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configs.length) {
            block18: {
                IConfigurationElement element = configs[i];
                try {
                    if ("vmInstall".equals(element.getName())) {
                        IVMInstall install;
                        IVMInstallType installType;
                        String id;
                        String vmType = element.getAttribute("vmInstallType");
                        if (vmType == null) {
                            RubyRuntime.abort(MessageFormat.format("Missing required vmInstallType attribute for vmInstall contributed by {0}", element.getContributor().getName()), null);
                        }
                        if ((id = element.getAttribute("id")) == null) {
                            RubyRuntime.abort(MessageFormat.format("Missing required id attribute for vmInstall contributed by {0}", element.getContributor().getName()), null);
                        }
                        if ((installType = RubyRuntime.getVMInstallType(vmType)) == null) {
                            RubyRuntime.abort(MessageFormat.format("vmInstall {0} contributed by {1} references undefined VM install type {2}", id, element.getContributor().getName(), vmType), null);
                        }
                        if ((install = installType.findVMInstall(id)) == null) {
                            IStatus status;
                            String home;
                            String name = element.getAttribute("name");
                            if (name == null) {
                                RubyRuntime.abort(MessageFormat.format("vmInstall {0} contributed by {1} missing required attribute name", id, element.getContributor().getName()), null);
                            }
                            if ((home = element.getAttribute("home")) == null) {
                                RubyRuntime.abort(MessageFormat.format("vmInstall {0} contributed by {1} missing required attribute home", id, element.getContributor().getName()), null);
                            }
                            String vmArgs = element.getAttribute("vmArgs");
                            VMStandin standin = new VMStandin(installType, id);
                            standin.setName(name);
                            home = RubyRuntime.substitute(home);
                            File homeDir = new File(home);
                            if (homeDir.exists()) {
                                try {
                                    home = homeDir.getCanonicalPath();
                                    homeDir = new File(home);
                                }
                                catch (IOException iOException) {}
                            }
                            if (!(status = installType.validateInstallLocation(homeDir)).isOK()) {
                                RubyRuntime.abort(MessageFormat.format("Illegal install location {0} for vmInstall {1} contributed by {2}: {3}", home, id, element.getContributor().getName(), status.getMessage()), null);
                            }
                            standin.setInstallLocation(homeDir);
                            if (vmArgs != null) {
                                standin.setVMArgs(vmArgs);
                            }
                            IConfigurationElement[] libraries = element.getChildren("library");
                            IPath[] locations = null;
                            if (libraries.length > 0) {
                                locations = new IPath[libraries.length];
                                int j = 0;
                                while (j < libraries.length) {
                                    IPath libPath;
                                    IConfigurationElement library = libraries[j];
                                    String libPathStr = library.getAttribute("path");
                                    if (libPathStr == null) {
                                        RubyRuntime.abort(MessageFormat.format("library for vmInstall {0} contributed by {1} missing required attribute libPath", id, element.getContributor().getName()), null);
                                    }
                                    Path homePath = new Path(home);
                                    locations[j] = libPath = homePath.append(RubyRuntime.substitute(libPathStr));
                                    ++j;
                                }
                            }
                            standin.setLibraryLocations(locations);
                            vmDefs.addVM(standin);
                        }
                        fgContributedVMs.add(id);
                        break block18;
                    }
                    RubyRuntime.abort(MessageFormat.format("Illegal element {0} in vmInstalls extension contributed by {1}", element.getName(), element.getContributor().getName()), null);
                }
                catch (CoreException e) {
                    LaunchingPlugin.log(e);
                }
            }
            ++i;
        }
    }

    private static String substitute(String expression) throws CoreException {
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(expression);
    }

    private static void abort(String message, Throwable exception) throws CoreException {
        RubyRuntime.abort(message, 150, exception);
    }

    private static void abort(String message, int code, Throwable exception) throws CoreException {
        throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), code, message, exception));
    }

    static void fireVMAdded(IVMInstall vm) {
        if (!fgInitializingVMs) {
            Object[] listeners = fgVMListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                IVMInstallChangedListener listener = (IVMInstallChangedListener)listeners[i];
                listener.vmAdded(vm);
                ++i;
            }
        }
    }

    public static void fireVMChanged(PropertyChangeEvent event) {
        Object[] listeners = fgVMListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IVMInstallChangedListener listener = (IVMInstallChangedListener)listeners[i];
            listener.vmChanged(event);
            ++i;
        }
    }

    public static void fireVMRemoved(IVMInstall vm) {
        Object[] listeners = fgVMListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IVMInstallChangedListener listener = (IVMInstallChangedListener)listeners[i];
            listener.vmRemoved(vm);
            ++i;
        }
    }

    public static IPath[] getLibraryLocations(IVMInstall vm) {
        IPath[] locations = vm.getLibraryLocations();
        if (locations != null) {
            return locations;
        }
        IPath[] dflts = vm.getVMInstallType().getDefaultLibraryLocations(vm.getInstallLocation());
        IPath[] libraryPaths = new IPath[dflts.length];
        int i = 0;
        while (i < dflts.length) {
            libraryPaths[i] = dflts[i];
            if (!libraryPaths[i].toFile().isDirectory()) {
                libraryPaths[i] = Path.EMPTY;
            }
            ++i;
        }
        return libraryPaths;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IVMInstall computeVMInstall(ILaunchConfiguration configuration) throws CoreException {
        String rubyVmAttr = configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_RUBY_CONTAINER_PATH, null);
        if (rubyVmAttr == null) {
            String type = configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null);
            if (type == null) {
                IVMInstall vm;
                IRubyProject proj = RubyRuntime.getRubyProject(configuration);
                if (proj == null || (vm = RubyRuntime.getVMInstall(proj)) == null) return RubyRuntime.getDefaultVMInstall();
                return vm;
            }
            String name = configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, null);
            return RubyRuntime.resolveVM(type, name, configuration);
        }
        IPath rubyVmPath = Path.fromPortableString((String)rubyVmAttr);
        ILoadpathEntry entry = RubyCore.newContainerEntry((IPath)rubyVmPath);
        IRuntimeLoadpathEntryResolver2 resolver = RubyRuntime.getVariableResolver(rubyVmPath.segment(0));
        if (resolver != null) {
            return resolver.resolveVMInstall(entry);
        }
        resolver = RubyRuntime.getContainerResolver(rubyVmPath.segment(0));
        if (resolver == null) return RubyRuntime.getDefaultVMInstall();
        return resolver.resolveVMInstall(entry);
    }

    private static IVMInstall resolveVM(String type, String name, ILaunchConfiguration configuration) throws CoreException {
        IVMInstallType vt = RubyRuntime.getVMInstallType(type);
        if (vt == null) {
            RubyRuntime.abort(MessageFormat.format(LaunchingMessages.JavaRuntime_Specified_VM_install_type_does_not_exist___0__2, type), null);
        }
        IVMInstall vm = null;
        if (name == null) {
            Status status = new Status(2, LaunchingPlugin.getUniqueIdentifier(), 103, MessageFormat.format(LaunchingMessages.JavaRuntime_VM_not_fully_specified_in_launch_configuration__0____missing_VM_name__Reverting_to_default_VM__1, configuration.getName()), null);
            LaunchingPlugin.log((IStatus)status);
            return RubyRuntime.getDefaultVMInstall();
        }
        vm = vt.findVMInstallByName(name);
        if (vm != null) {
            return vm;
        }
        RubyRuntime.abort(MessageFormat.format(LaunchingMessages.JavaRuntime_Specified_VM_install_not_found__type__0___name__1__2, vt.getName(), name), null);
        return null;
    }

    private static IRuntimeLoadpathEntryResolver2 getVariableResolver(String variableName) {
        return (IRuntimeLoadpathEntryResolver2)RubyRuntime.getVariableResolvers().get(variableName);
    }

    private static IRuntimeLoadpathEntryResolver2 getContainerResolver(String containerId) {
        return (IRuntimeLoadpathEntryResolver2)RubyRuntime.getContainerResolvers().get(containerId);
    }

    private static Map getVariableResolvers() {
        if (fgVariableResolvers == null) {
            RubyRuntime.initializeResolvers();
        }
        return fgVariableResolvers;
    }

    private static Map getContainerResolvers() {
        if (fgContainerResolvers == null) {
            RubyRuntime.initializeResolvers();
        }
        return fgContainerResolvers;
    }

    private static void initializeResolvers() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.rubypeople.rdt.launching", EXTENSION_POINT_RUNTIME_CLASSPATH_ENTRY_RESOLVERS);
        IConfigurationElement[] extensions = point.getConfigurationElements();
        fgVariableResolvers = new HashMap<String, RuntimeLoadpathEntryResolver>(extensions.length);
        fgContainerResolvers = new HashMap<String, RuntimeLoadpathEntryResolver>(extensions.length);
        fgRuntimeLoadpathEntryResolvers = new HashMap<String, RuntimeLoadpathEntryResolver>(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            RuntimeLoadpathEntryResolver res = new RuntimeLoadpathEntryResolver(extensions[i]);
            String variable = res.getVariableName();
            String container = res.getContainerId();
            String entryId = res.getRuntimeLoadpathEntryId();
            if (variable != null) {
                fgVariableResolvers.put(variable, res);
            }
            if (container != null) {
                fgContainerResolvers.put(container, res);
            }
            if (entryId != null) {
                fgRuntimeLoadpathEntryResolvers.put(entryId, res);
            }
            ++i;
        }
    }

    public static IVMInstall getVMInstall(IRubyProject project) throws CoreException {
        IVMInstall vm = null;
        ILoadpathEntry[] loadpath = project.getRawLoadpath();
        IRuntimeLoadpathEntryResolver2 resolver = null;
        int i = 0;
        while (i < loadpath.length) {
            ILoadpathEntry entry = loadpath[i];
            switch (entry.getEntryKind()) {
                case 4: {
                    resolver = RubyRuntime.getVariableResolver(entry.getPath().segment(0));
                    if (resolver == null) break;
                    vm = resolver.resolveVMInstall(entry);
                    break;
                }
                case 5: {
                    resolver = RubyRuntime.getContainerResolver(entry.getPath().segment(0));
                    if (resolver == null) break;
                    vm = resolver.resolveVMInstall(entry);
                }
            }
            if (vm != null) {
                return vm;
            }
            ++i;
        }
        return null;
    }

    public static IRubyProject getRubyProject(ILaunchConfiguration configuration) throws CoreException {
        String projectName = configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
        if (projectName == null || projectName.trim().length() < 1) {
            return null;
        }
        IRubyProject javaProject = RubyRuntime.getRubyModel().getRubyProject(projectName);
        if (javaProject != null && javaProject.getProject().exists() && !javaProject.getProject().isOpen()) {
            RubyRuntime.abort(MessageFormat.format(LaunchingMessages.JavaRuntime_28, configuration.getName(), projectName), 124, null);
        }
        if (javaProject == null || !javaProject.exists()) {
            RubyRuntime.abort(MessageFormat.format(LaunchingMessages.JavaRuntime_Launch_configuration__0__references_non_existing_project__1___1, configuration.getName(), projectName), 107, null);
        }
        return javaProject;
    }

    private static IRubyModel getRubyModel() {
        return RubyCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
    }

    public static IRuntimeLoadpathEntry newArchiveRuntimeLoadpathEntry(IPath path) {
        ILoadpathEntry cpe = RubyCore.newLibraryEntry((IPath)path);
        return RubyRuntime.newRuntimeLoadpathEntry(cpe);
    }

    private static IRuntimeLoadpathEntry newRuntimeLoadpathEntry(ILoadpathEntry entry) {
        return new RuntimeLoadpathEntry(entry);
    }

    public static IRuntimeLoadpathEntry newRuntimeContainerLoadpathEntry(IPath path, int loadpathProperty, IRubyProject project) throws CoreException {
        ILoadpathEntry cpe = RubyCore.newContainerEntry((IPath)path);
        RuntimeLoadpathEntry entry = new RuntimeLoadpathEntry(cpe, loadpathProperty);
        entry.setRubyProject(project);
        return entry;
    }

    public static IRuntimeLoadpathEntry newVariableRuntimeLoadpathEntry(IPath path) {
        ILoadpathEntry cpe = RubyCore.newVariableEntry((IPath)path);
        return RubyRuntime.newRuntimeLoadpathEntry(cpe);
    }

    public static IRuntimeLoadpathEntry[] computeUnresolvedRuntimeLoadpath(ILaunchConfiguration configuration) throws CoreException {
        return RubyRuntime.getLoadpathProvider(configuration).computeUnresolvedLoadpath(configuration);
    }

    public static IRuntimeLoadpathProvider getLoadpathProvider(ILaunchConfiguration configuration) throws CoreException {
        String providerId = configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_LOADPATH_PROVIDER, null);
        IRuntimeLoadpathProvider provider = null;
        if (providerId == null) {
            provider = fgDefaultLoadpathProvider;
        } else {
            provider = (IRuntimeLoadpathProvider)RubyRuntime.getLoadpathProviders().get(providerId);
            if (provider == null) {
                RubyRuntime.abort(MessageFormat.format(LaunchingMessages.JavaRuntime_26, providerId), null);
            }
        }
        return provider;
    }

    private static Map getLoadpathProviders() {
        if (fgPathProviders == null) {
            RubyRuntime.initializeProviders();
        }
        return fgPathProviders;
    }

    private static void initializeProviders() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.rubypeople.rdt.launching", EXTENSION_POINT_RUNTIME_CLASSPATH_PROVIDERS);
        IConfigurationElement[] extensions = point.getConfigurationElements();
        fgPathProviders = new HashMap<String, RuntimeLoadpathProvider>(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            RuntimeLoadpathProvider res = new RuntimeLoadpathProvider(extensions[i]);
            fgPathProviders.put(res.getIdentifier(), res);
            ++i;
        }
    }

    public static IRuntimeLoadpathEntry newRuntimeLoadpathEntry(String memento) throws CoreException {
        try {
            Element root = null;
            DocumentBuilder parser = LaunchingPlugin.getParser();
            StringReader reader = new StringReader(memento);
            InputSource source = new InputSource(reader);
            root = parser.parse(source).getDocumentElement();
            String id = root.getAttribute("id");
            if (id == null || id.length() == 0) {
                return new RuntimeLoadpathEntry(root);
            }
            IRuntimeLoadpathEntry2 entry = LaunchingPlugin.getDefault().newRuntimeLoadpathEntry(id);
            NodeList list = root.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Element element;
                Node node = list.item(i);
                if (node.getNodeType() == 1 && "memento".equals((element = (Element)node).getNodeName())) {
                    entry.initializeFrom(element);
                }
                ++i;
            }
            return entry;
        }
        catch (SAXException e) {
            RubyRuntime.abort(LaunchingMessages.JavaRuntime_31, e);
        }
        catch (IOException e) {
            RubyRuntime.abort(LaunchingMessages.JavaRuntime_32, e);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IRuntimeLoadpathEntry computeRubyVMEntry(ILaunchConfiguration configuration) throws CoreException {
        String rubyVmAttr = configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_RUBY_CONTAINER_PATH, null);
        IPath containerPath = null;
        if (rubyVmAttr == null) {
            String type = configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null);
            if (type == null) {
                IRubyProject proj = RubyRuntime.getRubyProject(configuration);
                if (proj != null) return RubyRuntime.computeRubyVMEntry(proj);
                containerPath = RubyRuntime.newDefaultRubyVMContainerPath();
            } else {
                String name = configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, null);
                if (name != null) {
                    containerPath = RubyRuntime.newDefaultRubyVMContainerPath().append(type).append(name);
                }
            }
        } else {
            containerPath = Path.fromPortableString((String)rubyVmAttr);
        }
        if (containerPath == null) return null;
        return RubyRuntime.newRuntimeContainerLoadpathEntry(containerPath, 1);
    }

    public static IRuntimeLoadpathEntry computeRubyVMEntry(IRubyProject project) throws CoreException {
        ILoadpathEntry[] rawClasspath = project.getRawLoadpath();
        IRuntimeLoadpathEntryResolver2 resolver = null;
        int i = 0;
        while (i < rawClasspath.length) {
            ILoadpathEntry entry = rawClasspath[i];
            block0 : switch (entry.getEntryKind()) {
                case 4: {
                    resolver = RubyRuntime.getVariableResolver(entry.getPath().segment(0));
                    if (resolver == null || !resolver.isVMInstallReference(entry)) break;
                    return RubyRuntime.newRuntimeLoadpathEntry(entry);
                }
                case 5: {
                    ILoadpathContainer container;
                    resolver = RubyRuntime.getContainerResolver(entry.getPath().segment(0));
                    if (resolver == null || !resolver.isVMInstallReference(entry) || (container = RubyCore.getLoadpathContainer((IPath)entry.getPath(), (IRubyProject)project)) == null) break;
                    switch (container.getKind()) {
                        case 1: {
                            break block0;
                        }
                        case 3: {
                            return RubyRuntime.newRuntimeContainerLoadpathEntry(entry.getPath(), 1);
                        }
                        case 2: {
                            return RubyRuntime.newRuntimeContainerLoadpathEntry(entry.getPath(), 2);
                        }
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public static IPath newDefaultRubyVMContainerPath() {
        return new Path(RUBY_CONTAINER);
    }

    public static IRuntimeLoadpathEntry newRuntimeContainerLoadpathEntry(IPath path, int loadpathProperty) throws CoreException {
        return RubyRuntime.newRuntimeContainerLoadpathEntry(path, loadpathProperty, null);
    }

    public static IRuntimeLoadpathEntry[] computeUnresolvedRuntimeLoadpath(IRubyProject project) throws CoreException {
        ILoadpathEntry[] entries = project.getRawLoadpath();
        ArrayList<IRuntimeLoadpathEntry> loadpathEntries = new ArrayList<IRuntimeLoadpathEntry>(3);
        int i = 0;
        while (i < entries.length) {
            ILoadpathEntry entry = entries[i];
            switch (entry.getEntryKind()) {
                case 5: {
                    ILoadpathContainer container = RubyCore.getLoadpathContainer((IPath)entry.getPath(), (IRubyProject)project);
                    if (container == null) break;
                    switch (container.getKind()) {
                        case 1: {
                            break;
                        }
                        case 3: {
                            loadpathEntries.add(RubyRuntime.newRuntimeContainerLoadpathEntry(container.getPath(), 1, project));
                            break;
                        }
                        case 2: {
                            loadpathEntries.add(RubyRuntime.newRuntimeContainerLoadpathEntry(container.getPath(), 2, project));
                        }
                    }
                    break;
                }
                case 4: {
                    if (!RUBYLIB_VARIABLE.equals(entry.getPath().segment(0))) break;
                    IRuntimeLoadpathEntry jre = RubyRuntime.newVariableRuntimeLoadpathEntry(entry.getPath());
                    jre.setLoadpathProperty(1);
                    loadpathEntries.add(jre);
                    break;
                }
            }
            ++i;
        }
        loadpathEntries.add(RubyRuntime.newDefaultProjectLoadpathEntry(project));
        return loadpathEntries.toArray(new IRuntimeLoadpathEntry[loadpathEntries.size()]);
    }

    public static IRuntimeLoadpathEntry newDefaultProjectLoadpathEntry(IRubyProject project) {
        return new DefaultProjectLoadpathEntry(project);
    }

    public static IRuntimeLoadpathEntry[] resolveRuntimeLoadpathEntry(IRuntimeLoadpathEntry entry, ILaunchConfiguration configuration) throws CoreException {
        switch (entry.getType()) {
            case 1: {
                IResource resource = entry.getResource();
                if (resource instanceof IProject) {
                    IProject p = (IProject)resource;
                    IRubyProject project = RubyCore.create((IProject)p);
                    if (project != null && p.isOpen() && project.exists()) break;
                    return new IRuntimeLoadpathEntry[0];
                }
                RubyRuntime.abort(MessageFormat.format(LaunchingMessages.JavaRuntime_Classpath_references_non_existant_project___0__3, entry.getPath().lastSegment()), null);
                break;
            }
            case 3: {
                IRuntimeLoadpathEntryResolver2 resolver = RubyRuntime.getVariableResolver(entry.getVariableName());
                if (resolver == null) {
                    IRuntimeLoadpathEntry[] resolved = RubyRuntime.resolveVariableEntry(entry, null, configuration);
                    if (resolved == null) break;
                    return resolved;
                }
                return resolver.resolveRuntimeLoadpathEntry(entry, configuration);
            }
            case 4: {
                IRuntimeLoadpathEntryResolver2 resolver = RubyRuntime.getContainerResolver(entry.getVariableName());
                if (resolver == null) {
                    return RubyRuntime.computeDefaultContainerEntries(entry, configuration);
                }
                return resolver.resolveRuntimeLoadpathEntry(entry, configuration);
            }
            case 2: {
                File file;
                String location = entry.getLocation();
                if (location == null) {
                    RubyRuntime.abort(MessageFormat.format(LaunchingMessages.JavaRuntime_Classpath_references_non_existant_archive___0__4, entry.getPath().toString()), null);
                }
                if ((file = new File(location)).exists()) break;
                RubyRuntime.abort(MessageFormat.format(LaunchingMessages.JavaRuntime_Classpath_references_non_existant_archive___0__4, entry.getPath().toString()), null);
                break;
            }
            case 5: {
                IRuntimeLoadpathEntryResolver resolver = RubyRuntime.getContributedResolver(((IRuntimeLoadpathEntry2)entry).getTypeId());
                return resolver.resolveRuntimeLoadpathEntry(entry, configuration);
            }
        }
        return new IRuntimeLoadpathEntry[]{entry};
    }

    private static IRuntimeLoadpathEntry[] computeDefaultContainerEntries(IRuntimeLoadpathEntry entry, ILaunchConfiguration config) throws CoreException {
        IRubyProject project = entry.getRubyProject();
        if (project == null) {
            project = RubyRuntime.getRubyProject(config);
        }
        return RubyRuntime.computeDefaultContainerEntries(entry, project);
    }

    private static IRuntimeLoadpathEntry[] computeDefaultContainerEntries(IRuntimeLoadpathEntry entry, IRubyProject project) throws CoreException {
        if (project == null || entry == null) {
            return new IRuntimeLoadpathEntry[0];
        }
        ILoadpathContainer container = RubyCore.getLoadpathContainer((IPath)entry.getPath(), (IRubyProject)project);
        if (container == null) {
            RubyRuntime.abort(MessageFormat.format(LaunchingMessages.JavaRuntime_Could_not_resolve_classpath_container___0__1, entry.getPath().toString()), null);
            return null;
        }
        ILoadpathEntry[] cpes = container.getLoadpathEntries();
        int property = -1;
        switch (container.getKind()) {
            case 1: {
                property = 3;
                break;
            }
            case 3: {
                property = 1;
                break;
            }
            case 2: {
                property = 2;
            }
        }
        ArrayList<IRuntimeLoadpathEntry> resolved = new ArrayList<IRuntimeLoadpathEntry>(cpes.length);
        List<IRubyProject> projects = fgProjects.get();
        Integer count = fgEntryCount.get();
        if (projects == null) {
            projects = new ArrayList<IRubyProject>();
            fgProjects.set(projects);
            count = 0;
        }
        int intCount = count;
        fgEntryCount.set(++intCount);
        try {
            int i = 0;
            while (i < cpes.length) {
                ILoadpathEntry cpe = cpes[i];
                if (cpe.getEntryKind() == 2) {
                    IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(cpe.getPath().segment(0));
                    IRubyProject rp = RubyCore.create((IProject)p);
                    if (!projects.contains(rp)) {
                        projects.add(rp);
                        IRuntimeLoadpathEntry loadpath = RubyRuntime.newDefaultProjectLoadpathEntry(rp);
                        IRuntimeLoadpathEntry[] entries = RubyRuntime.resolveRuntimeLoadpathEntry(loadpath, rp);
                        int j = 0;
                        while (j < entries.length) {
                            IRuntimeLoadpathEntry e = entries[j];
                            if (!resolved.contains(e)) {
                                resolved.add(entries[j]);
                            }
                            ++j;
                        }
                    }
                } else {
                    IRuntimeLoadpathEntry e = RubyRuntime.newRuntimeLoadpathEntry(cpe);
                    if (!resolved.contains(e)) {
                        resolved.add(e);
                    }
                }
                ++i;
            }
        }
        finally {
            if (--intCount == 0) {
                fgProjects.set(null);
                fgEntryCount.set(null);
            } else {
                fgEntryCount.set(new Integer(intCount));
            }
        }
        IRuntimeLoadpathEntry[] result = new IRuntimeLoadpathEntry[resolved.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (IRuntimeLoadpathEntry)resolved.get(i);
            result[i].setLoadpathProperty(property);
            ++i;
        }
        return result;
    }

    private static IRuntimeLoadpathEntry[] resolveVariableEntry(IRuntimeLoadpathEntry entry, IRubyProject project, ILaunchConfiguration configuration) throws CoreException {
        IPath archPath = RubyCore.getResolvedVariablePath((IPath)entry.getPath());
        if (archPath != null) {
            if (entry.getPath().segmentCount() > 1) {
                archPath = archPath.append(entry.getPath().removeFirstSegments(1));
            }
            if (archPath != null && !archPath.isEmpty()) {
                ILoadpathEntry archEntry = RubyCore.newLibraryEntry((IPath)archPath, (boolean)entry.getLoadpathEntry().isExported());
                IRuntimeLoadpathEntry runtimeArchEntry = RubyRuntime.newRuntimeLoadpathEntry(archEntry);
                runtimeArchEntry.setLoadpathProperty(entry.getLoadpathProperty());
                if (configuration == null) {
                    return RubyRuntime.resolveRuntimeLoadpathEntry(runtimeArchEntry, project);
                }
                return RubyRuntime.resolveRuntimeLoadpathEntry(runtimeArchEntry, configuration);
            }
        }
        return null;
    }

    public static IRuntimeLoadpathEntry[] resolveRuntimeLoadpathEntry(IRuntimeLoadpathEntry entry, IRubyProject project) throws CoreException {
        switch (entry.getType()) {
            case 1: {
                IProject p;
                IRubyProject jp;
                IResource resource = entry.getResource();
                if (!(resource instanceof IProject) || (jp = RubyCore.create((IProject)(p = (IProject)resource))) != null && p.isOpen() && jp.exists()) break;
                return new IRuntimeLoadpathEntry[0];
            }
            case 3: {
                IRuntimeLoadpathEntryResolver2 resolver = RubyRuntime.getVariableResolver(entry.getVariableName());
                if (resolver == null) {
                    IRuntimeLoadpathEntry[] resolved = RubyRuntime.resolveVariableEntry(entry, project, null);
                    if (resolved == null) break;
                    return resolved;
                }
                return resolver.resolveRuntimeLoadpathEntry(entry, project);
            }
            case 4: {
                IRuntimeLoadpathEntryResolver2 resolver = RubyRuntime.getContainerResolver(entry.getVariableName());
                if (resolver == null) {
                    return RubyRuntime.computeDefaultContainerEntries(entry, project);
                }
                return resolver.resolveRuntimeLoadpathEntry(entry, project);
            }
            case 5: {
                IRuntimeLoadpathEntryResolver resolver = RubyRuntime.getContributedResolver(((IRuntimeLoadpathEntry2)entry).getTypeId());
                return resolver.resolveRuntimeLoadpathEntry(entry, project);
            }
        }
        return new IRuntimeLoadpathEntry[]{entry};
    }

    private static IRuntimeLoadpathEntryResolver getContributedResolver(String typeId) {
        IRuntimeLoadpathEntryResolver resolver = (IRuntimeLoadpathEntryResolver)RubyRuntime.getEntryResolvers().get(typeId);
        if (resolver == null) {
            return new DefaultEntryResolver();
        }
        return resolver;
    }

    private static Map getEntryResolvers() {
        if (fgRuntimeLoadpathEntryResolvers == null) {
            RubyRuntime.initializeResolvers();
        }
        return fgRuntimeLoadpathEntryResolvers;
    }

    public static IRuntimeLoadpathEntry[] resolveRuntimeLoadpath(IRuntimeLoadpathEntry[] entries, ILaunchConfiguration configuration) throws CoreException {
        return RubyRuntime.getLoadpathProvider(configuration).resolveLoadpath(entries, configuration);
    }

    public static void setDefaultVMInstall(IVMInstall vm, IProgressMonitor monitor, boolean savePreference) throws CoreException {
        IVMInstall previous = null;
        if (fgDefaultVMId != null) {
            previous = RubyRuntime.getVMFromCompositeId(fgDefaultVMId);
        }
        fgDefaultVMId = RubyRuntime.getCompositeIdFromVM(vm);
        if (savePreference) {
            RubyRuntime.saveVMConfiguration();
        }
        IVMInstall current = null;
        if (fgDefaultVMId != null) {
            current = RubyRuntime.getVMFromCompositeId(fgDefaultVMId);
        }
        if (previous != current) {
            RubyRuntime.notifyDefaultVMChanged(previous, current);
        }
    }

    public static File getRI() {
        return RubyRuntime.getBinExecutable("qri");
    }

    public static File getRDoc() {
        return RubyRuntime.getBinExecutable("rdoc");
    }

    private static File getBinExecutable(String command) {
        File file;
        IVMInstall vm = RubyRuntime.getDefaultVMInstall();
        if (vm == null) {
            return null;
        }
        File installLocation = vm.getInstallLocation();
        String path = installLocation.getAbsolutePath();
        if (!installLocation.getName().equals("bin")) {
            path = String.valueOf(path) + File.separator + "bin";
        }
        path = String.valueOf(path) + File.separator + command;
        if (Platform.getOS().equals("win32")) {
            file = new File(path = String.valueOf(path) + ".bat");
            if (file.exists()) {
                return file;
            }
            path = String.valueOf(path.substring(0, path.length() - 3)) + "cmd";
        }
        if ((file = new File(path)).exists()) {
            return file;
        }
        String version = vm.getRubyVersion();
        if (version == null || version.length() < 3) {
            return file;
        }
        version = version.substring(0, 3);
        path = installLocation.getAbsolutePath();
        if (!installLocation.getName().equals("bin")) {
            path = String.valueOf(path) + File.separator + "bin";
        }
        path = String.valueOf(File.separator) + command + version;
        if (Platform.getOS().equals("win32")) {
            path = String.valueOf(path) + ".bat";
        }
        return new File(path);
    }

    public static File getIRB() {
        return RubyRuntime.getBinExecutable("irb");
    }

    private static ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public static ILaunchConfigurationWorkingCopy createBasicLaunch(String file, String args, IProject project, String workingDirectory) throws CoreException {
        ILaunchConfigurationType configType = RubyRuntime.getLaunchManager().getLaunchConfigurationType(IRubyLaunchConfigurationConstants.ID_RUBY_APPLICATION);
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, RubyRuntime.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(file));
        wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_FILE_NAME, file);
        wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, args);
        wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, workingDirectory);
        wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_REQUIRES_REFRESH, true);
        wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getName());
        return wc;
    }

    public static boolean currentVMIsJRuby() {
        if (RubyRuntime.getDefaultVMInstall() == null) {
            return false;
        }
        if (RubyRuntime.getDefaultVMInstall().getVMInstallType() == null) {
            return false;
        }
        if (RubyRuntime.getDefaultVMInstall().getVMInstallType().getId() == null) {
            return false;
        }
        return RubyRuntime.getDefaultVMInstall().getVMInstallType().getId().equals(JRUBY_VMTYPE);
    }

    public static IPath checkInterpreterBin(String exe) {
        IVMInstall vm = RubyRuntime.getDefaultVMInstall();
        if (vm == null) {
            return null;
        }
        File installLocation = vm.getInstallLocation();
        if (installLocation == null) {
            return null;
        }
        Path path = new Path(installLocation.getAbsolutePath());
        if (!installLocation.getName().equals("bin")) {
            path = path.append("bin");
        }
        if ((path = path.append(exe)).toFile().exists()) {
            return path;
        }
        return null;
    }

    public static boolean currentVMIsCygwin() {
        if (RubyRuntime.getDefaultVMInstall() == null) {
            return false;
        }
        if (RubyRuntime.getDefaultVMInstall().getPlatform() == null) {
            return false;
        }
        return RubyRuntime.getDefaultVMInstall().getPlatform().equals("cygwin");
    }

    public static String launchInBackgroundAndRead(ILaunchConfiguration config, File file) {
        try {
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            wc.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true);
            wc.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", false);
            wc.setAttribute("org.eclipse.debug.ui.ATTR_CAPTURE_IN_FILE", file.getAbsolutePath());
            wc.setAttribute("org.eclipse.debug.ui.private", true);
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_FORCE_NO_CONSOLE, true);
            ILaunchConfiguration config2 = wc.doSave();
            ILaunch launch = config2.launch("run", (IProgressMonitor)new NullProgressMonitor());
            IProcess iproc = launch.getProcesses()[0];
            IStreamMonitor stdOut = iproc.getStreamsProxy().getOutputStreamMonitor();
            StreamListener listener = new StreamListener();
            stdOut.addListener((IStreamListener)listener);
            while (!launch.isTerminated()) {
                Thread.yield();
            }
            return RubyRuntime.readFile(file);
        }
        catch (Exception e) {
            LaunchingPlugin.log(e);
            return null;
        }
    }

    private static String readFile(File file) {
        try {
            return new String(Util.getFileCharContent((File)file, null));
        }
        catch (FileNotFoundException e) {
            LaunchingPlugin.log(e);
        }
        catch (IOException e) {
            LaunchingPlugin.log(e);
        }
        return null;
    }

    public static IVMConnector getVMConnector(String id) {
        return LaunchingPlugin.getDefault().getVMConnector(id);
    }

    public static IVMConnector[] getVMConnectors() {
        return LaunchingPlugin.getDefault().getVMConnectors();
    }

    public static IVMConnector getDefaultVMConnector() {
        String id = RubyRuntime.getDefaultVMConnectorId();
        IVMConnector connector = null;
        if (id != null) {
            connector = RubyRuntime.getVMConnector(id);
        }
        if (connector == null) {
            connector = new SocketAttachConnector();
        }
        return connector;
    }

    private static String getDefaultVMConnectorId() {
        RubyRuntime.initializeVMs();
        return fgDefaultVMConnectorId;
    }

    private static class StreamListener
    implements IStreamListener {
        private StringBuffer buf = new StringBuffer();

        public void streamAppended(String text, IStreamMonitor monitor) {
            this.buf.append(text);
        }

        public String getContents() {
            return this.buf.toString();
        }
    }
}

