/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.launching;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.rubypeople.rdt.internal.launching.LaunchingMessages;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.IVMRunner;
import org.rubypeople.rdt.launching.VMRunnerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVMRunner
implements IVMRunner {
    protected IVMInstall fVMInstance;

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, this.getPluginIdentifier(), code, message, exception));
    }

    protected abstract String getPluginIdentifier();

    @Override
    public void setVMInstall(IVMInstall vm) {
        this.fVMInstance = vm;
    }

    protected Process exec(String[] cmdLine, File workingDirectory) throws CoreException {
        if (cmdLine == null) {
            this.abort("Command line for process exec is null", null, -1);
        }
        ArrayList<String> newCmdLine = new ArrayList<String>();
        String[] stringArray = cmdLine;
        int n = cmdLine.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string == null) {
                LaunchingPlugin.log(new Throwable("Null value in command line: " + cmdLine));
            } else {
                newCmdLine.add(string);
            }
            ++n2;
        }
        cmdLine = newCmdLine.toArray(new String[newCmdLine.size()]);
        LaunchingPlugin.info("Starting: " + this.getCmdLineAsString(cmdLine));
        return DebugPlugin.exec((String[])cmdLine, (File)workingDirectory);
    }

    protected Process exec(String[] cmdLine, File workingDirectory, String[] envp) throws CoreException {
        if (cmdLine == null) {
            this.abort("Command line for process exec is null", null, -1);
        }
        ArrayList<String> newCmdLine = new ArrayList<String>();
        String[] stringArray = cmdLine;
        int n = cmdLine.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string == null) {
                LaunchingPlugin.log(new Throwable("Null value in command line: " + cmdLine));
            } else {
                newCmdLine.add(string);
            }
            ++n2;
        }
        cmdLine = newCmdLine.toArray(new String[newCmdLine.size()]);
        if (envp == null) {
            return this.exec(cmdLine, workingDirectory);
        }
        LaunchingPlugin.info("Starting: " + this.getCmdLineAsString(cmdLine));
        return DebugPlugin.exec((String[])cmdLine, (File)workingDirectory, (String[])envp);
    }

    protected String getCmdLineAsString(String[] cmdLine) {
        if (cmdLine == null) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        int i = 0;
        int numStrings = cmdLine.length;
        while (i < numStrings) {
            String value = cmdLine[i];
            if (value != null) {
                if (value.indexOf(32) != -1 && !value.startsWith("-")) {
                    if (!value.startsWith("\"")) {
                        value = "\"" + value;
                    }
                    if (!value.endsWith("\"")) {
                        value = String.valueOf(value) + "\"";
                    }
                }
                buff.append(value);
                buff.append(' ');
            }
            ++i;
        }
        return buff.toString().trim();
    }

    protected Map<String, String> getDefaultProcessMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(IProcess.ATTR_PROCESS_TYPE, "ruby");
        return map;
    }

    protected IProcess newProcess(ILaunch launch, Process p, String label, Map<String, String> attributes) throws CoreException {
        IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)label, attributes);
        if (process == null) {
            p.destroy();
            this.abort(LaunchingMessages.AbstractVMRunner_0, null, 150);
        }
        return process;
    }

    protected String[] combineVmArgs(VMRunnerConfiguration configuration, IVMInstall vmInstall) {
        String[] launchVMArgs = configuration.getVMArguments();
        String[] vmVMArgs = vmInstall.getVMArguments();
        if (vmVMArgs == null || vmVMArgs.length == 0) {
            return launchVMArgs;
        }
        String[] allVMArgs = new String[launchVMArgs.length + vmVMArgs.length];
        System.arraycopy(launchVMArgs, 0, allVMArgs, 0, launchVMArgs.length);
        System.arraycopy(vmVMArgs, 0, allVMArgs, launchVMArgs.length, vmVMArgs.length);
        return allVMArgs;
    }
}

