/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.launching;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.rubypeople.rdt.internal.launching.LaunchingMessages;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;
import org.rubypeople.rdt.internal.launching.LibraryInfo;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.IVMInstallType;
import org.rubypeople.rdt.launching.RubyRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVMInstallType
implements IVMInstallType,
IExecutableExtension {
    private List<IVMInstall> fVMs = new ArrayList<IVMInstall>(10);
    private String fId;

    protected AbstractVMInstallType() {
    }

    @Override
    public IVMInstall[] getVMInstalls() {
        IVMInstall[] vms = new IVMInstall[this.fVMs.size()];
        return this.fVMs.toArray(vms);
    }

    @Override
    public void disposeVMInstall(String id) {
        int i = 0;
        while (i < this.fVMs.size()) {
            IVMInstall vm = this.fVMs.get(i);
            if (vm.getId().equals(id)) {
                this.fVMs.remove(i);
                RubyRuntime.fireVMRemoved(vm);
                return;
            }
            ++i;
        }
    }

    @Override
    public IVMInstall findVMInstall(String id) {
        int i = 0;
        while (i < this.fVMs.size()) {
            IVMInstall vm = this.fVMs.get(i);
            if (vm.getId().equals(id)) {
                return vm;
            }
            ++i;
        }
        return null;
    }

    @Override
    public IVMInstall createVMInstall(String id) throws IllegalArgumentException {
        if (this.findVMInstall(id) != null) {
            String format = LaunchingMessages.vmInstallType_duplicateVM;
            throw new IllegalArgumentException(MessageFormat.format(format, id));
        }
        IVMInstall vm = this.doCreateVMInstall(id);
        this.fVMs.add(vm);
        return vm;
    }

    protected abstract IVMInstall doCreateVMInstall(String var1);

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.fId = config.getAttribute("id");
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public IVMInstall findVMInstallByName(String name) {
        int i = 0;
        while (i < this.fVMs.size()) {
            IVMInstall vm = this.fVMs.get(i);
            if (vm.getName().equals(name)) {
                return vm;
            }
            ++i;
        }
        return null;
    }

    protected LibraryInfo parseLibraryInfo(IProcess process) {
        IStreamsProxy streamsProxy = process.getStreamsProxy();
        if (streamsProxy == null) {
            return null;
        }
        String text = streamsProxy.getOutputStreamMonitor().getContents();
        BufferedReader reader = new BufferedReader(new StringReader(text));
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            LaunchingPlugin.log(e);
        }
        if (lines.size() > 0) {
            String version = (String)lines.remove(0);
            this.removeNotExistingLibs(lines);
            if (lines.size() > 0) {
                String[] loadpath = lines.toArray(new String[lines.size()]);
                return new LibraryInfo(version, loadpath);
            }
        }
        return null;
    }

    protected LibraryInfo generateLibraryInfo(File rubyHome, File rubyExecutable) {
        LibraryInfo info;
        block13: {
            info = null;
            File file = this.getLibraryInfoGeneratorPath();
            if (file.exists()) {
                String rubyExecutablePath = rubyExecutable.getAbsolutePath();
                String[] cmdLine = new String[]{rubyExecutablePath, file.getAbsolutePath()};
                Process p = null;
                try {
                    try {
                        p = Runtime.getRuntime().exec(cmdLine);
                        IProcess process = DebugPlugin.newProcess((ILaunch)new Launch(null, "run", null), (Process)p, (String)"Library Detection");
                        int i = 0;
                        while (i < 200) {
                            if (process.isTerminated()) break;
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException interruptedException) {}
                            ++i;
                        }
                        info = this.parseLibraryInfo(process);
                    }
                    catch (IOException ioe) {
                        LaunchingPlugin.log(ioe);
                        if (p != null) {
                            p.destroy();
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    if (p != null) {
                        p.destroy();
                    }
                    throw throwable;
                }
                if (p != null) {
                    p.destroy();
                }
            }
        }
        if (info == null) {
            LaunchingPlugin.log(MessageFormat.format("Failed to retrieve default libraries for {0}", rubyHome.getAbsolutePath()));
        }
        return info;
    }

    protected File getLibraryInfoGeneratorPath() {
        return LaunchingPlugin.getFileInPlugin(new Path("ruby").append("standard_vm_type").append("loadpath.rb"));
    }

    private void removeNotExistingLibs(List<String> libraries) {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String path : libraries) {
            File file = new File(path);
            if (file.exists()) continue;
            toRemove.add(path);
        }
        libraries.removeAll(toRemove);
    }

    private List<String> readOutput(IProcess process) {
        IStreamsProxy streamsProxy = process.getStreamsProxy();
        if (streamsProxy == null) {
            return Collections.emptyList();
        }
        String text = streamsProxy.getOutputStreamMonitor().getContents();
        BufferedReader reader = new BufferedReader(new StringReader(text));
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            LaunchingPlugin.log(e);
        }
        return lines;
    }

    protected List<String> executeAndRead(String[] cmdLine) {
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(cmdLine);
            IProcess process = DebugPlugin.newProcess((ILaunch)new Launch(null, "run", null), (Process)p, (String)"Library Detection");
            int i = 0;
            while (i < 200) {
                if (process.isTerminated()) break;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                ++i;
            }
            List<String> list = this.readOutput(process);
            return list;
        }
        catch (IOException ioe) {
            LaunchingPlugin.log(ioe);
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
        return null;
    }

    protected File parseRubyExecutableLocation(List<String> lines) {
        if (lines == null || lines.isEmpty()) {
            return null;
        }
        String location = lines.remove(0);
        File executable = new File(location);
        if (executable.isFile() && executable.exists()) {
            return executable;
        }
        return null;
    }

    protected abstract LibraryInfo getLibraryInfo(File var1, File var2);

    @Override
    public String getVMVersion(File installLocation, File executable) {
        LibraryInfo info = this.getLibraryInfo(installLocation, executable);
        return info.getVersion();
    }
}

