/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.launching;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.rubypeople.rdt.internal.launching.LaunchingMessages;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;
import org.rubypeople.rdt.launching.ExecutionArguments;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.IVMInstallChangedListener;
import org.rubypeople.rdt.launching.IVMInstallType;
import org.rubypeople.rdt.launching.IVMRunner;
import org.rubypeople.rdt.launching.PropertyChangeEvent;
import org.rubypeople.rdt.launching.RubyRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVMInstall
implements IVMInstall {
    private IVMInstallType fType;
    private String fId;
    private String fName;
    private File fInstallLocation;
    protected IPath[] fSystemLibraryDescriptions;
    private String fVMArgs;
    private static final String PREF_VM_INSTALL_SYSTEM_PROPERTY = "PREF_VM_INSTALL_SYSTEM_PROPERTY";
    protected boolean fNotify = true;
    private HashMap<String, IVMRunner> fgVMRunners;

    public AbstractVMInstall(IVMInstallType type, String id) {
        if (type == null) {
            throw new IllegalArgumentException(LaunchingMessages.vmInstall_assert_typeNotNull);
        }
        if (id == null) {
            throw new IllegalArgumentException(LaunchingMessages.vmInstall_assert_idNotNull);
        }
        this.fType = type;
        this.fId = id;
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public void setName(String name) {
        if (!name.equals(this.fName)) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, IVMInstallChangedListener.PROPERTY_NAME, this.fName, name);
            this.fName = name;
            if (this.fNotify) {
                RubyRuntime.fireVMChanged(event);
            }
        }
    }

    @Override
    public File getInstallLocation() {
        return this.fInstallLocation;
    }

    @Override
    public void setInstallLocation(File installLocation) {
        if (!installLocation.equals(this.fInstallLocation)) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, IVMInstallChangedListener.PROPERTY_INSTALL_LOCATION, this.fInstallLocation, installLocation);
            this.fInstallLocation = installLocation;
            if (this.fNotify) {
                RubyRuntime.fireVMChanged(event);
            }
        }
    }

    @Override
    public IVMInstallType getVMInstallType() {
        return this.fType;
    }

    @Override
    public IVMRunner getVMRunner(String mode) {
        return null;
    }

    @Override
    public IPath[] getLibraryLocations() {
        return this.fSystemLibraryDescriptions;
    }

    @Override
    public void setLibraryLocations(IPath[] locations) {
        IPath[] prevLocations;
        if (locations == this.fSystemLibraryDescriptions) {
            return;
        }
        IPath[] newLocations = locations;
        if (newLocations == null) {
            newLocations = this.getVMInstallType().getDefaultLibraryLocations(this.getInstallLocation());
        }
        if ((prevLocations = this.fSystemLibraryDescriptions) == null) {
            prevLocations = this.getVMInstallType().getDefaultLibraryLocations(this.getInstallLocation());
        }
        if (newLocations.length == prevLocations.length) {
            int i = 0;
            boolean equal = true;
            while (i < newLocations.length && equal) {
                equal = newLocations[i].equals((Object)prevLocations[i]);
                ++i;
            }
            if (equal) {
                return;
            }
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, IVMInstallChangedListener.PROPERTY_LIBRARY_LOCATIONS, prevLocations, newLocations);
        this.fSystemLibraryDescriptions = locations;
        if (this.fNotify) {
            RubyRuntime.fireVMChanged(event);
        }
    }

    protected void setNotify(boolean notify) {
        this.fNotify = notify;
    }

    public boolean equals(Object object) {
        if (object instanceof IVMInstall) {
            IVMInstall vm = (IVMInstall)object;
            return this.getVMInstallType().equals(vm.getVMInstallType()) && this.getId().equals(vm.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getVMInstallType().hashCode() + this.getId().hashCode();
    }

    @Override
    public String[] getVMArguments() {
        String args = this.getVMArgs();
        if (args == null) {
            return null;
        }
        ExecutionArguments ex = new ExecutionArguments(args, "");
        return ex.getVMArgumentsArray();
    }

    public void setVMArguments(String[] vmArgs) {
        if (vmArgs == null) {
            this.setVMArgs(null);
        } else {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < vmArgs.length) {
                String string = vmArgs[i];
                buf.append(string);
                buf.append(" ");
                ++i;
            }
            this.setVMArgs(buf.toString().trim());
        }
    }

    @Override
    public String getVMArgs() {
        return this.fVMArgs;
    }

    @Override
    public void setVMArgs(String vmArgs) {
        if (this.fVMArgs == null ? vmArgs == null : this.fVMArgs.equals(vmArgs)) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, IVMInstallChangedListener.PROPERTY_VM_ARGUMENTS, this.fVMArgs, vmArgs);
        this.fVMArgs = vmArgs;
        if (this.fNotify) {
            RubyRuntime.fireVMChanged(event);
        }
    }

    @Override
    public String getRubyVersion() {
        return null;
    }

    private String getSystemPropertyKey(String property) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(PREF_VM_INSTALL_SYSTEM_PROPERTY);
        buffer.append(".");
        buffer.append(this.getVMInstallType().getId());
        buffer.append(".");
        buffer.append(this.getId());
        buffer.append(".");
        buffer.append(property);
        return buffer.toString();
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), code, message, exception));
    }

    protected IVMRunner getVMRunner(IVMInstall vm, String mode) {
        Map<String, IVMRunner> runners = this.getVMRunners();
        IVMRunner runner = runners.get(mode);
        if (runner == null) {
            return null;
        }
        runner.setVMInstall(vm);
        return runner;
    }

    private Map<String, IVMRunner> getVMRunners() {
        if (this.fgVMRunners == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.rubypeople.rdt.launching", "vmRunners");
            IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
            this.fgVMRunners = new HashMap();
            int i = 0;
            while (i < configs.length) {
                try {
                    String vmType = configs[i].getAttribute("vmInstallType");
                    if (vmType.equals(this.fType.getId())) {
                        String mode = configs[i].getAttribute("mode");
                        IVMRunner runner = (IVMRunner)configs[i].createExecutableExtension("class");
                        this.fgVMRunners.put(mode, runner);
                    }
                }
                catch (CoreException e) {
                    LaunchingPlugin.log(e);
                }
                ++i;
            }
        }
        return this.fgVMRunners;
    }
}

