/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.rubypeople.rdt.internal.launching.LaunchingMessages;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.IVMInstallType;
import org.rubypeople.rdt.launching.RubyRuntime;
import org.rubypeople.rdt.launching.VMStandin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMDefinitionsContainer {
    private Map<IVMInstallType, List<IVMInstall>> fVMTypeToVMMap = new HashMap<IVMInstallType, List<IVMInstall>>(10);
    private List<IVMInstall> fVMList;
    private List<IVMInstall> fInvalidVMList = new ArrayList<IVMInstall>(10);
    private String fDefaultVMInstallCompositeID;

    public VMDefinitionsContainer() {
        this.fVMList = new ArrayList<IVMInstall>(10);
    }

    public void addVM(IVMInstall vm) {
        if (!this.fVMList.contains(vm)) {
            IVMInstallType vmInstallType = vm.getVMInstallType();
            List<IVMInstall> vmList = this.fVMTypeToVMMap.get(vmInstallType);
            if (vmList == null) {
                vmList = new ArrayList<IVMInstall>(3);
                this.fVMTypeToVMMap.put(vmInstallType, vmList);
            }
            vmList.add(vm);
            File installLocation = vm.getInstallLocation();
            if (installLocation == null || !vmInstallType.validateInstallLocation(installLocation).isOK()) {
                this.fInvalidVMList.add(vm);
            }
            this.fVMList.add(vm);
        }
    }

    public void addVMList(List vmList) {
        for (IVMInstall vm : vmList) {
            this.addVM(vm);
        }
    }

    public Map getVMTypeToVMMap() {
        return this.fVMTypeToVMMap;
    }

    public List<IVMInstall> getVMList() {
        return this.fVMList;
    }

    public List<IVMInstall> getValidVMList() {
        List<IVMInstall> vms = this.getVMList();
        ArrayList<IVMInstall> resultList = new ArrayList<IVMInstall>(vms.size());
        resultList.addAll(vms);
        resultList.removeAll(this.fInvalidVMList);
        return resultList;
    }

    public String getDefaultVMInstallCompositeID() {
        return this.fDefaultVMInstallCompositeID;
    }

    public void setDefaultVMInstallCompositeID(String id) {
        this.fDefaultVMInstallCompositeID = id;
    }

    public String getAsXML() throws ParserConfigurationException, IOException, TransformerException {
        Document doc = LaunchingPlugin.getDocument();
        Element config = doc.createElement("vmSettings");
        doc.appendChild(config);
        if (this.getDefaultVMInstallCompositeID() != null) {
            config.setAttribute("defaultVM", this.getDefaultVMInstallCompositeID());
        }
        Set vmInstallTypeSet = this.getVMTypeToVMMap().keySet();
        for (IVMInstallType vmInstallType : vmInstallTypeSet) {
            Element vmTypeElement = this.vmTypeAsElement(doc, vmInstallType);
            config.appendChild(vmTypeElement);
        }
        return LaunchingPlugin.serializeDocument(doc);
    }

    private Element vmTypeAsElement(Document doc, IVMInstallType vmType) {
        Element element = doc.createElement("vmType");
        element.setAttribute("id", vmType.getId());
        List vmList = (List)this.getVMTypeToVMMap().get(vmType);
        for (IVMInstall vm : vmList) {
            Element vmElement = this.vmAsElement(doc, vm);
            element.appendChild(vmElement);
        }
        return element;
    }

    private Element vmAsElement(Document doc, IVMInstall vm) {
        String vmArgs;
        Element element = doc.createElement("vm");
        element.setAttribute("id", vm.getId());
        element.setAttribute("name", vm.getName());
        String installPath = "";
        File installLocation = vm.getInstallLocation();
        if (installLocation != null) {
            installPath = installLocation.getAbsolutePath();
        }
        element.setAttribute("path", installPath);
        IPath[] libraryLocations = vm.getLibraryLocations();
        if (libraryLocations != null) {
            Element libLocationElement = VMDefinitionsContainer.libraryLocationsAsElement(doc, libraryLocations);
            element.appendChild(libLocationElement);
        }
        if ((vmArgs = vm.getVMArgs()) != null && vmArgs.length() > 0) {
            element.setAttribute("vmargs", vmArgs);
        }
        return element;
    }

    private static Element libraryLocationsAsElement(Document doc, IPath[] locations) {
        Element root = doc.createElement("libraryLocations");
        int i = 0;
        while (i < locations.length) {
            Element element = doc.createElement("libraryLocation");
            element.setAttribute("src", locations[i].toString());
            root.appendChild(element);
            ++i;
        }
        return root;
    }

    public static VMDefinitionsContainer parseXMLIntoContainer(InputStream inputStream) throws IOException {
        VMDefinitionsContainer container = new VMDefinitionsContainer();
        VMDefinitionsContainer.parseXMLIntoContainer(inputStream, container);
        return container;
    }

    public static void parseXMLIntoContainer(InputStream inputStream, VMDefinitionsContainer container) throws IOException {
        BufferedInputStream stream = new BufferedInputStream(inputStream);
        Element config = null;
        try {
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
                config = parser.parse(new InputSource(stream)).getDocumentElement();
            }
            catch (SAXException sAXException) {
                throw new IOException(LaunchingMessages.RubyRuntime_badFormat);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                ((InputStream)stream).close();
                throw new IOException(LaunchingMessages.RubyRuntime_badFormat);
            }
        }
        finally {
            ((InputStream)stream).close();
        }
        String nodeName = config.getNodeName();
        if (nodeName.equalsIgnoreCase("runtimeconfig")) {
            VMDefinitionsContainer.importLegacyInterpreters(config, container);
            return;
        }
        if (!config.getNodeName().equalsIgnoreCase("vmSettings")) {
            throw new IOException(LaunchingMessages.RubyRuntime_badFormat);
        }
        container.setDefaultVMInstallCompositeID(config.getAttribute("defaultVM"));
        NodeList list = config.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Element vmTypeElement;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && (vmTypeElement = (Element)node).getNodeName().equalsIgnoreCase("vmType")) {
                VMDefinitionsContainer.populateVMTypes(vmTypeElement, container);
            }
            ++i;
        }
    }

    private static void populateVMTypes(Element vmTypeElement, VMDefinitionsContainer container) {
        String id = vmTypeElement.getAttribute("id");
        IVMInstallType vmType = RubyRuntime.getVMInstallType(id);
        if (vmType != null) {
            NodeList vmNodeList = vmTypeElement.getChildNodes();
            int i = 0;
            while (i < vmNodeList.getLength()) {
                Element vmElement;
                Node vmNode = vmNodeList.item(i);
                short type = vmNode.getNodeType();
                if (type == 1 && (vmElement = (Element)vmNode).getNodeName().equalsIgnoreCase("vm")) {
                    VMDefinitionsContainer.populateVMForType(vmType, vmElement, container);
                }
                ++i;
            }
        } else {
            LaunchingPlugin.log(LaunchingMessages.RubyRuntime_VM_type_element_with_unknown_id_1);
        }
    }

    private static void populateVMForType(IVMInstallType vmType, Element vmElement, VMDefinitionsContainer container) {
        String id = vmElement.getAttribute("id");
        if (id != null) {
            String installPath = vmElement.getAttribute("path");
            if (installPath == null) {
                return;
            }
            VMStandin vmStandin = new VMStandin(vmType, id);
            vmStandin.setName(vmElement.getAttribute("name"));
            File installLocation = new File(installPath);
            vmStandin.setInstallLocation(installLocation);
            container.addVM(vmStandin);
            NodeList list = vmElement.getChildNodes();
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                Node node = list.item(i);
                short type = node.getNodeType();
                if (type == 1) {
                    Element subElement = (Element)node;
                    String subElementName = subElement.getNodeName();
                    if (subElementName.equals("libraryLocation")) {
                        IPath loc = VMDefinitionsContainer.getLibraryLocation(subElement);
                        vmStandin.setLibraryLocations(new IPath[]{loc});
                        break;
                    }
                    if (subElementName.equals("libraryLocations")) {
                        VMDefinitionsContainer.setLibraryLocations(vmStandin, subElement);
                        break;
                    }
                }
                ++i;
            }
            String vmArgs = vmElement.getAttribute("vmargs");
            if (vmArgs != null && vmArgs.length() > 0) {
                vmStandin.setVMArgs(vmArgs);
            }
        } else {
            LaunchingPlugin.log(LaunchingMessages.RubyRuntime_VM_element_specified_with_no_id_attribute_2);
        }
    }

    private static IPath getLibraryLocation(Element libLocationElement) {
        String src = libLocationElement.getAttribute("src");
        return new Path(src);
    }

    private static void setLibraryLocations(IVMInstall vm, Element libLocationsElement) {
        NodeList list = libLocationsElement.getChildNodes();
        int length = list.getLength();
        ArrayList<IPath> locations = new ArrayList<IPath>(length);
        int i = 0;
        while (i < length) {
            Element libraryLocationElement;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && (libraryLocationElement = (Element)node).getNodeName().equals("libraryLocation")) {
                locations.add(VMDefinitionsContainer.getLibraryLocation(libraryLocationElement));
            }
            ++i;
        }
        vm.setLibraryLocations(locations.toArray(new IPath[locations.size()]));
    }

    private static void importLegacyInterpreters(Element config, VMDefinitionsContainer container) {
        IVMInstallType vmType = RubyRuntime.getVMInstallType("org.rubypeople.rdt.launching.StandardVMType");
        NodeList list = config.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Element vmElement;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && (vmElement = (Element)node).getNodeName().equalsIgnoreCase("interpreter")) {
                VMDefinitionsContainer.legacyPopulateVMForType(vmType, vmElement, container);
            }
            ++i;
        }
    }

    private static void legacyPopulateVMForType(IVMInstallType vmType, Element vmElement, VMDefinitionsContainer container) {
        String id = vmElement.getAttribute("name");
        if (id != null) {
            String installPath = vmElement.getAttribute("path");
            if (installPath == null) {
                return;
            }
            VMStandin vmStandin = new VMStandin(vmType, id);
            vmStandin.setName(id);
            File installLocation = new File(installPath);
            if (installLocation.isFile() && (installLocation = installLocation.getParentFile()) != null && installLocation.getParentFile() != null) {
                installLocation = installLocation.getParentFile();
            }
            if (installLocation == null) {
                return;
            }
            vmStandin.setInstallLocation(installLocation);
            container.addVM(vmStandin);
        } else {
            LaunchingPlugin.log(LaunchingMessages.RubyRuntime_VM_element_specified_with_no_id_attribute_2);
        }
    }

    public void removeVM(IVMInstall vm) {
        this.fVMList.remove(vm);
        this.fInvalidVMList.remove(vm);
        List<IVMInstall> list = this.fVMTypeToVMMap.get(vm.getVMInstallType());
        if (list != null) {
            list.remove(vm);
        }
    }
}

