/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.rubypeople.rdt.core.util.Util;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;
import org.rubypeople.rdt.internal.launching.RDebugVMDebugger;
import org.rubypeople.rdt.internal.launching.StandardVMDebugger;
import org.rubypeople.rdt.internal.launching.StandardVMRunner;
import org.rubypeople.rdt.launching.AbstractVMInstall;
import org.rubypeople.rdt.launching.IVMInstallType;
import org.rubypeople.rdt.launching.IVMRunner;

public class StandardVM
extends AbstractVMInstall {
    private static final String FINISHED_MARKER = "finished.txt";
    private static final int FIVE_MINUTES = 300000;
    private static final String VERSION_TXT = "version.txt";
    private static final int CORE_STUBS_VERSION = 3;
    private Job coreStubJob;

    public StandardVM(IVMInstallType type, String id) {
        super(type, id);
    }

    public IVMRunner getVMRunner(String mode) {
        if ("run".equals(mode)) {
            StandardVMRunner runner = new StandardVMRunner();
            runner.setVMInstall(this);
            return runner;
        }
        if ("debug".equals(mode)) {
            StandardVMDebugger runner = null;
            runner = this.useRDebug() ? new RDebugVMDebugger() : new StandardVMDebugger();
            runner.setVMInstall(this);
            return runner;
        }
        if ("profile".equals(mode)) {
            return this.getVMRunner(this, mode);
        }
        return null;
    }

    protected boolean useRDebug() {
        return LaunchingPlugin.getDefault().getPluginPreferences().getBoolean("useRubyDebug");
    }

    public String getRubyVersion() {
        File executable;
        IVMInstallType installType = this.getVMInstallType();
        File installLocation = this.getInstallLocation();
        if (installLocation != null && (executable = installType.findExecutable(installLocation)) != null) {
            String vmVersion = installType.getVMVersion(installLocation, executable);
            StringBuffer version = new StringBuffer();
            int i = 0;
            while (i < vmVersion.length()) {
                char ch = vmVersion.charAt(i);
                if (!Character.isDigit(ch) && ch != '.') break;
                version.append(ch);
                ++i;
            }
            if (version.length() > 0) {
                return version.toString();
            }
        }
        return null;
    }

    public String getPlatform() {
        String platform;
        File executable;
        IVMInstallType installType = this.getVMInstallType();
        File installLocation = this.getInstallLocation();
        if (installLocation != null && (executable = installType.findExecutable(installLocation)) != null && (platform = installType.getVMPlatform(installLocation, executable)) != null) {
            return platform;
        }
        return "ruby";
    }

    public IPath[] getLibraryLocations() {
        IPath[] paths = super.getLibraryLocations();
        if (paths != null) {
            return paths;
        }
        return this.getDefaultLibraryLocations();
    }

    private IPath[] getDefaultLibraryLocations() {
        IPath[] dflts = this.getVMInstallType().getDefaultLibraryLocations(this.getInstallLocation());
        IPath coreStubsPath = this.generateCoreStubs(this.getVMInstallType().findExecutable(this.getInstallLocation()));
        if (coreStubsPath == null) {
            return dflts;
        }
        IPath[] paths = new IPath[dflts.length + 1];
        int i = 0;
        while (i < dflts.length) {
            paths[i] = dflts[i];
            ++i;
        }
        paths[dflts.length] = coreStubsPath;
        return paths;
    }

    private IPath generateCoreStubs(final File rubyExecutable) {
        if (rubyExecutable == null) {
            return null;
        }
        final File coreStubber = LaunchingPlugin.getFileInPlugin(new Path("ruby").append("standard_vm").append("core_stubber.rb"));
        if (coreStubber == null || !coreStubber.exists()) {
            LaunchingPlugin.log("Was unable to get path to core stub script (or didn't exist)");
            return null;
        }
        final IPath stubFolder = LaunchingPlugin.getDefault().getStateLocation().append(this.getId()).append("lib");
        if (stubFolder.toFile().exists() && stubFolder.append(FINISHED_MARKER).toFile().exists()) {
            int version = this.getCoreStubsVersion(stubFolder);
            if (version == 3) {
                return stubFolder;
            }
            this.delete(stubFolder.toFile());
            this.writeNewVersion(stubFolder);
        }
        stubFolder.toFile().mkdirs();
        if (this.coreStubJob != null) {
            IStatus result = this.coreStubJob.getResult();
            if (result == null) {
                return stubFolder;
            }
            this.coreStubJob.cancel();
        }
        this.coreStubJob = new Job("Generating core library stubs..."){

            /*
             * Exception decompiling
             */
            protected IStatus run(IProgressMonitor monitor) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 2[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        this.coreStubJob.schedule();
        return stubFolder;
    }

    private void writeNewVersion(IPath stubFolder) {
        block14: {
            stubFolder.toFile().mkdirs();
            File versionFile = stubFolder.append(VERSION_TXT).toFile();
            OutputStreamWriter writer = null;
            try {
                try {
                    versionFile.createNewFile();
                    writer = new FileWriter(versionFile);
                    writer.write(Integer.toString(3));
                }
                catch (IOException e) {
                    LaunchingPlugin.log(e);
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void delete(File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                this.delete(children[i]);
                ++i;
            }
        }
        file.delete();
        file.deleteOnExit();
    }

    private int getCoreStubsVersion(IPath stubFolder) {
        File versionFile;
        block4: {
            versionFile = stubFolder.append(VERSION_TXT).toFile();
            if (versionFile.exists()) break block4;
            return 1;
        }
        try {
            String raw = new String(Util.getFileCharContent((File)versionFile, null));
            return Integer.parseInt(raw);
        }
        catch (NumberFormatException e) {
            LaunchingPlugin.log(e);
        }
        catch (IOException e) {
            LaunchingPlugin.log(e);
        }
        return 3;
    }
}

