/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.launching.IRuntimeLoadpathEntry;
import org.rubypeople.rdt.launching.IRuntimeLoadpathEntryResolver;
import org.rubypeople.rdt.launching.IRuntimeLoadpathEntryResolver2;
import org.rubypeople.rdt.launching.IVMInstall;

public class RuntimeLoadpathEntryResolver
implements IRuntimeLoadpathEntryResolver2 {
    private IConfigurationElement fConfigurationElement;
    private IRuntimeLoadpathEntryResolver fDelegate;

    public RuntimeLoadpathEntryResolver(IConfigurationElement element) {
        this.fConfigurationElement = element;
    }

    public IRuntimeLoadpathEntry[] resolveRuntimeLoadpathEntry(IRuntimeLoadpathEntry entry, ILaunchConfiguration configuration) throws CoreException {
        return this.getResolver().resolveRuntimeLoadpathEntry(entry, configuration);
    }

    protected IRuntimeLoadpathEntryResolver getResolver() throws CoreException {
        if (this.fDelegate == null) {
            this.fDelegate = (IRuntimeLoadpathEntryResolver)this.fConfigurationElement.createExecutableExtension("class");
        }
        return this.fDelegate;
    }

    public String getVariableName() {
        return this.fConfigurationElement.getAttribute("variable");
    }

    public String getContainerId() {
        return this.fConfigurationElement.getAttribute("container");
    }

    public String getRuntimeLoadpathEntryId() {
        return this.fConfigurationElement.getAttribute("runtimeLoadpathEntryId");
    }

    public IVMInstall resolveVMInstall(ILoadpathEntry entry) throws CoreException {
        return this.getResolver().resolveVMInstall(entry);
    }

    public IRuntimeLoadpathEntry[] resolveRuntimeLoadpathEntry(IRuntimeLoadpathEntry entry, IRubyProject project) throws CoreException {
        return this.getResolver().resolveRuntimeLoadpathEntry(entry, project);
    }

    public boolean isVMInstallReference(ILoadpathEntry entry) {
        try {
            IRuntimeLoadpathEntryResolver resolver = this.getResolver();
            if (resolver instanceof IRuntimeLoadpathEntryResolver2) {
                IRuntimeLoadpathEntryResolver2 resolver2 = (IRuntimeLoadpathEntryResolver2)resolver;
                return resolver2.isVMInstallReference(entry);
            }
            return resolver.resolveVMInstall(entry) != null;
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

