/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import java.io.IOException;
import java.text.MessageFormat;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.LoadpathContainerInitializer;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.launching.LaunchingMessages;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;
import org.rubypeople.rdt.launching.IRuntimeLoadpathEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RuntimeLoadpathEntry
implements IRuntimeLoadpathEntry {
    private int fType = -1;
    private int fLoadpathProperty = -1;
    private ILoadpathEntry fLoadpathEntry = null;
    private ILoadpathEntry fResolvedEntry = null;
    private IRubyProject fRubyProject = null;
    private IPath fInvalidPath;

    public RuntimeLoadpathEntry(ILoadpathEntry entry) {
        switch (entry.getEntryKind()) {
            case 2: {
                this.setType(1);
                break;
            }
            case 1: {
                this.setType(2);
                break;
            }
            case 4: {
                this.setType(3);
                break;
            }
            case 3: {
                this.setType(2);
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageFormat.format(LaunchingMessages.RuntimeLoadpathEntry_Illegal_classpath_entry__0__1, entry.toString()));
            }
        }
        this.setLoadpathEntry(entry);
        this.initializeLoadpathProperty();
    }

    public RuntimeLoadpathEntry(ILoadpathEntry entry, int classpathProperty) {
        switch (entry.getEntryKind()) {
            case 5: {
                this.setType(4);
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageFormat.format(LaunchingMessages.RuntimeLoadpathEntry_Illegal_classpath_entry__0__1, entry.toString()));
            }
        }
        this.setLoadpathEntry(entry);
        this.setLoadpathProperty(classpathProperty);
    }

    public RuntimeLoadpathEntry(Element root) throws CoreException {
        String name;
        try {
            this.setType(Integer.parseInt(root.getAttribute("type")));
        }
        catch (NumberFormatException e) {
            this.abort(LaunchingMessages.RuntimeLoadpathEntry_Unable_to_recover_runtime_class_path_entry_type_2, e);
        }
        try {
            this.setLoadpathProperty(Integer.parseInt(root.getAttribute("path")));
        }
        catch (NumberFormatException e) {
            this.abort(LaunchingMessages.RuntimeLoadpathEntry_Unable_to_recover_runtime_class_path_entry_location_3, e);
        }
        Path sourcePath = null;
        Path rootPath = null;
        String path = root.getAttribute("sourceAttachmentPath");
        if (path != null && path.length() > 0) {
            sourcePath = new Path(path);
        }
        if ((path = root.getAttribute("sourceRootPath")) != null && path.length() > 0) {
            rootPath = new Path(path);
        }
        switch (this.getType()) {
            case 1: {
                name = root.getAttribute("projectName");
                if (this.isEmpty(name)) {
                    this.abort(LaunchingMessages.RuntimeLoadpathEntry_Unable_to_recover_runtime_class_path_entry___missing_project_name_4, null);
                    break;
                }
                IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                this.setLoadpathEntry(RubyCore.newProjectEntry((IPath)proj.getFullPath()));
                break;
            }
            case 2: {
                path = root.getAttribute("externalArchive");
                if (this.isEmpty(path)) {
                    path = root.getAttribute("internalArchive");
                    if (this.isEmpty(path)) {
                        this.abort(LaunchingMessages.RuntimeLoadpathEntry_Unable_to_recover_runtime_class_path_entry___missing_archive_path_5, null);
                        break;
                    }
                    this.setLoadpathEntry(this.createLibraryEntry((IPath)sourcePath, (IPath)rootPath, path));
                    break;
                }
                this.setLoadpathEntry(this.createLibraryEntry((IPath)sourcePath, (IPath)rootPath, path));
                break;
            }
            case 3: {
                String var = root.getAttribute("containerPath");
                if (this.isEmpty(var)) {
                    this.abort(LaunchingMessages.RuntimeLoadpathEntry_Unable_to_recover_runtime_class_path_entry___missing_variable_name_6, null);
                    break;
                }
                this.setLoadpathEntry(RubyCore.newVariableEntry((IPath)new Path(var)));
                break;
            }
            case 4: {
                String var = root.getAttribute("containerPath");
                if (this.isEmpty(var)) {
                    this.abort(LaunchingMessages.RuntimeLoadpathEntry_Unable_to_recover_runtime_class_path_entry___missing_variable_name_6, null);
                    break;
                }
                this.setLoadpathEntry(RubyCore.newContainerEntry((IPath)new Path(var)));
            }
        }
        name = root.getAttribute("rubyProject");
        if (this.isEmpty(name)) {
            this.fRubyProject = null;
        } else {
            IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            this.fRubyProject = RubyCore.create((IProject)project2);
        }
    }

    private ILoadpathEntry createLibraryEntry(IPath sourcePath, IPath rootPath, String path) {
        Path p = new Path(path);
        if (!p.isAbsolute()) {
            this.fInvalidPath = p;
            return null;
        }
        return RubyCore.newLibraryEntry((IPath)p);
    }

    protected void abort(String message, Throwable e) throws CoreException {
        Status s = new Status(4, LaunchingPlugin.getUniqueIdentifier(), 150, message, e);
        throw new CoreException((IStatus)s);
    }

    public int getType() {
        return this.fType;
    }

    private void setType(int type) {
        this.fType = type;
    }

    private void setLoadpathEntry(ILoadpathEntry entry) {
        this.fLoadpathEntry = entry;
        this.fResolvedEntry = null;
    }

    public ILoadpathEntry getLoadpathEntry() {
        return this.fLoadpathEntry;
    }

    public String getMemento() throws CoreException {
        Document doc;
        try {
            doc = LaunchingPlugin.getDocument();
        }
        catch (ParserConfigurationException e) {
            Status status = new Status(4, LaunchingPlugin.getUniqueIdentifier(), 150, LaunchingMessages.RuntimeLoadpathEntry_An_exception_occurred_generating_runtime_classpath_memento_8, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        Element node = doc.createElement("runtimeLoadpathEntry");
        doc.appendChild(node);
        node.setAttribute("type", new Integer(this.getType()).toString());
        node.setAttribute("path", new Integer(this.getLoadpathProperty()).toString());
        switch (this.getType()) {
            case 1: {
                node.setAttribute("projectName", this.getPath().lastSegment());
                break;
            }
            case 2: {
                IResource res = this.getResource();
                if (res == null) {
                    node.setAttribute("externalArchive", this.getPath().toString());
                    break;
                }
                node.setAttribute("internalArchive", res.getFullPath().toString());
                break;
            }
            case 3: 
            case 4: {
                node.setAttribute("containerPath", this.getPath().toString());
            }
        }
        if (this.getRubyProject() != null) {
            node.setAttribute("rubyProject", this.getRubyProject().getElementName());
        }
        try {
            return LaunchingPlugin.serializeDocument(doc);
        }
        catch (IOException e) {
            Status status = new Status(4, LaunchingPlugin.getUniqueIdentifier(), 150, LaunchingMessages.RuntimeLoadpathEntry_An_exception_occurred_generating_runtime_classpath_memento_8, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        catch (TransformerException e) {
            Status status = new Status(4, LaunchingPlugin.getUniqueIdentifier(), 150, LaunchingMessages.RuntimeLoadpathEntry_An_exception_occurred_generating_runtime_classpath_memento_8, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    public IPath getPath() {
        ILoadpathEntry entry = this.getLoadpathEntry();
        return entry != null ? entry.getPath() : this.fInvalidPath;
    }

    public IResource getResource() {
        switch (this.getType()) {
            case 3: 
            case 4: {
                return null;
            }
        }
        return this.getResource(this.getPath());
    }

    protected IResource getResource(IPath path) {
        if (path != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (path.getDevice() == null) {
                return root.findMember(path);
            }
            IFile[] files = root.findFilesForLocation(path);
            if (files.length > 0) {
                return files[0];
            }
            IContainer[] containers = root.findContainersForLocation(path);
            if (containers.length > 0) {
                return containers[0];
            }
        }
        return null;
    }

    private void initializeLoadpathProperty() {
        switch (this.getType()) {
            case 3: {
                if (this.getVariableName().equals("RUBY_LIB") || this.getVariableName().equals("GEM_LIB")) {
                    this.setLoadpathProperty(1);
                    break;
                }
                this.setLoadpathProperty(3);
                break;
            }
            case 1: {
                this.setLoadpathProperty(3);
                break;
            }
            case 2: {
                if (this.isGem()) {
                    this.setLoadpathProperty(1);
                    break;
                }
                this.setLoadpathProperty(3);
                break;
            }
        }
    }

    private boolean isGem() {
        String[] segments = this.fLoadpathEntry.getPath().segments();
        if (segments == null) {
            return false;
        }
        int i = 0;
        while (i < segments.length) {
            if (segments[i].equals("gems")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setLoadpathProperty(int location) {
        this.fLoadpathProperty = location;
    }

    public int getLoadpathProperty() {
        return this.fLoadpathProperty;
    }

    public String getLocation() {
        IPath path = null;
        switch (this.getType()) {
            case 1: {
                IRubyProject pro = (IRubyProject)RubyCore.create((IResource)this.getResource());
                if (pro == null) break;
                path = pro.getPath();
                break;
            }
            case 2: {
                path = this.getPath();
                break;
            }
            case 3: {
                ILoadpathEntry resolved = this.getResolvedLoadpathEntry();
                if (resolved == null) break;
                path = resolved.getPath();
                break;
            }
        }
        return this.resolveToOSPath(path);
    }

    protected String resolveToOSPath(IPath path) {
        if (path != null) {
            IResource res = null;
            if (path.getDevice() == null) {
                res = this.getResource(path);
            }
            if (res == null) {
                return path.toOSString();
            }
            IPath location = res.getLocation();
            if (location != null) {
                return location.toOSString();
            }
        }
        return null;
    }

    public String getVariableName() {
        if (this.getType() == 3 || this.getType() == 4) {
            return this.getPath().segment(0);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IRuntimeLoadpathEntry) {
            IRuntimeLoadpathEntry r = (IRuntimeLoadpathEntry)obj;
            if (this.getType() == r.getType() && this.getLoadpathProperty() == r.getLoadpathProperty()) {
                if (this.getType() == 4) {
                    String id = this.getPath().segment(0);
                    LoadpathContainerInitializer initializer = RubyCore.getLoadpathContainerInitializer((String)id);
                    IRubyProject javaProject1 = this.getRubyProject();
                    IRubyProject javaProject2 = r.getRubyProject();
                    if (initializer == null || javaProject1 == null || javaProject2 == null) {
                        return this.getPath().equals((Object)r.getPath());
                    }
                    Object comparisonID1 = initializer.getComparisonID(this.getPath(), javaProject1);
                    Object comparisonID2 = initializer.getComparisonID(r.getPath(), javaProject2);
                    return comparisonID1.equals(comparisonID2);
                }
                return this.getPath() != null && this.getPath().equals((Object)r.getPath());
            }
        }
        return false;
    }

    protected boolean equal(Object one, Object two) {
        if (one == null) {
            return two == null;
        }
        return one.equals(two);
    }

    public int hashCode() {
        if (this.getType() == 4) {
            return this.getPath().segment(0).hashCode() + this.getType();
        }
        return this.getPath().hashCode() + this.getType();
    }

    protected void updateLoadpathEntry(IPath path, IPath sourcePath, IPath rootPath) {
        ILoadpathEntry entry = null;
        ILoadpathEntry original = this.getLoadpathEntry();
        switch (this.getType()) {
            case 2: {
                entry = RubyCore.newLibraryEntry((IPath)path, (boolean)original.isExported());
                break;
            }
            case 3: {
                entry = RubyCore.newVariableEntry((IPath)path);
                break;
            }
            default: {
                return;
            }
        }
        this.setLoadpathEntry(entry);
    }

    protected ILoadpathEntry getResolvedLoadpathEntry() {
        if (this.fResolvedEntry == null) {
            this.fResolvedEntry = RubyCore.getResolvedLoadpathEntry((ILoadpathEntry)this.getLoadpathEntry());
        }
        return this.fResolvedEntry;
    }

    protected boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public String toString() {
        if (this.fLoadpathEntry != null) {
            return this.fLoadpathEntry.toString();
        }
        return super.toString();
    }

    public IRubyProject getRubyProject() {
        return this.fRubyProject;
    }

    public void setRubyProject(IRubyProject project) {
        this.fRubyProject = project;
    }
}

