/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.debug.core.RubyDebuggerProxy;
import org.rubypeople.rdt.internal.debug.core.model.IRubyDebugTarget;
import org.rubypeople.rdt.internal.debug.core.model.RubyDebugTarget;
import org.rubypeople.rdt.internal.launching.StandardVMDebugger;
import org.rubypeople.rdt.launching.RubyRuntime;
import org.rubypeople.rdt.launching.VMRunnerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDebugVMDebugger
extends StandardVMDebugger {
    private static final String PORT_SWITCH = "--port";
    private static final String VERBOSE_FLAG = "-d";
    private static final String RDEBUG_EXECUTABLE = "rdebug-ide";

    @Override
    protected List<String> constructProgramString(VMRunnerConfiguration config) throws CoreException {
        String[] args = config.getProgramArguments();
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("--");
        int i = 0;
        while (i < args.length) {
            argList.add(args[i]);
            ++i;
        }
        config.setProgramArguments(argList.toArray(new String[argList.size()]));
        return super.constructProgramString(config);
    }

    @Override
    protected List<String> debugSpecificVMArgs(RubyDebugTarget debugTarget) {
        return new ArrayList<String>();
    }

    protected List<String> debugArgs(RubyDebugTarget debugTarget) throws CoreException {
        ArrayList<String> arguments = new ArrayList<String>();
        String rdebug = RDebugVMDebugger.findRDebugExecutable(this.fVMInstance.getInstallLocation());
        if (rdebug == null || rdebug.trim().length() == 0) {
            this.abort("Unable to find 'rdebug-ide' bin script to run file under debugger. Is ruby-debug-ide gem installed (not just ruby-debug)?", null, -1);
        }
        if (this.fVMInstance.getPlatform().equals("cygwin")) {
            rdebug = rdebug.replace('\\', '/');
        }
        arguments.add(rdebug);
        arguments.add(PORT_SWITCH);
        arguments.add(Integer.toString(debugTarget.getPort()));
        if (RDebugVMDebugger.isDebuggerVerbose()) {
            arguments.add(VERBOSE_FLAG);
        }
        return arguments;
    }

    @Override
    protected RubyDebuggerProxy getDebugProxy(RubyDebugTarget debugTarget) {
        return new RubyDebuggerProxy((IRubyDebugTarget)debugTarget, true);
    }

    public static String findRDebugExecutable(File vmInstallLocation) {
        IPath path = RubyRuntime.checkInterpreterBin(RDEBUG_EXECUTABLE);
        if (path != null && path.toFile().exists()) {
            return path.toOSString();
        }
        IPath[] gemsPaths = RubyCore.getLoadpathVariable((String)"GEM_LIB");
        if (gemsPaths != null) {
            int i = 0;
            while (i < gemsPaths.length) {
                if (gemsPaths[i] != null && (path = gemsPaths[i].removeLastSegments(1).append("bin").append(RDEBUG_EXECUTABLE)) != null && path.toFile().exists()) {
                    return path.toOSString();
                }
                ++i;
            }
        }
        if ((path = RubyCore.checkSystemPath((String)RDEBUG_EXECUTABLE)) != null && path.toFile().exists()) {
            return path.toOSString();
        }
        path = RubyCore.checkCommonBinLocations((String)RDEBUG_EXECUTABLE);
        if (path != null && path.toFile().exists()) {
            return path.toOSString();
        }
        return null;
    }
}

