/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;

public class LaunchCleaner
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        if (event == null) {
            return;
        }
        IResourceDelta delta = event.getDelta();
        this.checkDelta(delta);
    }

    private void checkDelta(IResourceDelta delta) {
        if (delta == null) {
            return;
        }
        IResource resource = delta.getResource();
        if (!(resource instanceof IWorkspaceRoot) && !(resource instanceof IProject)) {
            return;
        }
        if (resource instanceof IProject) {
            if (2 != delta.getKind()) {
                return;
            }
            IPath path = delta.getFullPath();
            String name = path.lastSegment();
            this.projectRemoved(name);
        }
        IResourceDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            this.checkDelta(children[i]);
            ++i;
        }
    }

    private void projectRemoved(String name) {
        try {
            ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(IRubyLaunchConfigurationConstants.ID_RUBY_APPLICATION);
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
            int i = 0;
            while (i < configs.length) {
                String projectName = configs[i].getAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
                if (projectName != null && projectName.equals(name)) {
                    configs[i].delete();
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

