/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.rubypeople.rdt.core.ILoadpathContainer;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.LoadpathContainerInitializer;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.launching.AbstractRuntimeLoadpathEntry;
import org.rubypeople.rdt.internal.launching.LaunchingMessages;
import org.rubypeople.rdt.internal.launching.RuntimeLoadpathEntry;
import org.rubypeople.rdt.launching.IRuntimeContainerComparator;
import org.rubypeople.rdt.launching.IRuntimeLoadpathEntry;
import org.rubypeople.rdt.launching.RubyRuntime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProjectLoadpathEntry
extends AbstractRuntimeLoadpathEntry {
    public static final String TYPE_ID = "org.eclipse.jdt.launching.classpathentry.defaultLoadpath";
    private boolean fExportedEntriesOnly = false;

    public DefaultProjectLoadpathEntry() {
    }

    public DefaultProjectLoadpathEntry(IRubyProject project) {
        this.setRubyProject(project);
    }

    @Override
    protected void buildMemento(Document document, Element memento) throws CoreException {
        memento.setAttribute("project", this.getRubyProject().getElementName());
        memento.setAttribute("exportedEntriesOnly", Boolean.toString(this.fExportedEntriesOnly));
    }

    @Override
    public void initializeFrom(Element memento) throws CoreException {
        String name = memento.getAttribute("project");
        if (name == null) {
            this.abort(LaunchingMessages.DefaultProjectLoadpathEntry_3, null);
        }
        IRubyProject project = RubyCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(name));
        this.setRubyProject(project);
        name = memento.getAttribute("exportedEntriesOnly");
        this.fExportedEntriesOnly = name == null ? false : Boolean.valueOf(name);
    }

    @Override
    public String getTypeId() {
        return TYPE_ID;
    }

    @Override
    public int getType() {
        return 5;
    }

    protected IProject getProject() {
        return this.getRubyProject().getProject();
    }

    @Override
    public String getLocation() {
        return this.getProject().getLocation().toOSString();
    }

    @Override
    public IPath getPath() {
        return this.getProject().getFullPath();
    }

    @Override
    public IResource getResource() {
        return this.getProject();
    }

    @Override
    public IRuntimeLoadpathEntry[] getRuntimeLoadpathEntries(ILaunchConfiguration configuration) throws CoreException {
        ILoadpathEntry entry = RubyCore.newProjectEntry((IPath)this.getRubyProject().getProject().getFullPath());
        ArrayList classpathEntries = new ArrayList(5);
        ArrayList<ILoadpathEntry> expanding = new ArrayList<ILoadpathEntry>(5);
        this.expandProject(entry, classpathEntries, expanding);
        IRuntimeLoadpathEntry[] runtimeEntries = new IRuntimeLoadpathEntry[classpathEntries.size()];
        int i = 0;
        while (i < runtimeEntries.length) {
            Object e = classpathEntries.get(i);
            if (e instanceof ILoadpathEntry) {
                ILoadpathEntry cpe = (ILoadpathEntry)e;
                runtimeEntries[i] = new RuntimeLoadpathEntry(cpe);
            } else {
                runtimeEntries[i] = (IRuntimeLoadpathEntry)e;
            }
            ++i;
        }
        ArrayList<IRuntimeLoadpathEntry> ordered = new ArrayList<IRuntimeLoadpathEntry>(runtimeEntries.length);
        int i2 = 0;
        while (i2 < runtimeEntries.length) {
            if (runtimeEntries[i2].getLoadpathProperty() == 3) {
                ordered.add(runtimeEntries[i2]);
            }
            ++i2;
        }
        return ordered.toArray(new IRuntimeLoadpathEntry[ordered.size()]);
    }

    private void expandProject(ILoadpathEntry projectEntry, List expandedPath, List<ILoadpathEntry> expanding) throws CoreException {
        expanding.add(projectEntry);
        IPath projectPath = projectEntry.getPath();
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(projectPath.lastSegment());
        if (res == null) {
            expandedPath.add(projectEntry);
            return;
        }
        IRubyProject project = (IRubyProject)RubyCore.create((IResource)res);
        if (project == null || !project.getProject().isOpen() || !project.exists()) {
            expandedPath.add(projectEntry);
            return;
        }
        ILoadpathEntry[] buildPath = project.getRawLoadpath();
        ArrayList<ILoadpathEntry> unexpandedPath = new ArrayList<ILoadpathEntry>(buildPath.length);
        boolean projectAdded = false;
        int i = 0;
        while (i < buildPath.length) {
            ILoadpathEntry classpathEntry = buildPath[i];
            if (classpathEntry.getEntryKind() == 3 && !projectAdded && classpathEntry.getPath().equals((Object)projectEntry.getPath())) {
                projectAdded = true;
                unexpandedPath.add(projectEntry);
            } else if (classpathEntry.isExported()) {
                unexpandedPath.add(classpathEntry);
            } else if (!this.isExportedEntriesOnly() || project.equals(this.getRubyProject())) {
                unexpandedPath.add(classpathEntry);
            }
            ++i;
        }
        block11: for (ILoadpathEntry entry : unexpandedPath) {
            if (entry == projectEntry) {
                expandedPath.add(entry);
                continue;
            }
            switch (entry.getEntryKind()) {
                case 2: {
                    if (expanding.contains(entry)) continue block11;
                    this.expandProject(entry, expandedPath, expanding);
                    break;
                }
                case 5: {
                    ILoadpathContainer container = RubyCore.getLoadpathContainer((IPath)entry.getPath(), (IRubyProject)project);
                    int property = -1;
                    if (container == null) continue block11;
                    switch (container.getKind()) {
                        case 1: {
                            property = 3;
                            break;
                        }
                        case 3: {
                            property = 1;
                            break;
                        }
                        case 2: {
                            property = 2;
                        }
                    }
                    IRuntimeLoadpathEntry r = RubyRuntime.newRuntimeContainerLoadpathEntry(entry.getPath(), property, project);
                    boolean duplicate = false;
                    LoadpathContainerInitializer initializer = RubyCore.getLoadpathContainerInitializer((String)r.getPath().segment(0));
                    int i2 = 0;
                    while (i2 < expandedPath.size()) {
                        IRuntimeLoadpathEntry re;
                        Object o = expandedPath.get(i2);
                        if (o instanceof IRuntimeLoadpathEntry && (re = (IRuntimeLoadpathEntry)o).getType() == 4) {
                            if (container instanceof IRuntimeContainerComparator) {
                                duplicate = ((IRuntimeContainerComparator)container).isDuplicate(re.getPath());
                            } else {
                                LoadpathContainerInitializer initializer2 = RubyCore.getLoadpathContainerInitializer((String)re.getPath().segment(0));
                                Object id1 = null;
                                Object id2 = null;
                                id1 = initializer == null ? r.getPath().segment(0) : initializer.getComparisonID(r.getPath(), project);
                                if (initializer2 == null) {
                                    id2 = re.getPath().segment(0);
                                } else {
                                    IRubyProject context = re.getRubyProject();
                                    if (context == null) {
                                        context = project;
                                    }
                                    id2 = initializer2.getComparisonID(re.getPath(), context);
                                }
                                duplicate = id1 == null ? id2 == null : id1.equals(id2);
                            }
                            if (duplicate) break;
                        }
                        ++i2;
                    }
                    if (duplicate) continue block11;
                    expandedPath.add(r);
                    break;
                }
                case 4: {
                    IRuntimeLoadpathEntry r;
                    if (entry.getPath().segment(0).equals("RUBY_LIB")) {
                        r = RubyRuntime.newVariableRuntimeLoadpathEntry(entry.getPath());
                        r.setLoadpathProperty(1);
                        if (expandedPath.contains(r)) continue block11;
                        expandedPath.add(r);
                        break;
                    }
                }
                default: {
                    if (expandedPath.contains(entry)) continue block11;
                    expandedPath.add(entry);
                }
            }
        }
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public String getName() {
        if (this.isExportedEntriesOnly()) {
            return MessageFormat.format(LaunchingMessages.DefaultProjectLoadpathEntry_2, this.getRubyProject().getElementName());
        }
        return MessageFormat.format(LaunchingMessages.DefaultProjectLoadpathEntry_4, this.getRubyProject().getElementName());
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultProjectLoadpathEntry) {
            DefaultProjectLoadpathEntry entry = (DefaultProjectLoadpathEntry)obj;
            return entry.getRubyProject().equals(this.getRubyProject()) && entry.isExportedEntriesOnly() == this.isExportedEntriesOnly();
        }
        return false;
    }

    public int hashCode() {
        return this.getRubyProject().hashCode();
    }

    public void setExportedEntriesOnly(boolean exportedOnly) {
        this.fExportedEntriesOnly = exportedOnly;
    }

    public boolean isExportedEntriesOnly() {
        return this.fExportedEntriesOnly;
    }
}

