/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.rubypeople.rdt.core.IRubyInformation;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.util.Util;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;

class CoreStubDocInsertingJob
extends Job {
    public CoreStubDocInsertingJob() {
        super("Add docs to core stubs");
    }

    protected IStatus run(IProgressMonitor monitor) {
        File file = this.getCoreStubsDir();
        if (file == null) {
            return Status.CANCEL_STATUS;
        }
        File[] scripts = file.listFiles();
        int x = 0;
        while (x < scripts.length) {
            this.insertDocs(scripts[x]);
            ++x;
        }
        return Status.OK_STATUS;
    }

    private void insertDocs(File file) {
        try {
            char[] contents = Util.getFileCharContent((File)file, null);
            String raw = new String(contents);
            StringBuffer modified = new StringBuffer(raw);
            Pattern p = Pattern.compile("class (\\w+)");
            Matcher m = p.matcher(raw);
            while (m.find()) {
                int offset;
                String before;
                String className = m.group(1);
                if (Character.isLowerCase(className.charAt(0))) continue;
                String originalName = file.getName().substring(0, file.getName().length() - 3);
                if (!className.toLowerCase().equals(originalName) || (before = raw.substring(0, offset = m.start()).trim()).endsWith("=end")) continue;
                String docs = this.getRI(className);
                modified.insert(offset, "=begin\n" + docs + "=end\n");
            }
            if (modified.length() != raw.length()) {
                this.write(file, modified);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void write(File file, StringBuffer modified) {
        block14: {
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(file);
                    writer.write(modified.toString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private String getRI(String type) {
        String riResult = this.getRubyInformation().getDocs(type);
        if (riResult.trim().equals("nil")) {
            return null;
        }
        return riResult;
    }

    private IRubyInformation getRubyInformation() {
        return LaunchingPlugin.getRubyInformation();
    }

    private File getCoreStubsDir() {
        IPath[] paths = RubyCore.getLoadpathVariable((String)"RUBY_LIB");
        int i = 0;
        while (i < paths.length) {
            IPath path = paths[i];
            if (path.toPortableString().contains(".metadata")) {
                return path.toFile();
            }
            ++i;
        }
        return null;
    }
}

