/*
 * Decompiled with CFR 0.152.
 */
package net.lucky_dip.sasseditor.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.lucky_dip.hamleditor.editor.ColorManager;
import net.lucky_dip.hamleditor.editor.HamlReconcilingStrategy;
import net.lucky_dip.hamleditor.editor.scanners.DefaultScanner;
import net.lucky_dip.sasseditor.editor.SassEditor;
import net.lucky_dip.sasseditor.editor.SassIndentLineAutoEditStrategy;
import net.lucky_dip.sasseditor.editor.contentassist.SassContentAssistantProcessor;
import net.lucky_dip.sasseditor.editor.scanners.SassAttributeScanner;
import net.lucky_dip.sasseditor.editor.scanners.SassClassScanner;
import net.lucky_dip.sasseditor.editor.scanners.SassConstantScanner;
import net.lucky_dip.sasseditor.editor.scanners.SassIDScanner;
import net.lucky_dip.sasseditor.editor.scanners.SassPartitionScanner;
import net.lucky_dip.sasseditor.editor.scanners.SassTagScanner;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class SassConfiguration
extends SourceViewerConfiguration {
    private SassIndentLineAutoEditStrategy autoIndent;
    private ColorManager colorManager;
    private SassEditor editor;
    private SassClassScanner classScanner;
    private SassIDScanner idScanner;
    private SassAttributeScanner attributeScanner;
    private SassConstantScanner constantScanner;
    private SassTagScanner tagScanner;

    public SassConfiguration(ColorManager colorManager, SassEditor editor) {
        this.colorManager = colorManager;
        this.editor = editor;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        ArrayList<String> types = new ArrayList<String>();
        types.add("__dftl_partition_content_type");
        types.addAll((Collection)Arrays.asList(SassPartitionScanner.SASS_PARTITION_TYPES));
        return types.toArray(new String[0]);
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "__sass_partitioning";
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        HamlReconcilingStrategy strategy = new HamlReconcilingStrategy(this.editor);
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
        return reconciler;
    }

    private ITokenScanner getClassScanner() {
        if (this.classScanner == null) {
            this.classScanner = new SassClassScanner(this.colorManager);
        }
        return this.classScanner;
    }

    private ITokenScanner getIDScanner() {
        if (this.idScanner == null) {
            this.idScanner = new SassIDScanner(this.colorManager);
        }
        return this.idScanner;
    }

    private ITokenScanner getAttributeScanner() {
        if (this.attributeScanner == null) {
            this.attributeScanner = new SassAttributeScanner(this.colorManager);
        }
        return this.attributeScanner;
    }

    private ITokenScanner getConstantScanner() {
        if (this.constantScanner == null) {
            this.constantScanner = new SassConstantScanner(this.colorManager);
        }
        return this.constantScanner;
    }

    private ITokenScanner getTagScanner() {
        if (this.tagScanner == null) {
            this.tagScanner = new SassTagScanner(this.colorManager);
        }
        return this.tagScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)new DefaultScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer(this.getIDScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__sass_id");
        reconciler.setRepairer((IPresentationRepairer)dr, "__sass_id");
        dr = new DefaultDamagerRepairer(this.getAttributeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__sass_attribute");
        reconciler.setRepairer((IPresentationRepairer)dr, "__sass_attribute");
        dr = new DefaultDamagerRepairer(this.getConstantScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__sass_constant");
        reconciler.setRepairer((IPresentationRepairer)dr, "__sass_constant");
        dr = new DefaultDamagerRepairer(this.getClassScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__sass_class");
        reconciler.setRepairer((IPresentationRepairer)dr, "__sass_class");
        dr = new DefaultDamagerRepairer(this.getTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__sass_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__sass_tag");
        return reconciler;
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return "  ".length();
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"  "};
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (this.autoIndent == null) {
            this.autoIndent = new SassIndentLineAutoEditStrategy();
        }
        return new IAutoEditStrategy[]{this.autoIndent};
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant ca = new ContentAssistant();
        ca.setDocumentPartitioning("__sass_partitioning");
        SassContentAssistantProcessor pr = new SassContentAssistantProcessor();
        ca.setContentAssistProcessor((IContentAssistProcessor)pr, "__sass_attribute");
        ca.setContentAssistProcessor((IContentAssistProcessor)pr, "__sass_constant");
        ca.setContentAssistProcessor((IContentAssistProcessor)pr, "__dftl_partition_content_type");
        ca.enableAutoActivation(true);
        ca.setAutoActivationDelay(500);
        ca.setProposalPopupOrientation(21);
        ca.setContextInformationPopupOrientation(21);
        ca.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return ca;
    }
}

