/*
 * Decompiled with CFR 0.152.
 */
package net.lucky_dip.hamleditor.editor;

import net.lucky_dip.hamleditor.HamlesqueBlock;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;

public class HamlCharacterPairMatcher
implements ICharacterPairMatcher {
    private int anchor = 0;

    public void clear() {
    }

    public void dispose() {
    }

    public int getAnchor() {
        return this.anchor;
    }

    public IRegion match(IDocument doc, int cursorPosition) {
        this.anchor = cursorPosition;
        Region res = null;
        try {
            String text = doc.get();
            String[] lines = text.split("\n");
            int lineNumber = doc.getLineOfOffset(cursorPosition);
            int lineOffset = doc.getLineOffset(lineNumber);
            String line = doc.get(lineOffset, doc.getLineLength(lineNumber));
            int lineSpaces = HamlesqueBlock.countIndentSpaces(line);
            int spaces = Math.min(cursorPosition - lineOffset, lineSpaces);
            int i = lineNumber - 1;
            while (i >= 0) {
                int currentSpaces;
                if (lines[i].trim().length() > 0 && (currentSpaces = HamlesqueBlock.countIndentSpaces(lines[i])) == spaces - 2) {
                    res = new Region(doc.getLineOffset(i) + currentSpaces, 1);
                    break;
                }
                --i;
            }
        }
        catch (BadLocationException badLocationException) {}
        return res;
    }
}

