/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.ui.gems;

import com.aptana.rdt.AptanaRDTPlugin;
import com.aptana.rdt.core.gems.Gem;
import com.aptana.rdt.core.gems.LogicalGem;
import com.aptana.rdt.ui.gems.GemLabelProvider;
import com.aptana.rdt.ui.gems.GemsMessages;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.UIJob;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.util.CollectionContentProvider;
import org.rubypeople.rdt.ui.TableViewerSorter;

public class InstallGemDialog
extends Dialog {
    private static final Gem LOADING_GEM = new Gem("Please wait", "N/A", "Loading remote gem listing...");
    private Text nameText;
    private Combo versionCombo;
    private String name;
    private String version;
    private boolean filterByText = true;
    private TableViewer gemViewer;
    private IStructuredContentProvider contentProvider;
    private Combo sourceURLCombo;
    private String sourceURL = "http://gems.rubyforge.org";
    private Set<Gem> gems;
    private Job gemJob;
    private Button sourceButton;
    private Image refreshImage;

    public InstallGemDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.contentProvider = new CollectionContentProvider();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(GemsMessages.InstallGemDialog_dialog_title);
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        control.setLayout((Layout)layout);
        Label sourceLabel = new Label(control, 16384);
        sourceLabel.setText("Source URL");
        this.sourceURLCombo = new Combo(control, 4);
        GridData sourceTextData = new GridData();
        sourceTextData.widthHint = 300;
        this.sourceURLCombo.setLayoutData((Object)sourceTextData);
        this.updateSourceURLs();
        this.sourceURLCombo.setText(this.sourceURL);
        this.sourceURLCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InstallGemDialog.this.sourceURL = InstallGemDialog.this.sourceURLCombo.getText();
            }
        });
        this.sourceButton = new Button(control, 0);
        this.sourceButton.setToolTipText("Refresh");
        this.refreshImage = RubyPluginImages.TOOLBAR_REFRESH.createImage();
        this.sourceButton.setImage(this.refreshImage);
        this.sourceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String curr = InstallGemDialog.this.sourceURLCombo.getText();
                InstallGemDialog.this.gems = new HashSet();
                InstallGemDialog.this.gems.add(LOADING_GEM);
                InstallGemDialog.this.updateTable();
                InstallGemDialog.this.nameText.setEnabled(false);
                InstallGemDialog.this.versionCombo.setEnabled(false);
                InstallGemDialog.this.setGems(InstallGemDialog.this.sourceURL);
                InstallGemDialog.this.updateSourceURLs();
                InstallGemDialog.this.sourceURLCombo.setText(curr);
            }
        });
        Label nameLabel = new Label(control, 16384);
        nameLabel.setText(GemsMessages.InstallGemDialog_name_label);
        this.nameText = new Text(control, 2176);
        GridData nameTextData = new GridData();
        nameTextData.widthHint = 150;
        nameTextData.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)nameTextData);
        this.nameText.setEnabled(false);
        this.nameText.setMessage("Type portion of gem name to filter listing");
        Label versionLabel = new Label(control, 16384);
        versionLabel.setText(GemsMessages.InstallGemDialog_version_label);
        this.versionCombo = new Combo(control, 2060);
        GridData versionComboData = new GridData();
        versionComboData.widthHint = 150;
        versionComboData.horizontalSpan = 2;
        this.versionCombo.setLayoutData((Object)versionComboData);
        this.versionCombo.setEnabled(false);
        this.gems = new HashSet<Gem>();
        this.gems.add(LOADING_GEM);
        final Table gemsTable = new Table(parent, 0x10010004);
        gemsTable.setItemCount(this.gems.size());
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (InstallGemDialog.this.filterByText) {
                    InstallGemDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Set<Gem> filtered = this.filter(InstallGemDialog.this.nameText.getText(), InstallGemDialog.this.gems);
                            gemsTable.setItemCount(filtered.size());
                            gemsTable.clearAll();
                            InstallGemDialog.this.gemViewer.setInput(filtered);
                        }

                        private Set<Gem> filter(String filter, Set<Gem> gems) {
                            HashSet<Gem> filtered = new HashSet<Gem>();
                            for (Gem gem : gems) {
                                if (!gem.getName().toLowerCase().startsWith(filter)) continue;
                                filtered.add(gem);
                            }
                            return filtered;
                        }
                    });
                }
                InstallGemDialog.this.filterByText = true;
            }
        });
        this.gemViewer = new TableViewer(gemsTable);
        gemsTable.setHeaderVisible(true);
        gemsTable.setLinesVisible(false);
        GridData data = new GridData(768);
        data.heightHint = 400;
        gemsTable.setLayoutData((Object)data);
        TableColumn nameColumn = new TableColumn(gemsTable, 16384);
        nameColumn.setText(GemsMessages.GemsView_NameColumn_label);
        nameColumn.setWidth(150);
        TableColumn versionColumn = new TableColumn(gemsTable, 16384);
        versionColumn.setText(GemsMessages.GemsView_VersionColumn_label);
        versionColumn.setWidth(75);
        TableColumn descriptionColumn = new TableColumn(gemsTable, 16384);
        descriptionColumn.setText(GemsMessages.GemsView_DescriptionColumn_label);
        descriptionColumn.setWidth(275);
        this.gemViewer.setLabelProvider((IBaseLabelProvider)new GemLabelProvider());
        this.gemViewer.setContentProvider((IContentProvider)this.contentProvider);
        TableViewerSorter.bind((TableViewer)this.gemViewer);
        this.gemViewer.setInput(this.gems);
        this.gemViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structured = (IStructuredSelection)selection;
                    Gem gem = (Gem)structured.getFirstElement();
                    if (gem == null) {
                        InstallGemDialog.this.versionCombo.removeAll();
                        return;
                    }
                    InstallGemDialog.this.filterByText = false;
                    InstallGemDialog.this.nameText.setText(gem.getName());
                    InstallGemDialog.this.versionCombo.removeAll();
                    String lastVersion = null;
                    if (gem instanceof LogicalGem) {
                        LogicalGem logical = (LogicalGem)gem;
                        SortedSet versions = logical.getVersions();
                        for (String version : versions) {
                            InstallGemDialog.this.versionCombo.add(version);
                            lastVersion = version;
                        }
                    } else {
                        InstallGemDialog.this.versionCombo.add(gem.getVersion());
                        lastVersion = gem.getVersion();
                    }
                    InstallGemDialog.this.versionCombo.setText(lastVersion);
                }
            }
        });
        this.setGems("http://gems.rubyforge.org");
        return control;
    }

    private void updateTable() {
        this.gemViewer.setInput(this.gems);
        this.gemViewer.getTable().setItemCount(this.gems.size());
        this.gemViewer.refresh();
    }

    protected void setGems(final String url) {
        if (this.gemJob != null) {
            this.gemJob.cancel();
        }
        this.gemJob = new Job("Loading remote gem listing"){

            protected IStatus run(IProgressMonitor gemJobMonitor) {
                if (gemJobMonitor != null && gemJobMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                InstallGemDialog.this.gems = AptanaRDTPlugin.getDefault().getGemManager().getRemoteGems(url, gemJobMonitor);
                if (gemJobMonitor != null && gemJobMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                UIJob updatingTable = new UIJob("Updating gem table"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (monitor != null && monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        if (InstallGemDialog.this.gemViewer != null && !InstallGemDialog.this.gemViewer.getTable().isDisposed()) {
                            InstallGemDialog.this.updateTable();
                        }
                        if (InstallGemDialog.this.nameText != null && !InstallGemDialog.this.nameText.isDisposed()) {
                            InstallGemDialog.this.nameText.setEnabled(true);
                        }
                        if (InstallGemDialog.this.versionCombo != null && !InstallGemDialog.this.versionCombo.isDisposed()) {
                            InstallGemDialog.this.versionCombo.setEnabled(true);
                        }
                        return Status.OK_STATUS;
                    }
                };
                updatingTable.schedule();
                return Status.OK_STATUS;
            }
        };
        this.gemJob.schedule();
    }

    protected void updateSourceURLs() {
        this.sourceURLCombo.removeAll();
        Set urls = AptanaRDTPlugin.getDefault().getGemManager().getSourceURLs();
        for (String url : urls) {
            this.sourceURLCombo.add(url);
        }
    }

    public void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.name = this.nameText.getText();
            this.version = this.versionCombo.getText();
            this.okPressed();
        } else if (buttonId == 1) {
            this.cancelPressed();
        }
    }

    public Gem getGem() {
        return new Gem(this.name, this.version, "");
    }

    public String getSourceURL() {
        return this.sourceURL;
    }

    public boolean close() {
        if (this.refreshImage != null) {
            this.refreshImage.dispose();
        }
        return super.close();
    }
}

