/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.ui.gems;

import com.aptana.rdt.AptanaRDTPlugin;
import com.aptana.rdt.core.gems.Gem;
import com.aptana.rdt.core.gems.GemListener;
import com.aptana.rdt.core.gems.IGemManager;
import com.aptana.rdt.ui.gems.GemLabelProvider;
import com.aptana.rdt.ui.gems.GemManagerSelectionAction;
import com.aptana.rdt.ui.gems.GemsMessages;
import com.aptana.rdt.ui.gems.RemoveGemDialog;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;
import org.rubypeople.rdt.internal.ui.util.CollectionContentProvider;
import org.rubypeople.rdt.ui.TableViewerSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GemsView
extends ViewPart
implements GemListener {
    private TableViewer gemViewer;
    private GemManagerSelectionAction gemManagerSelectionAction;
    private IGemManager gemManager;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.gemViewer = new TableViewer(parent, 65540);
        final Table gemTable = this.gemViewer.getTable();
        gemTable.setHeaderVisible(true);
        gemTable.setLinesVisible(true);
        gemTable.setLayoutData((Object)new GridData(1808));
        gemTable.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    TableItem item = gemTable.getItem(gemTable.getSelectionIndex());
                    final Gem gem = (Gem)item.getData();
                    if (MessageDialog.openConfirm((Shell)gemTable.getShell(), null, (String)GemsMessages.bind((String)GemsMessages.RemoveGemDialog_msg, (Object)gem.getName()))) {
                        Job job = null;
                        if (gem.hasMultipleVersions()) {
                            final RemoveGemDialog dialog = new RemoveGemDialog(Display.getDefault().getActiveShell(), gem.versions());
                            if (dialog.open() == 0) {
                                job = new Job("Removing gem"){

                                    protected IStatus run(IProgressMonitor monitor) {
                                        return GemsView.this.getGemManager().removeGem(new Gem(gem.getName(), dialog.getVersion(), gem.getDescription()), monitor);
                                    }
                                };
                            }
                        } else {
                            job = new Job("Removing gem"){

                                protected IStatus run(IProgressMonitor monitor) {
                                    return GemsView.this.getGemManager().removeGem(gem, monitor);
                                }
                            };
                        }
                        if (job != null) {
                            job.setUser(true);
                            job.schedule();
                        }
                    }
                }
            }
        });
        TableColumn nameColumn = new TableColumn(gemTable, 16384);
        nameColumn.setText(GemsMessages.GemsView_NameColumn_label);
        nameColumn.setWidth(150);
        TableColumn versionColumn = new TableColumn(gemTable, 16384);
        versionColumn.setText(GemsMessages.GemsView_VersionColumn_label);
        versionColumn.setWidth(75);
        TableColumn descriptionColumn = new TableColumn(gemTable, 16384);
        descriptionColumn.setText(GemsMessages.GemsView_DescriptionColumn_label);
        descriptionColumn.setWidth(275);
        this.gemViewer.setLabelProvider((IBaseLabelProvider)new GemLabelProvider());
        this.gemViewer.setContentProvider((IContentProvider)new CollectionContentProvider());
        TableViewerSorter.bind((TableViewer)this.gemViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.gemViewer);
        this.gemViewer.setInput(this.getSortedGems());
        this.createPopupMenu();
        this.getGemManager().addGemListener((GemListener)this);
        this.gemManagerSelectionAction = new GemManagerSelectionAction(this);
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().add((IAction)this.gemManagerSelectionAction);
    }

    public IGemManager getGemManager() {
        if (this.gemManager == null) {
            this.gemManager = AptanaRDTPlugin.getDefault().getGemManager();
        }
        return this.gemManager;
    }

    public void dispose() {
        this.getGemManager().removeGemListener((GemListener)this);
        super.dispose();
    }

    public void setFocus() {
        this.gemViewer.getTable().setFocus();
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IContributionItem[] items = GemsView.this.getViewSite().getActionBars().getToolBarManager().getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i] instanceof ActionContributionItem) {
                        ActionContributionItem aci = (ActionContributionItem)items[i];
                        manager.add(aci.getAction());
                    }
                    ++i;
                }
            }
        });
        menuMgr.add((IContributionItem)new Separator("additions"));
        Menu menu = menuMgr.createContextMenu(this.gemViewer.getControl());
        this.gemViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.gemViewer);
    }

    public void gemsRefreshed() {
        this.doRefresh();
    }

    public void gemUpdated(Gem gem) {
    }

    private void doRefresh() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                GemsView.this.gemViewer.setInput((Object)GemsView.this.getSortedGems());
                GemsView.this.gemViewer.refresh();
            }
        });
    }

    private Set<Gem> getSortedGems() {
        return Collections.unmodifiableSortedSet(new TreeSet(this.getGemManager().getGems()));
    }

    public void gemAdded(Gem gem) {
        this.doRefresh();
    }

    public void gemRemoved(Gem gem) {
        this.doRefresh();
    }

    public void managerInitialized() {
    }

    public void setGemManager(IGemManager gemManager) {
        this.gemManager = gemManager;
        this.doRefresh();
    }
}

