/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.ui.gems;

import com.aptana.rdt.AptanaRDTPlugin;
import com.aptana.rdt.core.gems.IGemManager;
import com.aptana.rdt.ui.AptanaRDTUIPlugin;
import com.aptana.rdt.ui.gems.GemsView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.rubypeople.rdt.ui.IHasImageDescriptor;

class GemManagerSelectionAction
extends Action
implements IMenuCreator {
    private Menu fMenu;
    private GemsView gemsView;

    GemManagerSelectionAction(GemsView gemsView) {
        this.gemsView = gemsView;
        this.setEnabled(this.getGemManagers().length > 0);
        this.setToolTipText("Select a gem repository");
        this.setImageDescriptor(AptanaRDTUIPlugin.imageDescriptorFromPlugin((String)"com.aptana.rdt.ui", (String)"icons/rubygems.png"));
        this.setMenuCreator(this);
    }

    private IGemManager[] getGemManagers() {
        return AptanaRDTPlugin.getDefault().getGemManagers();
    }

    public void dispose() {
    }

    public Menu getMenu(Control parent) {
        IGemManager[] gemManagers;
        if (this.fMenu != null && !this.fMenu.isDisposed()) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        int accel = 1;
        IGemManager[] iGemManagerArray = gemManagers = this.getGemManagers();
        int n = gemManagers.length;
        int n2 = 0;
        while (n2 < n) {
            IGemManager gemManager = iGemManagerArray[n2];
            String label = gemManager.getName();
            ImageDescriptor image = null;
            if (gemManager instanceof IHasImageDescriptor) {
                image = ((IHasImageDescriptor)gemManager).getImageDescriptor();
            }
            this.addActionToMenu(this.fMenu, new GemManagerAction(label, image, gemManager), accel);
            ++accel;
            ++n2;
        }
        return this.fMenu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    private void addActionToMenu(Menu parent, Action action, int accelerator) {
        if (accelerator < 10) {
            StringBuffer label = new StringBuffer();
            label.append('&');
            label.append(accelerator);
            label.append(' ');
            label.append(action.getText());
            action.setText(label.toString());
        }
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    private class GemManagerAction
    extends Action {
        private IGemManager gemManager;

        public GemManagerAction(String label, ImageDescriptor image, IGemManager gemManager) {
            this.setText(label);
            if (image != null) {
                this.setImageDescriptor(image);
            }
            this.gemManager = gemManager;
        }

        public void run() {
            if (GemManagerSelectionAction.this.gemsView != null) {
                GemManagerSelectionAction.this.gemsView.setGemManager(this.gemManager);
            }
        }

        public void runWithEvent(Event event) {
            this.run();
        }
    }
}

